/*
 * Decompiled with CFR 0.152.
 */
package io.github.satya64.powerbi.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.satya64.powerbi.api.model.AccessLevel;
import io.github.satya64.powerbi.api.model.EffectiveIdentity;
import java.util.List;

public class TokenRequest {
    private AccessLevel accessLevel;
    private List<EffectiveIdentity> identities;
    @JsonProperty(defaultValue="false")
    private boolean allowSaveAs;
    private String datasetId;

    TokenRequest(AccessLevel accessLevel, List<EffectiveIdentity> identities, boolean allowSaveAs, String datasetId) {
        this.accessLevel = accessLevel;
        this.identities = identities;
        this.allowSaveAs = allowSaveAs;
        this.datasetId = datasetId;
    }

    public static TokenRequestBuilder builder() {
        return new TokenRequestBuilder();
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public List<EffectiveIdentity> getIdentities() {
        return this.identities;
    }

    public boolean isAllowSaveAs() {
        return this.allowSaveAs;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
    }

    public void setIdentities(List<EffectiveIdentity> identities) {
        this.identities = identities;
    }

    @JsonProperty(defaultValue="false")
    public void setAllowSaveAs(boolean allowSaveAs) {
        this.allowSaveAs = allowSaveAs;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenRequest)) {
            return false;
        }
        TokenRequest other = (TokenRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AccessLevel this$accessLevel = this.getAccessLevel();
        AccessLevel other$accessLevel = other.getAccessLevel();
        if (this$accessLevel == null ? other$accessLevel != null : !((Object)((Object)this$accessLevel)).equals((Object)other$accessLevel)) {
            return false;
        }
        List<EffectiveIdentity> this$identities = this.getIdentities();
        List<EffectiveIdentity> other$identities = other.getIdentities();
        if (this$identities == null ? other$identities != null : !((Object)this$identities).equals(other$identities)) {
            return false;
        }
        if (this.isAllowSaveAs() != other.isAllowSaveAs()) {
            return false;
        }
        String this$datasetId = this.getDatasetId();
        String other$datasetId = other.getDatasetId();
        return !(this$datasetId == null ? other$datasetId != null : !this$datasetId.equals(other$datasetId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TokenRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccessLevel $accessLevel = this.getAccessLevel();
        result = result * 59 + ($accessLevel == null ? 43 : ((Object)((Object)$accessLevel)).hashCode());
        List<EffectiveIdentity> $identities = this.getIdentities();
        result = result * 59 + ($identities == null ? 43 : ((Object)$identities).hashCode());
        result = result * 59 + (this.isAllowSaveAs() ? 79 : 97);
        String $datasetId = this.getDatasetId();
        result = result * 59 + ($datasetId == null ? 43 : $datasetId.hashCode());
        return result;
    }

    public String toString() {
        return "TokenRequest(accessLevel=" + (Object)((Object)this.getAccessLevel()) + ", identities=" + this.getIdentities() + ", allowSaveAs=" + this.isAllowSaveAs() + ", datasetId=" + this.getDatasetId() + ")";
    }

    public static class TokenRequestBuilder {
        private AccessLevel accessLevel;
        private List<EffectiveIdentity> identities;
        private boolean allowSaveAs;
        private String datasetId;

        TokenRequestBuilder() {
        }

        public TokenRequestBuilder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public TokenRequestBuilder identities(List<EffectiveIdentity> identities) {
            this.identities = identities;
            return this;
        }

        @JsonProperty(defaultValue="false")
        public TokenRequestBuilder allowSaveAs(boolean allowSaveAs) {
            this.allowSaveAs = allowSaveAs;
            return this;
        }

        public TokenRequestBuilder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public TokenRequest build() {
            return new TokenRequest(this.accessLevel, this.identities, this.allowSaveAs, this.datasetId);
        }

        public String toString() {
            return "TokenRequest.TokenRequestBuilder(accessLevel=" + (Object)((Object)this.accessLevel) + ", identities=" + this.identities + ", allowSaveAs=" + this.allowSaveAs + ", datasetId=" + this.datasetId + ")";
        }
    }
}

