/*
 * Decompiled with CFR 0.152.
 */
package io.github.satya64.powerbi.api;

import io.github.satya64.powerbi.api.ClientUtils;
import io.github.satya64.powerbi.api.PowerBiClientException;
import io.github.satya64.powerbi.api.model.CloneReportRequest;
import io.github.satya64.powerbi.api.model.Datasource;
import io.github.satya64.powerbi.api.model.Export;
import io.github.satya64.powerbi.api.model.ExportReportRequest;
import io.github.satya64.powerbi.api.model.ODataResponse;
import io.github.satya64.powerbi.api.model.Report;
import io.github.satya64.powerbi.api.services.ReportsService;
import java.io.IOException;
import java.util.List;
import lombok.NonNull;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ReportOperations {
    private ReportsService reportsService;

    public ReportOperations(Retrofit retrofit) {
        this.reportsService = (ReportsService)retrofit.create(ReportsService.class);
    }

    public ODataResponse<List<Report>> getReports() throws IOException, PowerBiClientException {
        Response res = this.reportsService.getReports().execute();
        return (ODataResponse)ClientUtils.buildAndSendResponseBody(res);
    }

    public ODataResponse<List<Report>> getReportsInGroup(@NonNull String groupId) throws IOException, PowerBiClientException {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        Response res = this.reportsService.getReportsInGroup(groupId).execute();
        return (ODataResponse)ClientUtils.buildAndSendResponseBody(res);
    }

    public Report getReport(@NonNull String reportId) throws IOException, PowerBiClientException {
        if (reportId == null) {
            throw new NullPointerException("reportId is marked non-null but is null");
        }
        Response res = this.reportsService.getReport(reportId).execute();
        return (Report)ClientUtils.buildAndSendResponseBody(res);
    }

    public Report getReportInGroup(@NonNull String groupId, @NonNull String reportId) throws IOException, PowerBiClientException {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        if (reportId == null) {
            throw new NullPointerException("reportId is marked non-null but is null");
        }
        Response res = this.reportsService.getReportInGroup(groupId, reportId).execute();
        return (Report)ClientUtils.buildAndSendResponseBody(res);
    }

    public Report cloneReport(@NonNull String reportId, @NonNull CloneReportRequest cloneReportRequest) throws IOException, PowerBiClientException {
        if (reportId == null) {
            throw new NullPointerException("reportId is marked non-null but is null");
        }
        if (cloneReportRequest == null) {
            throw new NullPointerException("cloneReportRequest is marked non-null but is null");
        }
        Response res = this.reportsService.cloneReport(reportId, cloneReportRequest).execute();
        return (Report)ClientUtils.buildAndSendResponseBody(res);
    }

    public Report cloneReportInGroup(@NonNull String groupId, @NonNull String reportId, @NonNull CloneReportRequest cloneReportRequest) throws IOException, PowerBiClientException {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        if (reportId == null) {
            throw new NullPointerException("reportId is marked non-null but is null");
        }
        if (cloneReportRequest == null) {
            throw new NullPointerException("cloneReportRequest is marked non-null but is null");
        }
        Response res = this.reportsService.cloneReportInGroup(groupId, reportId, cloneReportRequest).execute();
        return (Report)ClientUtils.buildAndSendResponseBody(res);
    }

    public ResponseBody exportReport(String reportId) throws IOException, PowerBiClientException {
        Response res = this.reportsService.exportReport(reportId).execute();
        return (ResponseBody)ClientUtils.buildAndSendResponseBody(res);
    }

    public ResponseBody exportReportInGroup(@NonNull String groupId, @NonNull String reportId) throws IOException, PowerBiClientException {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        if (reportId == null) {
            throw new NullPointerException("reportId is marked non-null but is null");
        }
        Response res = this.reportsService.exportReportInGroup(groupId, reportId).execute();
        return (ResponseBody)ClientUtils.buildAndSendResponseBody(res);
    }

    public ODataResponse<List<Datasource>> getReportDatasources(@NonNull String groupId) throws IOException, PowerBiClientException {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        Response res = this.reportsService.getReportDatasources(groupId).execute();
        return (ODataResponse)ClientUtils.buildAndSendResponseBody(res);
    }

    public ODataResponse<List<Datasource>> getReportDatasourcesInGroup(@NonNull String groupId, @NonNull String reportId) throws IOException, PowerBiClientException {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        if (reportId == null) {
            throw new NullPointerException("reportId is marked non-null but is null");
        }
        Response res = this.reportsService.getReportDatasourcesInGroup(groupId, reportId).execute();
        return (ODataResponse)ClientUtils.buildAndSendResponseBody(res);
    }

    public int deleteReport(@NonNull String reportId) throws IOException, PowerBiClientException {
        if (reportId == null) {
            throw new NullPointerException("reportId is marked non-null but is null");
        }
        Response res = this.reportsService.deleteReport(reportId).execute();
        return ClientUtils.buildAndSendResponseCode(res);
    }

    public int deleteReportInGroup(@NonNull String groupId, @NonNull String reportId) throws IOException, PowerBiClientException {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        if (reportId == null) {
            throw new NullPointerException("reportId is marked non-null but is null");
        }
        Response res = this.reportsService.deleteReportInGroup(groupId, reportId).execute();
        return ClientUtils.buildAndSendResponseCode(res);
    }

    public Export exportReportToFile(@NonNull String reportId, @NonNull ExportReportRequest exportReportRequest) throws IOException, PowerBiClientException {
        if (reportId == null) {
            throw new NullPointerException("reportId is marked non-null but is null");
        }
        if (exportReportRequest == null) {
            throw new NullPointerException("exportReportRequest is marked non-null but is null");
        }
        Response res = this.reportsService.exportReportToFile(reportId, exportReportRequest).execute();
        return (Export)ClientUtils.buildAndSendResponseBody(res);
    }

    public Export exportReportInGroupToFile(@NonNull String groupId, @NonNull String reportId, @NonNull ExportReportRequest exportReportRequest) throws IOException, PowerBiClientException {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        if (reportId == null) {
            throw new NullPointerException("reportId is marked non-null but is null");
        }
        if (exportReportRequest == null) {
            throw new NullPointerException("exportReportRequest is marked non-null but is null");
        }
        Response res = this.reportsService.exportReportInGroupToFile(groupId, reportId, exportReportRequest).execute();
        return (Export)ClientUtils.buildAndSendResponseBody(res);
    }

    public Export exportReportToFileStatus(@NonNull String reportId, @NonNull String exportId) throws IOException, PowerBiClientException {
        if (reportId == null) {
            throw new NullPointerException("reportId is marked non-null but is null");
        }
        if (exportId == null) {
            throw new NullPointerException("exportId is marked non-null but is null");
        }
        Response res = this.reportsService.getExportToFileStatus(reportId, exportId).execute();
        return (Export)ClientUtils.buildAndSendResponseBody(res);
    }

    public Export exportReportInGroupToFileStatus(@NonNull String groupId, @NonNull String reportId, @NonNull String exportId) throws IOException, PowerBiClientException {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        if (reportId == null) {
            throw new NullPointerException("reportId is marked non-null but is null");
        }
        if (exportId == null) {
            throw new NullPointerException("exportId is marked non-null but is null");
        }
        Response res = this.reportsService.getExportToFileStatusInGroup(groupId, reportId, exportId).execute();
        return (Export)ClientUtils.buildAndSendResponseBody(res);
    }

    public ResponseBody getFileOfExportToFile(@NonNull String reportId, @NonNull String exportId) throws IOException, PowerBiClientException {
        if (reportId == null) {
            throw new NullPointerException("reportId is marked non-null but is null");
        }
        if (exportId == null) {
            throw new NullPointerException("exportId is marked non-null but is null");
        }
        Response res = this.reportsService.getFileOfExportToFile(reportId, exportId).execute();
        return (ResponseBody)ClientUtils.buildAndSendResponseBody(res);
    }

    public ResponseBody getFileOfExportToFileInGroup(@NonNull String groupId, @NonNull String reportId, @NonNull String exportId) throws IOException, PowerBiClientException {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        if (reportId == null) {
            throw new NullPointerException("reportId is marked non-null but is null");
        }
        if (exportId == null) {
            throw new NullPointerException("exportId is marked non-null but is null");
        }
        Response res = this.reportsService.getFileOfExportToFileInGroup(groupId, reportId, exportId).execute();
        return (ResponseBody)ClientUtils.buildAndSendResponseBody(res);
    }
}

