/*
 * Decompiled with CFR 0.152.
 */
package io.github.satya64.powerbi.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.satya64.powerbi.api.Error;
import io.github.satya64.powerbi.api.ErrorMessage;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class PowerBiClientException
extends Exception {
    private static final Logger log = LoggerFactory.getLogger(PowerBiClientException.class);
    private ObjectMapper objectMapper = new ObjectMapper();
    private ErrorMessage message;

    private PowerBiClientException() {
    }

    public PowerBiClientException(Response errorResponse) {
        try {
            String err = errorResponse.errorBody().string();
            if (!err.isEmpty()) {
                this.readErrorMessageFromStream(err);
            } else {
                this.message = ErrorMessage.builder().error(Error.builder().code("InvalidRequest").message("Bad data submitted").build()).build();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readErrorMessageFromStream(String error) {
        try {
            this.message = (ErrorMessage)this.objectMapper.readValue(error, ErrorMessage.class);
        }
        catch (IOException e) {
            this.message = ErrorMessage.builder().error(Error.builder().code("UnknownError").message(e.getMessage()).build()).build();
        }
    }

    @Override
    public String getMessage() {
        return this.message != null ? this.message.toString() : null;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

