/*
 * Decompiled with CFR 0.152.
 */
package io.github.satya64.powerbi.api;

import io.github.satya64.powerbi.api.AuthHeaderInterceptor;
import io.github.satya64.powerbi.api.DatasetOperations;
import io.github.satya64.powerbi.api.EmbedTokenOperations;
import io.github.satya64.powerbi.api.GroupOperations;
import io.github.satya64.powerbi.api.ReportOperations;
import lombok.NonNull;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public final class PowerBiClient {
    private static final Logger log = LoggerFactory.getLogger(PowerBiClient.class);
    private static volatile PowerBiClient INSTANCE;
    private Retrofit retrofit;
    private ReportOperations reportOperations;
    private DatasetOperations datasetOperations;
    private EmbedTokenOperations embedTokenOperations;
    private GroupOperations groupOperations;

    private PowerBiClient(Retrofit.Builder retrofit) {
        this.retrofit = retrofit.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PowerBiClient getInstance(String accessToken) {
        if (INSTANCE != null) return INSTANCE;
        Class<PowerBiClient> clazz = PowerBiClient.class;
        synchronized (PowerBiClient.class) {
            INSTANCE = new PowerBiClient(PowerBiClient.buildRetrofitClient(accessToken));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void updateAccessToken(String accessToken) {
        this.retrofit = PowerBiClient.buildRetrofitClient(accessToken).build();
        this.reportOperations = null;
        this.embedTokenOperations = null;
        this.datasetOperations = null;
        this.groupOperations = null;
    }

    private static OkHttpClient.Builder buildOkHttpClient(@NonNull String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthHeaderInterceptor(accessToken));
    }

    private static Retrofit.Builder buildRetrofitClient(@NonNull String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        return new Retrofit.Builder().baseUrl("https://api.powerbi.com/v1.0/myorg/").client(PowerBiClient.buildOkHttpClient(accessToken).build()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create());
    }

    public GroupOperations getGroupOperations() {
        if (this.groupOperations == null) {
            this.groupOperations = new GroupOperations(this.retrofit);
        }
        return this.groupOperations;
    }

    public ReportOperations getReportsOperations() {
        if (this.reportOperations == null) {
            this.reportOperations = new ReportOperations(this.retrofit);
        }
        return this.reportOperations;
    }

    public DatasetOperations getDatasetOperations() {
        if (this.datasetOperations == null) {
            this.datasetOperations = new DatasetOperations(this.retrofit);
        }
        return this.datasetOperations;
    }

    public EmbedTokenOperations getEmbedTokenOperations() {
        if (this.embedTokenOperations == null) {
            this.embedTokenOperations = new EmbedTokenOperations(this.retrofit);
        }
        return this.embedTokenOperations;
    }
}

