/*
 * Decompiled with CFR 0.152.
 */
package io.github.satya64.powerbi.api;

import io.github.satya64.powerbi.api.ClientUtils;
import io.github.satya64.powerbi.api.PowerBiClientException;
import io.github.satya64.powerbi.api.model.Group;
import io.github.satya64.powerbi.api.model.GroupCreationRequest;
import io.github.satya64.powerbi.api.model.GroupUser;
import io.github.satya64.powerbi.api.model.ODataResponse;
import io.github.satya64.powerbi.api.services.GroupsService;
import java.io.IOException;
import java.util.List;
import retrofit2.Response;
import retrofit2.Retrofit;

public class GroupOperations {
    private GroupsService groupsService;

    public GroupOperations(Retrofit retrofit) {
        this.groupsService = (GroupsService)retrofit.create(GroupsService.class);
    }

    public ODataResponse<List<Group>> getGroups() throws IOException, PowerBiClientException {
        Response res = this.groupsService.getGroups().execute();
        return (ODataResponse)ClientUtils.buildAndSendResponseBody(res);
    }

    public ODataResponse<List<Group>> createGroup(GroupCreationRequest groupCreationRequest) throws IOException, PowerBiClientException {
        Response res = this.groupsService.createGroup(groupCreationRequest).execute();
        return (ODataResponse)ClientUtils.buildAndSendResponseBody(res);
    }

    public int deleteGroup(String groupId) throws IOException, PowerBiClientException {
        Response res = this.groupsService.deleteGroup(groupId).execute();
        return ClientUtils.buildAndSendResponseCode(res);
    }

    public int deleteUserInGroup(String groupId, String user) throws IOException, PowerBiClientException {
        Response res = this.groupsService.deleteUserInGroup(groupId, user).execute();
        return ClientUtils.buildAndSendResponseCode(res);
    }

    public ODataResponse<List<GroupUser>> getGroupUsers(String groupId) throws IOException, PowerBiClientException {
        Response res = this.groupsService.getGroupUsers(groupId).execute();
        return (ODataResponse)ClientUtils.buildAndSendResponseBody(res);
    }

    public int addGroupUser(String groupId, GroupUser groupUser) throws IOException, PowerBiClientException {
        Response res = this.groupsService.addGroupUser(groupId, groupUser).execute();
        return ClientUtils.buildAndSendResponseCode(res);
    }

    public int updateGroupUser(String groupId, GroupUser groupUser) throws IOException, PowerBiClientException {
        Response res = this.groupsService.updateGroupUser(groupId, groupUser).execute();
        return ClientUtils.buildAndSendResponseCode(res);
    }
}

