/*
 * Decompiled with CFR 0.152.
 */
package io.github.satya64.powerbi.api;

import io.github.satya64.powerbi.api.ClientUtils;
import io.github.satya64.powerbi.api.PowerBiClientException;
import io.github.satya64.powerbi.api.model.EmbedToken;
import io.github.satya64.powerbi.api.model.TokenRequest;
import io.github.satya64.powerbi.api.model.TokenRequestV2;
import io.github.satya64.powerbi.api.services.EmbedTokenService;
import java.io.IOException;
import lombok.NonNull;
import retrofit2.Response;
import retrofit2.Retrofit;

public class EmbedTokenOperations {
    private EmbedTokenService embedTokenService;

    public EmbedTokenOperations(Retrofit retrofit) {
        this.embedTokenService = (EmbedTokenService)retrofit.create(EmbedTokenService.class);
    }

    public EmbedToken generateReportTokenInGroup(@NonNull String groupId, @NonNull String reportId, @NonNull TokenRequest tokenRequest) throws IOException, PowerBiClientException {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        if (reportId == null) {
            throw new NullPointerException("reportId is marked non-null but is null");
        }
        if (tokenRequest == null) {
            throw new NullPointerException("tokenRequest is marked non-null but is null");
        }
        Response res = this.embedTokenService.generateReportTokenInGroup(groupId, reportId, tokenRequest).execute();
        return (EmbedToken)ClientUtils.buildAndSendResponseBody(res);
    }

    public EmbedToken generateReportTokenForCreateInGroup(@NonNull String groupId, @NonNull TokenRequest tokenRequest) throws IOException, PowerBiClientException {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        if (tokenRequest == null) {
            throw new NullPointerException("tokenRequest is marked non-null but is null");
        }
        Response res = this.embedTokenService.generateReportTokenForCreateInGroup(groupId, tokenRequest).execute();
        return (EmbedToken)ClientUtils.buildAndSendResponseBody(res);
    }

    public EmbedToken generateToken(@NonNull TokenRequestV2 tokenRequestV2) throws IOException, PowerBiClientException {
        if (tokenRequestV2 == null) {
            throw new NullPointerException("tokenRequestV2 is marked non-null but is null");
        }
        Response res = this.embedTokenService.generateToken(tokenRequestV2).execute();
        return (EmbedToken)ClientUtils.buildAndSendResponseBody(res);
    }

    public EmbedToken generateDatasetTokenInGroup(@NonNull String groupId, @NonNull String datasetId, @NonNull TokenRequest tokenRequest) throws IOException, PowerBiClientException {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        if (datasetId == null) {
            throw new NullPointerException("datasetId is marked non-null but is null");
        }
        if (tokenRequest == null) {
            throw new NullPointerException("tokenRequest is marked non-null but is null");
        }
        Response res = this.embedTokenService.generateDatasetTokenInGroup(groupId, datasetId, tokenRequest).execute();
        return (EmbedToken)ClientUtils.buildAndSendResponseBody(res);
    }

    public EmbedToken generateDashboardTokenInGroup(@NonNull String groupId, @NonNull String datasetId, @NonNull TokenRequest tokenRequest) throws IOException, PowerBiClientException {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        if (datasetId == null) {
            throw new NullPointerException("datasetId is marked non-null but is null");
        }
        if (tokenRequest == null) {
            throw new NullPointerException("tokenRequest is marked non-null but is null");
        }
        Response res = this.embedTokenService.generateDashboardTokenInGroup(groupId, datasetId, tokenRequest).execute();
        return (EmbedToken)ClientUtils.buildAndSendResponseBody(res);
    }

    public EmbedToken generateTileTokenInGroup(@NonNull String groupId, @NonNull String dashboardId, @NonNull String tileId, @NonNull TokenRequest tokenRequest) throws IOException, PowerBiClientException {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        if (dashboardId == null) {
            throw new NullPointerException("dashboardId is marked non-null but is null");
        }
        if (tileId == null) {
            throw new NullPointerException("tileId is marked non-null but is null");
        }
        if (tokenRequest == null) {
            throw new NullPointerException("tokenRequest is marked non-null but is null");
        }
        Response res = this.embedTokenService.generateTileTokenInGroup(groupId, dashboardId, tileId, tokenRequest).execute();
        return (EmbedToken)ClientUtils.buildAndSendResponseBody(res);
    }
}

