/*
 * Decompiled with CFR 0.152.
 */
package io.github.satya64.powerbi.api;

import io.github.satya64.powerbi.api.ClientUtils;
import io.github.satya64.powerbi.api.PowerBiClientException;
import io.github.satya64.powerbi.api.model.Dataset;
import io.github.satya64.powerbi.api.model.ODataResponse;
import io.github.satya64.powerbi.api.services.DatasetsService;
import java.io.IOException;
import java.util.List;
import lombok.NonNull;
import retrofit2.Response;
import retrofit2.Retrofit;

public class DatasetOperations {
    private DatasetsService datasetsService;

    public DatasetOperations(Retrofit retrofit) {
        this.datasetsService = (DatasetsService)retrofit.create(DatasetsService.class);
    }

    public ODataResponse<List<Dataset>> getDatasets() throws IOException, PowerBiClientException {
        Response res = this.datasetsService.getDatasets().execute();
        return (ODataResponse)ClientUtils.buildAndSendResponseBody(res);
    }

    public ODataResponse<List<Dataset>> getDatasetsInGroup(@NonNull String groupId) throws IOException, PowerBiClientException {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        Response res = this.datasetsService.getDatasetsInGroup(groupId).execute();
        return (ODataResponse)ClientUtils.buildAndSendResponseBody(res);
    }

    public Dataset getDataset(@NonNull String datasetId) throws IOException, PowerBiClientException {
        if (datasetId == null) {
            throw new NullPointerException("datasetId is marked non-null but is null");
        }
        Response res = this.datasetsService.getDataset(datasetId).execute();
        return (Dataset)ClientUtils.buildAndSendResponseBody(res);
    }

    public Dataset getDatasetInGroup(@NonNull String groupId, @NonNull String datasetId) throws IOException, PowerBiClientException {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        if (datasetId == null) {
            throw new NullPointerException("datasetId is marked non-null but is null");
        }
        Response res = this.datasetsService.getDatasetInGroup(groupId, datasetId).execute();
        return (Dataset)ClientUtils.buildAndSendResponseBody(res);
    }

    public int deleteDatasetInGroup(@NonNull String groupId, @NonNull String datasetId) throws IOException, PowerBiClientException {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        if (datasetId == null) {
            throw new NullPointerException("datasetId is marked non-null but is null");
        }
        Response res = this.datasetsService.deleteDatasetInGroup(groupId, datasetId).execute();
        return ClientUtils.buildAndSendResponseCode(res);
    }

    public int deleteDataset(@NonNull String datasetId) throws IOException, PowerBiClientException {
        if (datasetId == null) {
            throw new NullPointerException("datasetId is marked non-null but is null");
        }
        Response res = this.datasetsService.deleteDataset(datasetId).execute();
        return ClientUtils.buildAndSendResponseCode(res);
    }
}

