/*
 * This Java source file was generated by the Gradle 'init' task.
 */
package io.github.satya64.powerbi.api;

import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

/**
 *  Class to handle PowerBI REST API calls through the use of Type-safe HTTP client Retrofit
 */
@Slf4j
public final class PowerBiClient {

    private static volatile PowerBiClient INSTANCE;

    private Retrofit retrofit;

    private ReportOperations reportOperations;
    private DatasetOperations datasetOperations;
    private EmbedTokenOperations embedTokenOperations;
    private GroupOperations groupOperations;

    /**
     * @param retrofit retrofit HTTP client
     */
    private PowerBiClient(Retrofit.Builder retrofit) {
        this.retrofit = retrofit.build();
    }

    /**
     * @param accessToken access token to powerbi REST API
     * @return PowerBiClient
     */
    public static PowerBiClient getInstance(final String accessToken) {
        if (INSTANCE == null) {
            synchronized (PowerBiClient.class) {
                INSTANCE = new PowerBiClient(buildRetrofitClient(accessToken));
            }
        }
        return INSTANCE;
    }

    /**
     * @param accessToken access token to powerbi REST API
     */
    public void updateAccessToken(final String accessToken) {
        retrofit = buildRetrofitClient(accessToken).build();
        reportOperations = null;
        embedTokenOperations = null;
        datasetOperations = null;
        groupOperations = null;
    }

    /**
     * @param accessToken access token to powerbi REST API
     * @return OkHttpClient.Builder
     */
    private static OkHttpClient.Builder buildOkHttpClient(@NonNull String accessToken) {
        return new OkHttpClient.Builder()
                .addInterceptor(new AuthHeaderInterceptor(accessToken));
    }

    /**
     * @param accessToken access token to powerbi REST API
     * @return Retrofit.Builder
     */
    private static Retrofit.Builder buildRetrofitClient(@NonNull String accessToken) {
        return new Retrofit.Builder().baseUrl("https://api.powerbi.com/v1.0/myorg/")
                .client(buildOkHttpClient(accessToken).build())
                .addConverterFactory(JacksonConverterFactory.create());
    }

    /**
     * @return GroupOperations
     */
    public GroupOperations getGroupOperations() {
        if (groupOperations == null)
            groupOperations = new GroupOperations(retrofit);
        return groupOperations;
    }

    /**
     * @return ReportOperations
     */
    public ReportOperations getReportsOperations() {
        if (reportOperations == null)
            reportOperations = new ReportOperations(retrofit);
        return reportOperations;
    }

    /**
     * @return DatasetOperations
     */
    public DatasetOperations getDatasetOperations() {
        if (datasetOperations == null)
            datasetOperations = new DatasetOperations(retrofit);
        return datasetOperations;
    }

    /**
     * @return EmbedTokenOperations
     */
    public EmbedTokenOperations getEmbedTokenOperations() {
        if (embedTokenOperations == null)
            embedTokenOperations = new EmbedTokenOperations(retrofit);
        return embedTokenOperations;
    }

}
