/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamsesso.jsonlogic.evaluator.expressions;

import io.github.jamsesso.jsonlogic.evaluator.JsonLogicEvaluationException;
import io.github.jamsesso.jsonlogic.evaluator.expressions.PreEvaluatedArgumentsExpression;
import io.github.jamsesso.jsonlogic.utils.ArrayLike;
import io.github.jamsesso.jsonlogic.utils.MapLike;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MissingExpression
implements PreEvaluatedArgumentsExpression {
    public static final MissingExpression ALL = new MissingExpression(false);
    public static final MissingExpression SOME = new MissingExpression(true);
    private final boolean isSome;

    private MissingExpression(boolean isSome) {
        this.isSome = isSome;
    }

    @Override
    public String key() {
        return this.isSome ? "missing_some" : "missing";
    }

    @Override
    public Object evaluate(List arguments, Object data) throws JsonLogicEvaluationException {
        if (!MapLike.isEligible(data)) {
            return arguments;
        }
        if (!(!this.isSome || ArrayLike.isEligible(arguments.get(1)) && arguments.get(0) instanceof Double)) {
            throw new JsonLogicEvaluationException("missing_some expects first argument to be an integer and the second argument to be an array");
        }
        MapLike map = new MapLike(data);
        List<Object> options = this.isSome ? new ArrayLike(arguments.get(1)) : arguments;
        Set providedKeys = MissingExpression.getFlatKeys(map);
        LinkedHashSet requiredKeys = new LinkedHashSet(options);
        requiredKeys.removeAll(providedKeys);
        if (this.isSome && options.size() - requiredKeys.size() >= ((Double)arguments.get(0)).intValue()) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(requiredKeys);
    }

    private static Set getFlatKeys(Map map) {
        return MissingExpression.getFlatKeys(map, "");
    }

    private static Set getFlatKeys(Map map, String prefix) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (Map.Entry pair : map.entrySet()) {
            Map.Entry entry = pair;
            if (MapLike.isEligible(entry.getValue())) {
                keys.addAll(MissingExpression.getFlatKeys(new MapLike(entry.getValue()), prefix + entry.getKey() + "."));
                continue;
            }
            keys.add(prefix + entry.getKey());
        }
        return keys;
    }
}

