/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamsesso.jsonlogic.evaluator;

import io.github.jamsesso.jsonlogic.ast.JsonLogicArray;
import io.github.jamsesso.jsonlogic.ast.JsonLogicNode;
import io.github.jamsesso.jsonlogic.ast.JsonLogicNumber;
import io.github.jamsesso.jsonlogic.ast.JsonLogicOperation;
import io.github.jamsesso.jsonlogic.ast.JsonLogicPrimitive;
import io.github.jamsesso.jsonlogic.ast.JsonLogicVariable;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicEvaluationException;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicExpression;
import io.github.jamsesso.jsonlogic.utils.ArrayLike;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JsonLogicEvaluator {
    private final Map<String, JsonLogicExpression> expressions = new HashMap<String, JsonLogicExpression>();

    public JsonLogicEvaluator(Collection<JsonLogicExpression> expressions) {
        for (JsonLogicExpression expression : expressions) {
            this.expressions.put(expression.key(), expression);
        }
    }

    public Object evaluate(JsonLogicNode node, Object data) throws JsonLogicEvaluationException {
        switch (node.getType()) {
            case PRIMITIVE: {
                return this.evaluate((JsonLogicPrimitive)node);
            }
            case VARIABLE: {
                return this.evaluate((JsonLogicVariable)node, data);
            }
            case ARRAY: {
                return this.evaluate((JsonLogicArray)node, data);
            }
        }
        return this.evaluate((JsonLogicOperation)node, data);
    }

    public Object evaluate(JsonLogicPrimitive<?> primitive) {
        switch (primitive.getPrimitiveType()) {
            case NUMBER: {
                return ((JsonLogicNumber)primitive).getValue();
            }
        }
        return primitive.getValue();
    }

    public Object evaluate(JsonLogicVariable variable, Object data) throws JsonLogicEvaluationException {
        Object defaultValue = this.evaluate(variable.getDefaultValue(), null);
        if (data == null) {
            return defaultValue;
        }
        Object key = this.evaluate(variable.getKey(), data);
        if (key == null) {
            return Optional.of(data).map(JsonLogicEvaluator::transform).orElse(this.evaluate(variable.getDefaultValue(), null));
        }
        if (key instanceof Number) {
            int index = ((Number)key).intValue();
            if (ArrayLike.isEligible(data)) {
                ArrayLike list = new ArrayLike(data);
                if (index >= 0 && index < list.size()) {
                    return JsonLogicEvaluator.transform(list.get(index));
                }
            }
            return defaultValue;
        }
        if (key instanceof String) {
            String name = (String)key;
            if (name.isEmpty()) {
                return data;
            }
            String[] keys = name.split("\\.");
            Object result = data;
            for (String partial : keys) {
                if ((result = this.evaluatePartialVariable(partial, result)) != null) continue;
                return defaultValue;
            }
            return result;
        }
        throw new JsonLogicEvaluationException("var first argument must be null, number, or string");
    }

    private Object evaluatePartialVariable(String key, Object data) throws JsonLogicEvaluationException {
        if (ArrayLike.isEligible(data)) {
            int index;
            ArrayLike list = new ArrayLike(data);
            try {
                index = Integer.parseInt(key);
            }
            catch (NumberFormatException e) {
                throw new JsonLogicEvaluationException(e);
            }
            if (index < 0 || index > list.size()) {
                return null;
            }
            return JsonLogicEvaluator.transform(list.get(index));
        }
        if (data instanceof Map) {
            return JsonLogicEvaluator.transform(((Map)data).get(key));
        }
        return null;
    }

    public List<Object> evaluate(JsonLogicArray array, Object data) throws JsonLogicEvaluationException {
        ArrayList<Object> values = new ArrayList<Object>(array.size());
        for (JsonLogicNode element : array) {
            values.add(this.evaluate(element, data));
        }
        return values;
    }

    public Object evaluate(JsonLogicOperation operation, Object data) throws JsonLogicEvaluationException {
        JsonLogicExpression handler = this.expressions.get(operation.getOperator());
        if (handler == null) {
            throw new JsonLogicEvaluationException("Undefined operation '" + operation.getOperator() + "'");
        }
        return handler.evaluate(this, operation.getArguments(), data);
    }

    public static Object transform(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return value;
    }
}

