/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.extras.constant;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.MethodType;
import java.util.Set;

public final class ConstantUtils {
    public static final ConstantDesc[] EMPTY_CONSTANTDESC = new ConstantDesc[0];
    public static final ClassDesc[] EMPTY_CLASSDESC = new ClassDesc[0];
    public static final int MAX_ARRAY_TYPE_DESC_DIMENSIONS = 255;
    public static final ClassDesc CD_module_info = ConstantUtils.binaryNameToDesc("module-info");
    public static ClassDesc CD_Object_array;
    private static final Set<String> pointyNames;
    private static final char JVM_SIGNATURE_ARRAY = '[';
    private static final char JVM_SIGNATURE_BYTE = 'B';
    private static final char JVM_SIGNATURE_CHAR = 'C';
    private static final char JVM_SIGNATURE_CLASS = 'L';
    private static final char JVM_SIGNATURE_FLOAT = 'F';
    private static final char JVM_SIGNATURE_DOUBLE = 'D';
    private static final char JVM_SIGNATURE_INT = 'I';
    private static final char JVM_SIGNATURE_LONG = 'J';
    private static final char JVM_SIGNATURE_SHORT = 'S';
    private static final char JVM_SIGNATURE_VOID = 'V';
    private static final char JVM_SIGNATURE_BOOLEAN = 'Z';

    private ConstantUtils() {
    }

    public static ClassDesc binaryNameToDesc(String binaryName) {
        return ClassDesc.of(binaryName);
    }

    public static ClassDesc internalNameToDesc(String internalName) {
        return ClassDesc.ofDescriptor(ConstantUtils.concat("L", internalName, ";"));
    }

    public static ClassDesc classDesc(Class<?> type) {
        return type.describeConstable().orElseThrow();
    }

    public static ClassDesc referenceClassDesc(Class<?> type) {
        return type.describeConstable().orElseThrow();
    }

    public static ClassDesc referenceClassDesc(String descriptor) {
        return ClassDesc.ofDescriptor(descriptor);
    }

    public static MethodTypeDesc methodTypeDesc(MethodType type) {
        return type.describeConstable().orElseThrow();
    }

    public static MethodTypeDesc methodTypeDesc(Class<?> returnType, Class<?>[] parameterTypes) {
        return MethodType.methodType(returnType, parameterTypes).describeConstable().orElseThrow();
    }

    private static String validateClassOrPackageName(String name, boolean slashSeparator, boolean allowEmpty) {
        int len = name.length();
        if (allowEmpty && len == 0) {
            return name;
        }
        int afterSeparator = 0;
        for (int i = 0; i < len; ++i) {
            boolean foundSlash;
            char ch = name.charAt(i);
            if (ch == ';' || ch == '[') {
                throw ConstantUtils.invalidClassName(name);
            }
            boolean bl = foundSlash = ch == '/';
            if (!foundSlash && ch != '.') continue;
            if (foundSlash != slashSeparator || i == afterSeparator) {
                throw ConstantUtils.invalidClassName(name);
            }
            afterSeparator = i + 1;
        }
        if (len == afterSeparator) {
            throw ConstantUtils.invalidClassName(name);
        }
        return name;
    }

    public static String validateBinaryClassName(String name) {
        return ConstantUtils.validateClassOrPackageName(name, false, false);
    }

    public static String validateInternalClassName(String name) {
        return ConstantUtils.validateClassOrPackageName(name, true, false);
    }

    public static String validateBinaryPackageName(String name) {
        return ConstantUtils.validateClassOrPackageName(name, false, true);
    }

    public static String validateInternalPackageName(String name) {
        return ConstantUtils.validateClassOrPackageName(name, true, true);
    }

    public static String validateModuleName(String name) {
        for (int i = name.length() - 1; i >= 0; --i) {
            char ch = name.charAt(i);
            if ((ch < '\u0000' || ch > '\u001f') && (ch != '\\' && ch != ':' && ch != '@' || i != 0 && name.charAt(--i) == '\\')) continue;
            throw new IllegalArgumentException("Invalid module name: " + name);
        }
        return name;
    }

    public static String validateMemberName(String name, boolean method) {
        int len = name.length();
        if (len == 0) {
            throw new IllegalArgumentException("zero-length member name");
        }
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') continue;
            if (ch == '.' || ch == ';' || ch == '[' || ch == '/') {
                throw new IllegalArgumentException("Invalid member name: " + name);
            }
            if (!method || ch != '<' && ch != '>' || pointyNames.contains(name)) continue;
            throw new IllegalArgumentException("Invalid member name: " + name);
        }
        return name;
    }

    public static void validateClassOrInterface(ClassDesc classDesc) {
        if (!classDesc.isClassOrInterface()) {
            throw new IllegalArgumentException("not a class or interface type: " + String.valueOf(classDesc));
        }
    }

    public static void validateArrayRank(int rank) {
        if (rank == 0 || (rank & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException(ConstantUtils.invalidArrayRankMessage(rank));
        }
    }

    public static int arrayDepth(String descriptorString, int off) {
        int depth = 0;
        while (descriptorString.charAt(off) == '[') {
            ++depth;
            ++off;
        }
        return depth;
    }

    public static String binaryToInternal(String name) {
        return name.replace('.', '/');
    }

    public static String internalToBinary(String name) {
        return name.replace('/', '.');
    }

    public static String dropFirstAndLastChar(String s) {
        return s.substring(1, s.length() - 1);
    }

    public static ClassDesc forPrimitiveType(String descriptor, int offset) {
        return switch (descriptor.charAt(offset)) {
            case 'B' -> ConstantDescs.CD_byte;
            case 'C' -> ConstantDescs.CD_char;
            case 'F' -> ConstantDescs.CD_float;
            case 'D' -> ConstantDescs.CD_double;
            case 'I' -> ConstantDescs.CD_int;
            case 'J' -> ConstantDescs.CD_long;
            case 'S' -> ConstantDescs.CD_short;
            case 'V' -> ConstantDescs.CD_void;
            case 'Z' -> ConstantDescs.CD_boolean;
            default -> throw ConstantUtils.badMethodDescriptor(descriptor);
        };
    }

    static String invalidArrayRankMessage(int rank) {
        return "Array rank must be within [1, 255]: " + rank;
    }

    static IllegalArgumentException invalidClassName(String className) {
        return new IllegalArgumentException("Invalid class name: ".concat(className));
    }

    static IllegalArgumentException badMethodDescriptor(String descriptor) {
        return new IllegalArgumentException("Bad method descriptor: " + descriptor);
    }

    static int skipOverFieldSignature(String descriptor, int start, int end) {
        int arrayDim = 0;
        int index = start;
        if (index < end) {
            char ch;
            while ((ch = descriptor.charAt(index++)) == '[') {
                ++arrayDim;
            }
            if (arrayDim > 255) {
                throw ConstantUtils.maxArrayTypeDescDimensions();
            }
            switch (ch) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    return index - start;
                }
                case 'L': {
                    int afterSeparator = index + 1;
                    while (index < end) {
                        if ((ch = descriptor.charAt(index++)) == ';') {
                            return index == afterSeparator ? 0 : index - start;
                        }
                        if (ch == '.' || ch == '[') {
                            return 0;
                        }
                        if (ch != '/') continue;
                        if (index == afterSeparator) {
                            return 0;
                        }
                        afterSeparator = index + 1;
                    }
                    break;
                }
            }
        }
        return 0;
    }

    private static IllegalArgumentException maxArrayTypeDescDimensions() {
        return new IllegalArgumentException(String.format("Cannot create an array type descriptor with more than %d dimensions", 255));
    }

    public static String concat(String prefix, Object value, String suffix) {
        return prefix + String.valueOf(value) + suffix;
    }

    static {
        pointyNames = Set.of("<init>", "<clinit>");
    }
}

