/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile;

import io.github.dmlloyd.classfile.Annotation;
import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.impl.TargetInfoImpl;
import io.github.dmlloyd.classfile.impl.UnboundAttribute;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface TypeAnnotation {
    public TargetInfo targetInfo();

    public List<TypePathComponent> targetPath();

    public Annotation annotation();

    public static TypeAnnotation of(TargetInfo targetInfo, List<TypePathComponent> targetPath, Annotation annotation) {
        return new UnboundAttribute.UnboundTypeAnnotation(targetInfo, targetPath, annotation);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface TargetInfo {
        public static final int TARGET_CLASS_TYPE_PARAMETER = 0;
        public static final int TARGET_METHOD_TYPE_PARAMETER = 1;
        public static final int TARGET_CLASS_EXTENDS = 16;
        public static final int TARGET_CLASS_TYPE_PARAMETER_BOUND = 17;
        public static final int TARGET_METHOD_TYPE_PARAMETER_BOUND = 18;
        public static final int TARGET_FIELD = 19;
        public static final int TARGET_METHOD_RETURN = 20;
        public static final int TARGET_METHOD_RECEIVER = 21;
        public static final int TARGET_METHOD_FORMAL_PARAMETER = 22;
        public static final int TARGET_THROWS = 23;
        public static final int TARGET_LOCAL_VARIABLE = 64;
        public static final int TARGET_RESOURCE_VARIABLE = 65;
        public static final int TARGET_EXCEPTION_PARAMETER = 66;
        public static final int TARGET_INSTANCEOF = 67;
        public static final int TARGET_NEW = 68;
        public static final int TARGET_CONSTRUCTOR_REFERENCE = 69;
        public static final int TARGET_METHOD_REFERENCE = 70;
        public static final int TARGET_CAST = 71;
        public static final int TARGET_CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT = 72;
        public static final int TARGET_METHOD_INVOCATION_TYPE_ARGUMENT = 73;
        public static final int TARGET_CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT = 74;
        public static final int TARGET_METHOD_REFERENCE_TYPE_ARGUMENT = 75;

        public TargetType targetType();

        default public int size() {
            return this.targetType().sizeIfFixed;
        }

        public static TypeParameterTarget ofTypeParameter(TargetType targetType, int typeParameterIndex) {
            return new TargetInfoImpl.TypeParameterTargetImpl(targetType, typeParameterIndex);
        }

        public static TypeParameterTarget ofClassTypeParameter(int typeParameterIndex) {
            return TargetInfo.ofTypeParameter(TargetType.CLASS_TYPE_PARAMETER, typeParameterIndex);
        }

        public static TypeParameterTarget ofMethodTypeParameter(int typeParameterIndex) {
            return TargetInfo.ofTypeParameter(TargetType.METHOD_TYPE_PARAMETER, typeParameterIndex);
        }

        public static SupertypeTarget ofClassExtends(int supertypeIndex) {
            return new TargetInfoImpl.SupertypeTargetImpl(supertypeIndex);
        }

        public static TypeParameterBoundTarget ofTypeParameterBound(TargetType targetType, int typeParameterIndex, int boundIndex) {
            return new TargetInfoImpl.TypeParameterBoundTargetImpl(targetType, typeParameterIndex, boundIndex);
        }

        public static TypeParameterBoundTarget ofClassTypeParameterBound(int typeParameterIndex, int boundIndex) {
            return TargetInfo.ofTypeParameterBound(TargetType.CLASS_TYPE_PARAMETER_BOUND, typeParameterIndex, boundIndex);
        }

        public static TypeParameterBoundTarget ofMethodTypeParameterBound(int typeParameterIndex, int boundIndex) {
            return TargetInfo.ofTypeParameterBound(TargetType.METHOD_TYPE_PARAMETER_BOUND, typeParameterIndex, boundIndex);
        }

        public static EmptyTarget of(TargetType targetType) {
            return new TargetInfoImpl.EmptyTargetImpl(targetType);
        }

        public static EmptyTarget ofField() {
            return TargetInfo.of(TargetType.FIELD);
        }

        public static EmptyTarget ofMethodReturn() {
            return TargetInfo.of(TargetType.METHOD_RETURN);
        }

        public static EmptyTarget ofMethodReceiver() {
            return TargetInfo.of(TargetType.METHOD_RECEIVER);
        }

        public static FormalParameterTarget ofMethodFormalParameter(int formalParameterIndex) {
            return new TargetInfoImpl.FormalParameterTargetImpl(formalParameterIndex);
        }

        public static ThrowsTarget ofThrows(int throwsTargetIndex) {
            return new TargetInfoImpl.ThrowsTargetImpl(throwsTargetIndex);
        }

        public static LocalVarTarget ofVariable(TargetType targetType, List<LocalVarTargetInfo> table) {
            return new TargetInfoImpl.LocalVarTargetImpl(targetType, table);
        }

        public static LocalVarTarget ofLocalVariable(List<LocalVarTargetInfo> table) {
            return TargetInfo.ofVariable(TargetType.LOCAL_VARIABLE, table);
        }

        public static LocalVarTarget ofResourceVariable(List<LocalVarTargetInfo> table) {
            return TargetInfo.ofVariable(TargetType.RESOURCE_VARIABLE, table);
        }

        public static CatchTarget ofExceptionParameter(int exceptionTableIndex) {
            return new TargetInfoImpl.CatchTargetImpl(exceptionTableIndex);
        }

        public static OffsetTarget ofOffset(TargetType targetType, Label target) {
            return new TargetInfoImpl.OffsetTargetImpl(targetType, target);
        }

        public static OffsetTarget ofInstanceofExpr(Label target) {
            return TargetInfo.ofOffset(TargetType.INSTANCEOF, target);
        }

        public static OffsetTarget ofNewExpr(Label target) {
            return TargetInfo.ofOffset(TargetType.NEW, target);
        }

        public static OffsetTarget ofConstructorReference(Label target) {
            return TargetInfo.ofOffset(TargetType.CONSTRUCTOR_REFERENCE, target);
        }

        public static OffsetTarget ofMethodReference(Label target) {
            return TargetInfo.ofOffset(TargetType.METHOD_REFERENCE, target);
        }

        public static TypeArgumentTarget ofTypeArgument(TargetType targetType, Label target, int typeArgumentIndex) {
            return new TargetInfoImpl.TypeArgumentTargetImpl(targetType, target, typeArgumentIndex);
        }

        public static TypeArgumentTarget ofCastExpr(Label target, int typeArgumentIndex) {
            return TargetInfo.ofTypeArgument(TargetType.CAST, target, typeArgumentIndex);
        }

        public static TypeArgumentTarget ofConstructorInvocationTypeArgument(Label target, int typeArgumentIndex) {
            return TargetInfo.ofTypeArgument(TargetType.CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT, target, typeArgumentIndex);
        }

        public static TypeArgumentTarget ofMethodInvocationTypeArgument(Label target, int typeArgumentIndex) {
            return TargetInfo.ofTypeArgument(TargetType.METHOD_INVOCATION_TYPE_ARGUMENT, target, typeArgumentIndex);
        }

        public static TypeArgumentTarget ofConstructorReferenceTypeArgument(Label target, int typeArgumentIndex) {
            return TargetInfo.ofTypeArgument(TargetType.CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT, target, typeArgumentIndex);
        }

        public static TypeArgumentTarget ofMethodReferenceTypeArgument(Label target, int typeArgumentIndex) {
            return TargetInfo.ofTypeArgument(TargetType.METHOD_REFERENCE_TYPE_ARGUMENT, target, typeArgumentIndex);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface TypePathComponent {
        public static final TypePathComponent ARRAY = new UnboundAttribute.TypePathComponentImpl(Kind.ARRAY, 0);
        public static final TypePathComponent INNER_TYPE = new UnboundAttribute.TypePathComponentImpl(Kind.INNER_TYPE, 0);
        public static final TypePathComponent WILDCARD = new UnboundAttribute.TypePathComponentImpl(Kind.WILDCARD, 0);

        public Kind typePathKind();

        public int typeArgumentIndex();

        public static TypePathComponent of(Kind typePathKind, int typeArgumentIndex) {
            return switch (typePathKind.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> ARRAY;
                case 1 -> INNER_TYPE;
                case 2 -> WILDCARD;
                case 3 -> new UnboundAttribute.TypePathComponentImpl(Kind.TYPE_ARGUMENT, typeArgumentIndex);
            };
        }

        public static enum Kind {
            ARRAY(0),
            INNER_TYPE(1),
            WILDCARD(2),
            TYPE_ARGUMENT(3);

            private final int tag;

            private Kind(int tag) {
                this.tag = tag;
            }

            public int tag() {
                return this.tag;
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface TypeArgumentTarget
    extends TargetInfo {
        public Label target();

        public int typeArgumentIndex();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OffsetTarget
    extends TargetInfo {
        public Label target();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface CatchTarget
    extends TargetInfo {
        public int exceptionTableIndex();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface LocalVarTargetInfo {
        public Label startLabel();

        public Label endLabel();

        public int index();

        public static LocalVarTargetInfo of(Label startLabel, Label endLabel, int index) {
            return new TargetInfoImpl.LocalVarTargetInfoImpl(startLabel, endLabel, index);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface LocalVarTarget
    extends TargetInfo {
        public List<LocalVarTargetInfo> table();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ThrowsTarget
    extends TargetInfo {
        public int throwsTargetIndex();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface FormalParameterTarget
    extends TargetInfo {
        public int formalParameterIndex();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface EmptyTarget
    extends TargetInfo {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface TypeParameterBoundTarget
    extends TargetInfo {
        public int typeParameterIndex();

        public int boundIndex();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface SupertypeTarget
    extends TargetInfo {
        public int supertypeIndex();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface TypeParameterTarget
    extends TargetInfo {
        public int typeParameterIndex();
    }

    public static enum TargetType {
        CLASS_TYPE_PARAMETER(0, 1),
        METHOD_TYPE_PARAMETER(1, 1),
        CLASS_EXTENDS(16, 2),
        CLASS_TYPE_PARAMETER_BOUND(17, 2),
        METHOD_TYPE_PARAMETER_BOUND(18, 2),
        FIELD(19, 0),
        METHOD_RETURN(20, 0),
        METHOD_RECEIVER(21, 0),
        METHOD_FORMAL_PARAMETER(22, 1),
        THROWS(23, 2),
        LOCAL_VARIABLE(64, -1),
        RESOURCE_VARIABLE(65, -1),
        EXCEPTION_PARAMETER(66, 2),
        INSTANCEOF(67, 2),
        NEW(68, 2),
        CONSTRUCTOR_REFERENCE(69, 2),
        METHOD_REFERENCE(70, 2),
        CAST(71, 3),
        CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT(72, 3),
        METHOD_INVOCATION_TYPE_ARGUMENT(73, 3),
        CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT(74, 3),
        METHOD_REFERENCE_TYPE_ARGUMENT(75, 3);

        private final int targetTypeValue;
        private final int sizeIfFixed;

        private TargetType(int targetTypeValue, int sizeIfFixed) {
            this.targetTypeValue = targetTypeValue;
            this.sizeIfFixed = sizeIfFixed;
        }

        public int targetTypeValue() {
            return this.targetTypeValue;
        }

        public int sizeIfFixed() {
            return this.sizeIfFixed;
        }
    }
}

