/*
 * Decompiled with CFR 0.152.
 */
package io.github.deweyjose.graphqlcodegen.services;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ExecutionResult;
import graphql.introspection.IntrospectionResultToSchema;
import graphql.language.Document;
import graphql.schema.idl.SchemaPrinter;
import io.github.deweyjose.graphqlcodegen.Logger;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import lombok.Generated;

public class RemoteSchemaService {
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public RemoteSchemaService() {
        this.httpClient = HttpClient.newHttpClient();
    }

    public String getRemoteSchemaFile(String url) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        Logger.debug("Remote schema file: {}", response.body());
        if (response.statusCode() != 200) {
            throw new IOException("Failed to get remote schema file: " + response.statusCode());
        }
        return response.body();
    }

    public String getIntrospectedSchemaFile(String url, IntrospectionOperation operation, Map<String, String> headers) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(url)).POST(HttpRequest.BodyPublishers.ofString(this.objectMapper.writeValueAsString((Object)operation))).header("Content-Type", "application/json");
        if (!headers.isEmpty()) {
            headers.forEach(builder::header);
        }
        HttpRequest request = builder.build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        Logger.debug("Introspection results: {}", response.body());
        if (response.statusCode() != 200) {
            throw new IOException("Failed to get introspection results: " + response.statusCode());
        }
        Map introspection = (Map)this.objectMapper.readValue(response.body(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        return this.convertIntrospectionToSchema(introspection);
    }

    public String convertIntrospectionToSchema(Map<String, Object> introspection) {
        IntrospectionResultToSchema introspectionResultToSchema = new IntrospectionResultToSchema();
        ExecutionResult executionResult = ExecutionResult.newExecutionResult().data(introspection.get("data")).build();
        Document schema = introspectionResultToSchema.createSchemaDefinition(executionResult);
        SchemaPrinter schemaPrinter = new SchemaPrinter();
        String sdl = schemaPrinter.print(schema);
        return sdl;
    }

    public static class IntrospectionOperation {
        private String query;
        private String operationName;

        @Generated
        IntrospectionOperation(String query, String operationName) {
            this.query = query;
            this.operationName = operationName;
        }

        @Generated
        public static IntrospectionOperationBuilder builder() {
            return new IntrospectionOperationBuilder();
        }

        @Generated
        public String getQuery() {
            return this.query;
        }

        @Generated
        public String getOperationName() {
            return this.operationName;
        }

        @Generated
        public static class IntrospectionOperationBuilder {
            @Generated
            private String query;
            @Generated
            private String operationName;

            @Generated
            IntrospectionOperationBuilder() {
            }

            @Generated
            public IntrospectionOperationBuilder query(String query) {
                this.query = query;
                return this;
            }

            @Generated
            public IntrospectionOperationBuilder operationName(String operationName) {
                this.operationName = operationName;
                return this;
            }

            @Generated
            public IntrospectionOperation build() {
                return new IntrospectionOperation(this.query, this.operationName);
            }

            @Generated
            public String toString() {
                return "RemoteSchemaService.IntrospectionOperation.IntrospectionOperationBuilder(query=" + this.query + ", operationName=" + this.operationName + ")";
            }
        }
    }
}

