/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.urls;

import io.github.ascopes.protobufmavenplugin.urls.AbstractNestingUrlConnection;
import io.github.ascopes.protobufmavenplugin.urls.AbstractUrlStreamHandlerFactory;
import io.github.ascopes.protobufmavenplugin.urls.InputStreamDecorator;
import io.github.ascopes.protobufmavenplugin.urls.UrlFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

final class NestingUrlStreamHandlerFactory
extends AbstractUrlStreamHandlerFactory {
    private final UrlFactory urlFactory;
    private final InputStreamDecorator<?> decorator;

    NestingUrlStreamHandlerFactory(UrlFactory urlFactory, InputStreamDecorator<?> decorator, String protocol, String ... protocols) {
        super(protocol, protocols);
        this.urlFactory = urlFactory;
        this.decorator = decorator;
    }

    @Override
    URLConnection createUrlConnection(URL url) throws IOException {
        URL innerUrl = this.urlFactory.create(URI.create(url.getFile()));
        return new AbstractNestingUrlConnection(url, innerUrl){

            @Override
            InputStream nestInputStream(InputStream inputStream) throws IOException {
                return NestingUrlStreamHandlerFactory.this.decorator.decorate(inputStream);
            }
        };
    }
}

