/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.module.sms.core.util;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.sophon.commons.exception.SophonException;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;
import org.sophon.module.sms.core.util.RegexUtil;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

public class ExpressionUtil {
    private static final Pattern PATTERN_PARAMS = Pattern.compile("\\$\\{(.*?)}");
    private static final String EXPRESSION_PREFIX = "${";
    private static final String EXPRESSION_SUFFIX = "}";
    private static final ParserContext PARSE_CONTEXT = new TemplateParserContext("${", "}");
    private static final PropertyAccessor PROPERTY_PROCESSOR = new PropertyAccessor(){

        public Class<?>[] getSpecificTargetClasses() {
            return new Class[]{Map.class};
        }

        public boolean canRead(@NotNull EvaluationContext context, Object target, @NotNull String name) {
            return target instanceof Map && ((Map)target).containsKey(name);
        }

        public TypedValue read(@NotNull EvaluationContext context, Object target, @NotNull String name) throws AccessException {
            Assert.state((boolean)(target instanceof Map), (String)"Target object mast be instanceof Map !");
            Map map = (Map)target;
            if (!map.containsKey(name)) {
                throw new AccessException(String.format("There's no key named: %s in the target Map !", name));
            }
            Object value = map.get(name);
            return new TypedValue(value);
        }

        public boolean canWrite(@NotNull EvaluationContext context, Object target, @NotNull String name) {
            return false;
        }

        public void write(@NotNull EvaluationContext context, Object target, @NotNull String name, Object newValue) {
        }
    };

    private ExpressionUtil() {
    }

    public static String executeExpression(String expressionStr, Map<String, Object> params) {
        Object value;
        try {
            Expression expression = new SpelExpressionParser().parseExpression(expressionStr, PARSE_CONTEXT);
            StandardEvaluationContext evaluationContext = new StandardEvaluationContext(params);
            evaluationContext.addPropertyAccessor(PROPERTY_PROCESSOR);
            value = expression.getValue((EvaluationContext)evaluationContext);
        }
        catch (Exception e) {
            throw new SophonException(SmsErrorCodeConstants.PARSE_ERROR, (Throwable)e, String.format("\u8868\u8fbe\u5f0f\u89e3\u6790\u5f02\u5e38\uff1a%s", expressionStr));
        }
        return value == null ? "" : value.toString();
    }

    public static List<String> findAllParams(String expressionStr) {
        return RegexUtil.findAll(PATTERN_PARAMS, (CharSequence)expressionStr, 1);
    }
}

