/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.module.sms.core.util;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class DateUtil {
    private DateUtil() {
    }

    public static Duration between(Date date1, Date date2) {
        return DateUtil.between(DateUtil.toLocalDateTime(date1), DateUtil.toLocalDateTime(date2));
    }

    public static LocalDate toLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Date toDate(LocalDate date) {
        if (date == null) {
            return null;
        }
        return Date.from(date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDateTime date) {
        if (date == null) {
            return null;
        }
        return Date.from(date.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static boolean isSameDay(Date date1, Date date2) {
        return DateUtil.isSameDay(DateUtil.toLocalDate(date1), DateUtil.toLocalDate(date2));
    }

    public static boolean isSameDay(LocalDateTime date1, LocalDateTime date2) {
        return date1 != null && date2 != null && DateUtil.isSameDay(date1.toLocalDate(), date2.toLocalDate());
    }

    public static boolean isSameDay(LocalDate date1, LocalDate date2) {
        return date1 != null && date2 != null && date1.isEqual(date2);
    }

    public static Duration between(LocalDateTime startTimeInclude, LocalDateTime endTimeExclude) {
        if (startTimeInclude == null || endTimeExclude == null) {
            return Duration.ZERO;
        }
        return Duration.between(startTimeInclude, endTimeExclude);
    }

    public static long between(LocalDateTime startTimeInclude, LocalDateTime endTimeExclude, ChronoUnit unit) {
        if (startTimeInclude == null || endTimeExclude == null) {
            return 0L;
        }
        return unit.between(startTimeInclude, endTimeExclude);
    }
}

