/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.module.sms.core.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sophon.commons.enums.SwitchStatusEnum;
import org.sophon.commons.exception.ErrorCode;
import org.sophon.commons.exception.SophonException;
import org.sophon.commons.pager.PageResult;
import org.sophon.commons.util.AssertUtil;
import org.sophon.module.sms.api.SmsTemplateService;
import org.sophon.module.sms.api.vo.template.SmsTemplateCreateOrUpdateReq;
import org.sophon.module.sms.api.vo.template.SmsTemplatePageReq;
import org.sophon.module.sms.api.vo.template.SmsTemplateResp;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;
import org.sophon.module.sms.core.repository.SmsChannelRepository;
import org.sophon.module.sms.core.repository.SmsTemplateRepository;
import org.sophon.module.sms.core.repository.dataobject.SmsChannelDO;
import org.sophon.module.sms.core.repository.dataobject.SmsTemplateDO;
import org.sophon.module.sms.core.util.ChannelPropertiesUtil;
import org.sophon.module.sms.core.util.ExpressionUtil;
import org.sophon.module.sms.integration.client.SmsClient;
import org.sophon.module.sms.integration.client.SmsClientFactory;
import org.sophon.module.sms.integration.client.dto.SmsInvokeResult;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SmsTemplateServiceImpl
implements SmsTemplateService {
    private static final Logger log = LoggerFactory.getLogger(SmsTemplateServiceImpl.class);
    @Resource
    private SmsTemplateRepository smsTemplateRepository;
    @Resource
    private SmsChannelRepository smsChannelRepository;
    @Resource
    private SmsClientFactory smsClientFactory;

    public Long createOrUpdateSmsTemplate(SmsTemplateCreateOrUpdateReq req) {
        SmsTemplateDO template;
        SmsTemplateCreateOrUpdateReq.check((SmsTemplateCreateOrUpdateReq)req);
        SmsChannelDO channelDO = this.validateSmsChannelEnabled(req.getChannelId());
        this.validateSmsTemplateCodeDuplicate(req.getId(), req.getCode());
        this.validateApiTemplateExists(channelDO, req.getApiTemplateId());
        if (req.getId() != null) {
            template = this.validateSmsTemplateExists(req.getId());
        } else {
            template = new SmsTemplateDO();
            template.setCreator(req.getOptUserId());
            template.setCreateTime(new Date());
        }
        template.setUpdater(req.getOptUserId());
        template.setUpdateTime(new Date());
        template.setParamsList(ExpressionUtil.findAllParams(req.getContent()));
        template.setChannelCode(channelDO.getCode());
        template.setApiTemplateId(req.getApiTemplateId());
        template.setChannelId(req.getChannelId());
        template.setCode(req.getCode());
        template.setContent(req.getContent());
        template.setName(req.getName());
        template.setRemark(req.getRemark());
        template.setStatus(req.getStatus());
        template.setType(req.getType());
        return this.smsTemplateRepository.saveOrUpdate(template);
    }

    public void deleteSmsTemplate(Long id) {
        AssertUtil.assertNotNull((Object)id, (ErrorCode)SmsErrorCodeConstants.PARAM_INVALID, (String)"\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateSmsTemplateExists(id);
        this.smsTemplateRepository.deleteById(id);
    }

    public SmsTemplateResp findSmsTemplate(String code) {
        AssertUtil.assertNotBlank((String)code, (ErrorCode)SmsErrorCodeConstants.PARAM_INVALID, (String)"\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return this.convert(this.smsTemplateRepository.findByCode(code));
    }

    public SmsTemplateResp findSmsTemplate(Long id) {
        AssertUtil.assertNotNull((Object)id, (ErrorCode)SmsErrorCodeConstants.PARAM_INVALID, (String)"\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        return this.convert(this.smsTemplateRepository.findById(id));
    }

    public List<SmsTemplateResp> findSmsTemplateList(Collection<Long> ids) {
        AssertUtil.assertNotEmpty(ids, (ErrorCode)SmsErrorCodeConstants.PARAM_INVALID, (String)"\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        return this.convert(this.smsTemplateRepository.findByIds(ids));
    }

    public PageResult<SmsTemplateResp> findSmsTemplatePage(SmsTemplatePageReq req) {
        SmsTemplatePageReq.check((SmsTemplatePageReq)req);
        return this.convert(this.smsTemplateRepository.findByPage(req));
    }

    private SmsTemplateResp convert(SmsTemplateDO template) {
        if (template == null) {
            return null;
        }
        SmsTemplateResp templateResp = new SmsTemplateResp();
        BeanUtils.copyProperties((Object)template, (Object)templateResp, (String[])new String[]{"params"});
        templateResp.setParams(template.getParamsList());
        return templateResp;
    }

    private List<SmsTemplateResp> convert(List<SmsTemplateDO> templates) {
        if (CollectionUtils.isNotEmpty(templates)) {
            return templates.stream().map(this::convert).collect(Collectors.toList());
        }
        return new ArrayList<SmsTemplateResp>(0);
    }

    private PageResult<SmsTemplateResp> convert(PageResult<SmsTemplateDO> templatePage) {
        return new PageResult().setTotal(templatePage.getTotal()).setList(this.convert(templatePage.getList()));
    }

    private SmsTemplateDO validateSmsTemplateExists(Long templateId) {
        SmsTemplateDO smsTemplate = this.smsTemplateRepository.findById(templateId);
        AssertUtil.assertNotNull((Object)smsTemplate, (ErrorCode)SmsErrorCodeConstants.SMS_TEMPLATE_NOT_EXISTS);
        return smsTemplate;
    }

    private void validateSmsTemplateCodeDuplicate(Long templateId, String templateCode) {
        SmsTemplateDO template = this.smsTemplateRepository.findByCode(templateCode);
        if (template == null) {
            return;
        }
        AssertUtil.assertNull((Object)templateId, (ErrorCode)SmsErrorCodeConstants.SMS_TEMPLATE_CODE_DUPLICATE);
        AssertUtil.assertTrue((boolean)template.getId().equals(templateId), (ErrorCode)SmsErrorCodeConstants.SMS_TEMPLATE_CODE_DUPLICATE);
    }

    private SmsChannelDO validateSmsChannelEnabled(Long channelId) {
        SmsChannelDO smsChannel = this.smsChannelRepository.findById(channelId);
        AssertUtil.assertNotNull((Object)smsChannel, (ErrorCode)SmsErrorCodeConstants.SMS_CHANNEL_NOT_EXISTS);
        AssertUtil.assertTrue((SwitchStatusEnum.ofStatusCode((Integer)smsChannel.getStatus()) == SwitchStatusEnum.ENABLE ? 1 : 0) != 0, (ErrorCode)SmsErrorCodeConstants.SMS_CHANNEL_DISABLE);
        return smsChannel;
    }

    private void validateApiTemplateExists(SmsChannelDO channelDO, String apiTemplateId) {
        SmsClient smsClient = this.smsClientFactory.createClient(ChannelPropertiesUtil.from(channelDO));
        SmsInvokeResult templateResult = smsClient.getSmsTemplate(apiTemplateId);
        if (!templateResult.isSuccess()) {
            if (templateResult.getException() != null) {
                throw templateResult.getException();
            }
            throw new SophonException(SmsErrorCodeConstants.INVOKE_ERROR_UNKNOWN);
        }
    }
}

