/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.module.sms.core.service;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sophon.commons.core.KeyValue;
import org.sophon.commons.enums.SwitchStatusEnum;
import org.sophon.commons.exception.ErrorCode;
import org.sophon.commons.exception.SophonException;
import org.sophon.commons.util.AssertUtil;
import org.sophon.module.sms.api.SmsSendService;
import org.sophon.module.sms.api.vo.send.SmsReceiveHandleReq;
import org.sophon.module.sms.api.vo.send.SmsSendReq;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;
import org.sophon.module.sms.commons.enunms.SmsChannelEnum;
import org.sophon.module.sms.core.repository.SmsChannelRepository;
import org.sophon.module.sms.core.repository.SmsLogRepository;
import org.sophon.module.sms.core.repository.SmsTemplateRepository;
import org.sophon.module.sms.core.repository.dataobject.SmsChannelDO;
import org.sophon.module.sms.core.repository.dataobject.SmsTemplateDO;
import org.sophon.module.sms.core.util.ChannelPropertiesUtil;
import org.sophon.module.sms.core.util.ExpressionUtil;
import org.sophon.module.sms.integration.client.SmsClient;
import org.sophon.module.sms.integration.client.SmsClientFactory;
import org.sophon.module.sms.integration.client.dto.SmsInvokeResult;
import org.sophon.module.sms.integration.client.dto.SmsSendRespDTO;
import org.springframework.stereotype.Service;

@Service
public class SmsSendServiceImpl
implements SmsSendService {
    private static final Logger log = LoggerFactory.getLogger(SmsSendServiceImpl.class);
    @Resource
    private SmsLogRepository smsLogRepository;
    @Resource
    private SmsChannelRepository smsChannelRepository;
    @Resource
    private SmsTemplateRepository smsTemplateRepository;
    @Resource
    private SmsClientFactory smsClientFactory;
    private static final Pattern PATTERN_MOBILE = Pattern.compile("^(?:(?:\\+|00)86)?1(?:(?:3[\\d])|(?:4[5-79])|(?:5[0-35-9])|(?:6[5-7])|(?:7[0-8])|(?:8[\\d])|(?:9[189]))\\d{8}$");

    public Long sendSingleSms(SmsSendReq req) {
        SmsSendReq.check((SmsSendReq)req);
        SmsTemplateDO template = this.validateSmsTemplateEnabled(req.getTemplateCode());
        SmsChannelDO smsChannel = this.validateSmsChannelEnabled(template.getChannelId());
        String mobile = this.validateMobileExists(req.getMobile());
        List<KeyValue<String, Object>> newTemplateParams = this.validateTemplateParams(template, req.getTemplateParams());
        String content = ExpressionUtil.executeExpression(template.getContent(), req.getTemplateParams());
        Long sendLogId = this.smsLogRepository.create(mobile, req.getUserId(), template, content, req.getTemplateParams());
        SmsClient smsClient = this.smsClientFactory.createClient(ChannelPropertiesUtil.from(smsChannel));
        SmsInvokeResult sendResult = smsClient.sendSms(sendLogId.toString(), mobile, template.getApiTemplateId(), newTemplateParams);
        Integer sendCode = null;
        String sendMsg = null;
        String serialNo = null;
        if (sendResult.getException() != null) {
            sendCode = sendResult.getException().getErrorCode().getCode();
            sendMsg = sendResult.getException().getMessage();
        }
        if (sendResult.getData() != null) {
            serialNo = ((SmsSendRespDTO)sendResult.getData()).getSerialNo();
        }
        this.smsLogRepository.updateSendStatus(sendLogId, sendResult.isSuccess(), sendCode, sendMsg, sendResult.getApiCode(), sendResult.getApiMsg(), sendResult.getApiRequestId(), serialNo, new Date());
        if (!sendResult.isSuccess()) {
            if (sendResult.getException() != null) {
                throw sendResult.getException();
            }
            throw new SophonException(SmsErrorCodeConstants.INVOKE_ERROR_UNKNOWN);
        }
        return sendLogId;
    }

    public void receiveSmsHandle(SmsReceiveHandleReq req) {
        SmsReceiveHandleReq.check((SmsReceiveHandleReq)req);
        SmsChannelEnum channelEnum = SmsChannelEnum.getByCode((String)req.getChannelCode());
        AssertUtil.assertNotNull((Object)channelEnum, (ErrorCode)SmsErrorCodeConstants.SMS_CHANNEL_NOT_EXISTS);
        SmsChannelDO enabledByChannel = this.smsChannelRepository.findFirstEnabledByChannel(channelEnum);
        AssertUtil.assertNotNull((Object)enabledByChannel, (ErrorCode)SmsErrorCodeConstants.SMS_CHANNEL_NOT_EXISTS);
        SmsClient smsClient = this.smsClientFactory.createClient(ChannelPropertiesUtil.from(enabledByChannel));
        SmsInvokeResult receiveResults = smsClient.parseSmsReceiveStatus(req.getText());
        if (!receiveResults.isSuccess()) {
            if (receiveResults.getException() != null) {
                throw receiveResults.getException();
            }
            throw new SophonException(SmsErrorCodeConstants.INVOKE_ERROR_UNKNOWN);
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)receiveResults.getData()))) {
            return;
        }
        ((List)receiveResults.getData()).forEach(result -> this.smsLogRepository.updateReceiveStatus(Long.valueOf(result.getBizNo()), result.getSuccess(), result.getErrorCode(), result.getErrorMsg(), result.getReceiveTime()));
    }

    private SmsTemplateDO validateSmsTemplateEnabled(String templateCode) {
        SmsTemplateDO smsTemplate = this.smsTemplateRepository.findByCode(templateCode);
        AssertUtil.assertNotNull((Object)smsTemplate, (ErrorCode)SmsErrorCodeConstants.SMS_TEMPLATE_NOT_EXISTS);
        AssertUtil.assertTrue((SwitchStatusEnum.ofStatusCode((Integer)smsTemplate.getStatus()) == SwitchStatusEnum.ENABLE ? 1 : 0) != 0, (ErrorCode)SmsErrorCodeConstants.SMS_TEMPLATE_DISABLE);
        return smsTemplate;
    }

    private List<KeyValue<String, Object>> validateTemplateParams(SmsTemplateDO template, Map<String, Object> templateParams) {
        return template.getParamsList().stream().map(key -> {
            Object value = templateParams.get(key);
            AssertUtil.assertNotNull(value, (ErrorCode)SmsErrorCodeConstants.SMS_SEND_TEMPLATE_PARAM_MISS);
            return KeyValue.of((Object)key, value);
        }).collect(Collectors.toList());
    }

    private String validateMobileExists(String mobile) {
        AssertUtil.assertTrue((StringUtils.isNotBlank((CharSequence)mobile) && PATTERN_MOBILE.matcher(mobile).matches() ? 1 : 0) != 0, (ErrorCode)SmsErrorCodeConstants.SMS_MOBILE_INVALID);
        return mobile;
    }

    private SmsChannelDO validateSmsChannelEnabled(Long channelId) {
        SmsChannelDO smsChannel = this.smsChannelRepository.findById(channelId);
        AssertUtil.assertNotNull((Object)smsChannel, (ErrorCode)SmsErrorCodeConstants.SMS_CHANNEL_NOT_EXISTS);
        AssertUtil.assertTrue((SwitchStatusEnum.ofStatusCode((Integer)smsChannel.getStatus()) == SwitchStatusEnum.ENABLE ? 1 : 0) != 0, (ErrorCode)SmsErrorCodeConstants.SMS_CHANNEL_DISABLE);
        return smsChannel;
    }
}

