/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.module.sms.core.service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sophon.commons.pager.PageResult;
import org.sophon.module.sms.api.SmsLogService;
import org.sophon.module.sms.api.vo.log.SmsLogPageReq;
import org.sophon.module.sms.api.vo.log.SmsLogResp;
import org.sophon.module.sms.core.repository.SmsLogRepository;
import org.sophon.module.sms.core.repository.dataobject.SmsLogDO;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SmsLogServiceImpl
implements SmsLogService {
    private static final Logger log = LoggerFactory.getLogger(SmsLogServiceImpl.class);
    @Resource
    private SmsLogRepository smsLogRepository;

    public PageResult<SmsLogResp> findSmsLogPage(SmsLogPageReq req) {
        SmsLogPageReq.check((SmsLogPageReq)req);
        return this.convert(this.smsLogRepository.findByPage(req));
    }

    private SmsLogResp convert(SmsLogDO log) {
        if (log == null) {
            return null;
        }
        SmsLogResp logResp = new SmsLogResp();
        BeanUtils.copyProperties((Object)log, (Object)logResp, (String[])new String[]{"templateParams"});
        logResp.setTemplateParams(log.getTemplateParamsMap());
        return logResp;
    }

    private List<SmsLogResp> convert(List<SmsLogDO> logs) {
        if (CollectionUtils.isNotEmpty(logs)) {
            return logs.stream().map(this::convert).collect(Collectors.toList());
        }
        return new ArrayList<SmsLogResp>(0);
    }

    private PageResult<SmsLogResp> convert(PageResult<SmsLogDO> logPage) {
        return new PageResult().setTotal(logPage.getTotal()).setList(this.convert(logPage.getList()));
    }
}

