/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.module.sms.core.service;

import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sophon.commons.exception.ErrorCode;
import org.sophon.commons.util.AssertUtil;
import org.sophon.module.sms.api.SmsCodeService;
import org.sophon.module.sms.api.SmsSendService;
import org.sophon.module.sms.api.vo.code.SmsCodeProperties;
import org.sophon.module.sms.api.vo.code.SmsCodeSendReq;
import org.sophon.module.sms.api.vo.code.SmsCodeUseReq;
import org.sophon.module.sms.api.vo.code.SmsCodeValidateReq;
import org.sophon.module.sms.api.vo.send.SmsSendReq;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;
import org.sophon.module.sms.core.repository.SmsCodeRepository;
import org.sophon.module.sms.core.repository.dataobject.SmsCodeDO;
import org.sophon.module.sms.core.util.DateUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SmsCodeServiceImpl
implements SmsCodeService {
    private static final Logger log = LoggerFactory.getLogger(SmsCodeServiceImpl.class);
    @Resource
    private SmsSendService smsSendService;
    @Resource
    private SmsCodeRepository smsCodeRepository;
    @Resource
    private SmsCodeProperties smsCodeProperties;

    @Transactional(rollbackFor={Exception.class})
    public String sendSmsCode(SmsCodeSendReq req) {
        SmsCodeSendReq.check((SmsCodeSendReq)req);
        SmsCodeDO lastSmsCode = this.smsCodeRepository.findLast(req.getMobile());
        if (lastSmsCode != null) {
            AssertUtil.assertTrue((DateUtil.between(lastSmsCode.getCreateTime(), new Date()).toMillis() >= this.smsCodeProperties.getSendFrequency().toMillis() ? 1 : 0) != 0, (ErrorCode)SmsErrorCodeConstants.SMS_CODE_SEND_TOO_FAST);
            AssertUtil.assertFalse((DateUtil.isSameDay(lastSmsCode.getCreateTime(), new Date()) && lastSmsCode.getTodayIndex() >= this.smsCodeProperties.getSendMaximumQuantityPerDay() ? 1 : 0) != 0, (ErrorCode)SmsErrorCodeConstants.SMS_CODE_EXCEED_MAX_PER_DAY);
        }
        String code = String.valueOf(ThreadLocalRandom.current().nextInt(this.smsCodeProperties.getBeginCode(), this.smsCodeProperties.getEndCode() + 1));
        int todayIndex = lastSmsCode != null && DateUtil.isSameDay(lastSmsCode.getCreateTime(), new Date()) ? lastSmsCode.getTodayIndex() + 1 : 1;
        this.smsCodeRepository.create(req.getMobile(), code, req.getScene(), req.getCreateIp(), todayIndex);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put(this.smsCodeProperties.getParamName(), code);
        this.smsSendService.sendSingleSms(new SmsSendReq().setMobile(req.getMobile()).setUserId(req.getUserId()).setTemplateCode(req.getTemplateCode()).setTemplateParams(params));
        return code;
    }

    public void useSmsCode(SmsCodeUseReq req) {
        SmsCodeUseReq.check((SmsCodeUseReq)req);
        SmsCodeDO lastSmsCode = this.validateSmsCode0(req.getMobile(), req.getCode(), req.getScene());
        this.smsCodeRepository.updateToUsed(lastSmsCode.getId(), req.getUsedIp());
    }

    public void validateSmsCode(SmsCodeValidateReq req) {
        SmsCodeValidateReq.check((SmsCodeValidateReq)req);
        this.validateSmsCode0(req.getMobile(), req.getCode(), req.getScene());
    }

    private SmsCodeDO validateSmsCode0(String mobile, String code, Integer scene) {
        SmsCodeDO lastSmsCode = this.smsCodeRepository.findLast(mobile, scene, code);
        AssertUtil.assertNotNull((Object)lastSmsCode, (ErrorCode)SmsErrorCodeConstants.SMS_CODE_NOT_FOUND);
        AssertUtil.assertFalse((DateUtil.between(lastSmsCode.getCreateTime(), new Date()).toMillis() >= this.smsCodeProperties.getExpireTimes().toMillis() ? 1 : 0) != 0, (ErrorCode)SmsErrorCodeConstants.SMS_CODE_EXPIRED);
        AssertUtil.assertFalse((boolean)lastSmsCode.getUsed(), (ErrorCode)SmsErrorCodeConstants.SMS_CODE_USED);
        return lastSmsCode;
    }
}

