/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.module.sms.core.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sophon.commons.enums.SwitchStatusEnum;
import org.sophon.commons.exception.ErrorCode;
import org.sophon.commons.pager.PageResult;
import org.sophon.commons.util.AssertUtil;
import org.sophon.module.sms.api.SmsChannelService;
import org.sophon.module.sms.api.vo.channel.SmsChannelCreateOrUpdateReq;
import org.sophon.module.sms.api.vo.channel.SmsChannelPageReq;
import org.sophon.module.sms.api.vo.channel.SmsChannelResp;
import org.sophon.module.sms.commons.constants.SmsErrorCodeConstants;
import org.sophon.module.sms.commons.enunms.SmsChannelEnum;
import org.sophon.module.sms.core.repository.SmsChannelRepository;
import org.sophon.module.sms.core.repository.SmsTemplateRepository;
import org.sophon.module.sms.core.repository.dataobject.SmsChannelDO;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SmsChannelServiceImpl
implements SmsChannelService {
    private static final Logger log = LoggerFactory.getLogger(SmsChannelServiceImpl.class);
    @Resource
    private SmsChannelRepository smsChannelRepository;
    @Resource
    private SmsTemplateRepository smsTemplateRepository;
    private static final Pattern PATTERN_URL = Pattern.compile("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");

    public Long createOrUpdateSmsChannel(SmsChannelCreateOrUpdateReq req) {
        SmsChannelDO smsChannelDO;
        SmsChannelCreateOrUpdateReq.check((SmsChannelCreateOrUpdateReq)req);
        if (req.getId() != null) {
            smsChannelDO = this.validateSmsChannelExists(req.getId());
        } else {
            smsChannelDO = new SmsChannelDO();
            smsChannelDO.setCreator(req.getOptUserId());
            smsChannelDO.setCreateTime(new Date());
        }
        smsChannelDO.setUpdater(req.getOptUserId());
        smsChannelDO.setUpdateTime(new Date());
        smsChannelDO.setApiKey(req.getApiKey());
        smsChannelDO.setApiSecret(req.getApiSecret());
        if (StringUtils.isNotBlank((CharSequence)req.getCallbackUrl())) {
            smsChannelDO.setCallbackUrl(this.validateURL(req.getCallbackUrl()));
        }
        smsChannelDO.setRemark(req.getRemark());
        smsChannelDO.setSignature(req.getSignature());
        smsChannelDO.setApiExtrasMap(req.getApiExtras());
        SmsChannelEnum channelEnum = SmsChannelEnum.getByCode((String)req.getCode());
        AssertUtil.assertNotNull((Object)channelEnum, (ErrorCode)SmsErrorCodeConstants.PARAM_INVALID, (String)String.format("\u4e0d\u80fd\u8bc6\u522b\u7684\u6e20\u9053\u7f16\u7801[%s]", req.getCode()));
        smsChannelDO.setCode(req.getCode());
        SwitchStatusEnum statusEnum = SwitchStatusEnum.ofStatusCode((Integer)req.getStatus());
        AssertUtil.assertNotNull((Object)statusEnum, (ErrorCode)SmsErrorCodeConstants.PARAM_INVALID, (String)String.format("\u4e0d\u80fd\u8bc6\u522b\u7684\u72b6\u6001[%s]", req.getStatus()));
        smsChannelDO.setStatus(req.getStatus());
        return this.smsChannelRepository.saveOrUpdate(smsChannelDO);
    }

    public void deleteSmsChannel(Long id) {
        AssertUtil.assertNotNull((Object)id, (ErrorCode)SmsErrorCodeConstants.PARAM_INVALID, (String)"\u6e20\u9053ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateSmsChannelExists(id);
        this.validateSmsTemplateUncorrelatedSmsChannel(id);
        this.smsChannelRepository.deleteById(id);
    }

    public SmsChannelResp findSmsChannel(Long id) {
        AssertUtil.assertNotNull((Object)id, (ErrorCode)SmsErrorCodeConstants.PARAM_INVALID, (String)"\u6e20\u9053ID\u4e0d\u80fd\u4e3a\u7a7a");
        return this.convert(this.smsChannelRepository.findById(id));
    }

    public List<SmsChannelResp> findSmsChannelList(Collection<Long> ids) {
        AssertUtil.assertNotEmpty(ids, (ErrorCode)SmsErrorCodeConstants.PARAM_INVALID, (String)"\u6e20\u9053ID\u4e0d\u80fd\u4e3a\u7a7a");
        return this.convert(this.smsChannelRepository.findByIds(ids));
    }

    public PageResult<SmsChannelResp> findSmsChannelPage(SmsChannelPageReq req) {
        SmsChannelPageReq.check((SmsChannelPageReq)req);
        return this.convert(this.smsChannelRepository.findByPage(req));
    }

    private SmsChannelResp convert(SmsChannelDO channelDO) {
        if (channelDO == null) {
            return null;
        }
        SmsChannelResp channelResp = new SmsChannelResp();
        BeanUtils.copyProperties((Object)channelDO, (Object)channelResp, (String[])new String[]{"apiExtras"});
        channelResp.setApiExtras(channelDO.getApiExtrasMap());
        return channelResp;
    }

    private List<SmsChannelResp> convert(List<SmsChannelDO> channels) {
        if (CollectionUtils.isNotEmpty(channels)) {
            return channels.stream().map(this::convert).collect(Collectors.toList());
        }
        return new ArrayList<SmsChannelResp>(0);
    }

    private PageResult<SmsChannelResp> convert(PageResult<SmsChannelDO> channelPage) {
        return new PageResult().setTotal(channelPage.getTotal()).setList(this.convert(channelPage.getList()));
    }

    private SmsChannelDO validateSmsChannelExists(Long channelId) {
        SmsChannelDO smsChannel = this.smsChannelRepository.findById(channelId);
        AssertUtil.assertNotNull((Object)smsChannel, (ErrorCode)SmsErrorCodeConstants.SMS_CHANNEL_NOT_EXISTS);
        return smsChannel;
    }

    private void validateSmsTemplateUncorrelatedSmsChannel(Long channelId) {
        AssertUtil.assertTrue((this.smsTemplateRepository.countByChannelId(channelId) <= 0L ? 1 : 0) != 0, (ErrorCode)SmsErrorCodeConstants.SMS_CHANNEL_HAS_CHILDREN);
    }

    private String validateURL(String url) {
        AssertUtil.assertTrue((StringUtils.isNotBlank((CharSequence)url) && PATTERN_URL.matcher(url).matches() ? 1 : 0) != 0, (ErrorCode)SmsErrorCodeConstants.URL_INVALID);
        return url;
    }
}

