/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.module.sms.core.repository.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.sophon.commons.pager.PageResult;
import org.sophon.module.data.jdbc.customize.PagingQuery;
import org.sophon.module.sms.api.vo.template.SmsTemplatePageReq;
import org.sophon.module.sms.core.repository.SmsTemplateRepository;
import org.sophon.module.sms.core.repository.dao.SmsTemplateDao;
import org.sophon.module.sms.core.repository.dataobject.SmsTemplateDO;
import org.sophon.module.sms.core.util.OrderUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;

@Component
public class SmsTemplateRepositoryImpl
implements SmsTemplateRepository {
    @Resource
    private SmsTemplateDao smsTemplateDao;
    @Resource
    private ApplicationContext applicationContext;

    @Override
    public Long saveOrUpdate(SmsTemplateDO templateDO) {
        this.smsTemplateDao.save(templateDO);
        return templateDO.getId();
    }

    @Override
    public void deleteById(Long id) {
        this.smsTemplateDao.deleteById(id);
    }

    @Override
    public Long countByChannelId(Long channelId) {
        return this.smsTemplateDao.countByChannelId(channelId);
    }

    @Override
    public SmsTemplateDO findByCode(String code) {
        return this.smsTemplateDao.findByCode(code);
    }

    @Override
    public SmsTemplateDO findById(Long id) {
        return this.smsTemplateDao.findById(id).orElse(null);
    }

    @Override
    public List<SmsTemplateDO> findByIds(Collection<Long> ids) {
        ArrayList<SmsTemplateDO> list = new ArrayList<SmsTemplateDO>(ids.size());
        this.smsTemplateDao.findAllById(ids).forEach(list::add);
        return list;
    }

    @Override
    public PageResult<SmsTemplateDO> findByPage(SmsTemplatePageReq req) {
        Page page = PagingQuery.create((ApplicationContext)this.applicationContext, SmsTemplateDO.class).isEqualIf(req.getType() != null, "type", (Object)req.getType()).isEqualIf(req.getStatus() != null, "status", (Object)req.getStatus()).likeIf(StringUtils.isNotBlank((CharSequence)req.getName()), "name", req.getName()).likeIf(StringUtils.isNotBlank((CharSequence)req.getCode()), "code", req.getCode()).likeIf(StringUtils.isNotBlank((CharSequence)req.getContent()), "content", req.getContent()).isEqualIf(req.getChannelId() != null, "channelId", (Object)req.getChannelId()).likeIf(StringUtils.isNotBlank((CharSequence)req.getApiTemplateId()), "apiTemplateId", req.getApiTemplateId()).isGreaterOrEqualToIf(req.getBeginCreateTime() != null, "createTime", (Object)req.getBeginCreateTime()).isLessOrEqualToIf(req.getEndCreateTime() != null, "createTime", (Object)req.getEndCreateTime()).page(req.getPageNo(), req.getPageSize(), OrderUtil.from(req.getSortingFields()));
        return PageResult.of((List)page.toList(), (Long)page.getTotalElements());
    }
}

