/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.module.sms.core.repository.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.sophon.commons.pager.PageResult;
import org.sophon.module.data.jdbc.customize.PagingQuery;
import org.sophon.module.sms.api.enums.SmsReceiveStatusEnum;
import org.sophon.module.sms.api.enums.SmsSendStatusEnum;
import org.sophon.module.sms.api.vo.log.SmsLogPageReq;
import org.sophon.module.sms.core.repository.SmsLogRepository;
import org.sophon.module.sms.core.repository.dao.SmsLogDao;
import org.sophon.module.sms.core.repository.dataobject.SmsLogDO;
import org.sophon.module.sms.core.repository.dataobject.SmsTemplateDO;
import org.sophon.module.sms.core.util.OrderUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SmsLogRepositoryImpl
implements SmsLogRepository {
    @Resource
    private SmsLogDao smsLogDao;
    @Resource
    private ApplicationContext applicationContext;

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public Long create(String mobile, String userId, SmsTemplateDO template, String templateContent, Map<String, Object> templateParams) {
        SmsLogDO smsLogDO = new SmsLogDO().setMobile(mobile).setUserId(userId).setTemplateContent(templateContent).setTemplateParamsMap(templateParams).setChannelId(template.getChannelId()).setChannelCode(template.getChannelCode()).setTemplateId(template.getId()).setTemplateCode(template.getCode()).setTemplateType(template.getType()).setApiTemplateId(template.getApiTemplateId()).setSendStatus(SmsSendStatusEnum.INIT.getStatus()).setReceiveStatus(SmsReceiveStatusEnum.INIT.getStatus());
        this.smsLogDao.save(smsLogDO);
        return smsLogDO.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void updateSendStatus(Long logId, Boolean success, Integer sendCode, String sendMsg, String apiSendCode, String apiSendMsg, String apiRequestId, String apiSerialNo, Date sendTime) {
        this.smsLogDao.findById(logId).ifPresent(smsLogDO -> {
            smsLogDO.setSendCode(sendCode).setSendMsg(sendMsg).setApiSendCode(apiSendCode).setApiSendMsg(apiSendMsg).setApiRequestId(apiRequestId).setApiSerialNo(apiSerialNo).setSendTime(sendTime).setSendStatus(success != false ? SmsSendStatusEnum.SUCCESS.getStatus() : SmsSendStatusEnum.FAILURE.getStatus());
            this.smsLogDao.save(smsLogDO);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void updateReceiveStatus(Long logId, Boolean success, String apiReceiveCode, String apiReceiveMsg, Date receiveTime) {
        this.smsLogDao.findById(logId).ifPresent(smsLogDO -> {
            smsLogDO.setApiReceiveCode(apiReceiveCode).setApiReceiveMsg(apiReceiveMsg).setReceiveTime(receiveTime).setReceiveStatus(success != false ? SmsReceiveStatusEnum.SUCCESS.getStatus() : SmsSendStatusEnum.FAILURE.getStatus());
            this.smsLogDao.save(smsLogDO);
        });
    }

    @Override
    public SmsLogDO findById(Long logId) {
        return this.smsLogDao.findById(logId).orElse(null);
    }

    @Override
    public PageResult<SmsLogDO> findByPage(SmsLogPageReq req) {
        Page page = PagingQuery.create((ApplicationContext)this.applicationContext, SmsLogDO.class).isEqualIf(req.getChannelId() != null, "channelId", (Object)req.getChannelId()).isEqualIf(StringUtils.isNotBlank((CharSequence)req.getChannelCode()), "channelCode", (Object)req.getChannelCode()).isEqualIf(req.getTemplateId() != null, "templateId", (Object)req.getTemplateId()).isEqualIf(req.getTemplateType() != null, "templateType", (Object)req.getTemplateType()).isEqualIf(StringUtils.isNotBlank((CharSequence)req.getTemplateCode()), "templateCode", (Object)req.getTemplateCode()).isEqualIf(StringUtils.isNotBlank((CharSequence)req.getApiTemplateId()), "apiTemplateId", (Object)req.getApiTemplateId()).likeIf(StringUtils.isNotBlank((CharSequence)req.getMobile()), "mobile", req.getMobile()).isEqualIf(StringUtils.isNotBlank((CharSequence)req.getUserId()), "userId", (Object)req.getUserId()).isEqualIf(req.getSendStatus() != null, "sendStatus", (Object)req.getSendStatus()).isEqualIf(req.getReceiveStatus() != null, "receiveStatus", (Object)req.getReceiveStatus()).isGreaterOrEqualToIf(req.getBeginSendTime() != null, "sendTime", (Object)req.getBeginSendTime()).isLessOrEqualToIf(req.getEndSendTime() != null, "sendTime", (Object)req.getEndSendTime()).isGreaterOrEqualToIf(req.getBeginReceiveTime() != null, "receiveTime", (Object)req.getBeginReceiveTime()).isLessOrEqualToIf(req.getEndReceiveTime() != null, "receiveTime", (Object)req.getEndReceiveTime()).page(req.getPageNo(), req.getPageSize(), OrderUtil.from(req.getSortingFields()));
        return PageResult.of((List)page.toList(), (Long)page.getTotalElements());
    }
}

