/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.module.sms.core.repository.impl;

import java.util.Date;
import javax.annotation.Resource;
import org.sophon.module.sms.core.repository.SmsCodeRepository;
import org.sophon.module.sms.core.repository.dao.SmsCodeDao;
import org.sophon.module.sms.core.repository.dataobject.SmsCodeDO;
import org.springframework.stereotype.Component;

@Component
public class SmsCodeRepositoryImpl
implements SmsCodeRepository {
    @Resource
    private SmsCodeDao smsCodeDao;

    @Override
    public Long create(String mobile, String code, Integer scene, String createIp, Integer todayIndex) {
        SmsCodeDO smsCodeDO = new SmsCodeDO().setMobile(mobile).setCode(code).setScene(scene).setCreateIp(createIp).setTodayIndex(todayIndex).setUsed(false).setCreateTime(new Date());
        this.smsCodeDao.save(smsCodeDO);
        return smsCodeDO.getId();
    }

    @Override
    public void updateToUsed(Long codeId, String usedIp) {
        this.smsCodeDao.findById(codeId).ifPresent(smsCodeDO -> {
            smsCodeDO.setUsed(true).setUsedIp(usedIp).setUsedTime(new Date());
            this.smsCodeDao.save(smsCodeDO);
        });
    }

    @Override
    public SmsCodeDO findLast(String mobile, Integer scene, String code) {
        return this.smsCodeDao.findFirstByMobileAndSceneAndCodeOrderByCreateTimeDescIdDesc(mobile, scene, code);
    }

    @Override
    public SmsCodeDO findLast(String mobile) {
        return this.smsCodeDao.findFirstByMobileOrderByCreateTimeDescIdDesc(mobile);
    }
}

