/*
 * Decompiled with CFR 0.152.
 */
package org.sophon.module.sms.core.repository.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.sophon.commons.enums.SwitchStatusEnum;
import org.sophon.commons.pager.PageResult;
import org.sophon.module.data.jdbc.customize.PagingQuery;
import org.sophon.module.sms.api.vo.channel.SmsChannelPageReq;
import org.sophon.module.sms.commons.enunms.SmsChannelEnum;
import org.sophon.module.sms.core.repository.SmsChannelRepository;
import org.sophon.module.sms.core.repository.dao.SmsChannelDao;
import org.sophon.module.sms.core.repository.dataobject.SmsChannelDO;
import org.sophon.module.sms.core.util.OrderUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;

@Component
public class SmsChannelRepositoryImpl
implements SmsChannelRepository {
    @Resource
    private SmsChannelDao smsChannelDao;
    @Resource
    private ApplicationContext applicationContext;

    @Override
    public Long saveOrUpdate(SmsChannelDO channelDO) {
        this.smsChannelDao.save(channelDO);
        return channelDO.getId();
    }

    @Override
    public void deleteById(Long id) {
        this.smsChannelDao.deleteById(id);
    }

    @Override
    public SmsChannelDO findById(Long id) {
        return this.smsChannelDao.findById(id).orElse(null);
    }

    @Override
    public List<SmsChannelDO> findByIds(Collection<Long> ids) {
        ArrayList<SmsChannelDO> list = new ArrayList<SmsChannelDO>(ids.size());
        this.smsChannelDao.findAllById(ids).forEach(list::add);
        return list;
    }

    @Override
    public SmsChannelDO findFirstEnabledByChannel(SmsChannelEnum channel) {
        return this.smsChannelDao.findFirstByCodeAndStatus(channel.getCode(), SwitchStatusEnum.ENABLE.getStatusCode());
    }

    @Override
    public PageResult<SmsChannelDO> findByPage(SmsChannelPageReq req) {
        Page page = PagingQuery.create((ApplicationContext)this.applicationContext, SmsChannelDO.class).isEqualIf(StringUtils.isNotBlank((CharSequence)req.getCode()), "code", (Object)req.getCode()).likeIf(StringUtils.isNotBlank((CharSequence)req.getSignature()), "signature", req.getSignature()).isEqualIf(req.getStatus() != null, "status", (Object)req.getStatus()).isGreaterOrEqualToIf(req.getBeginCreateTime() != null, "createTime", (Object)req.getBeginCreateTime()).isLessOrEqualToIf(req.getEndCreateTime() != null, "createTime", (Object)req.getEndCreateTime()).page(req.getPageNo(), req.getPageSize(), OrderUtil.from(req.getSortingFields()));
        return PageResult.of((List)page.toList(), (Long)page.getTotalElements());
    }
}

