/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.ConfigHelper$;
import io.gatling.commons.util.Java$;
import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.config.GatlingConfiguration$;
import io.gatling.core.config.GatlingFiles$;
import io.gatling.core.filter.AllowList;
import io.gatling.core.filter.DenyList;
import io.gatling.recorder.config.CertificateAuthorityConfiguration;
import io.gatling.recorder.config.ConfigKeys$;
import io.gatling.recorder.config.ConfigKeys$core$;
import io.gatling.recorder.config.ConfigKeys$filters$;
import io.gatling.recorder.config.ConfigKeys$http$;
import io.gatling.recorder.config.ConfigKeys$netty$;
import io.gatling.recorder.config.ConfigKeys$proxy$;
import io.gatling.recorder.config.ConfigKeys$proxy$https$;
import io.gatling.recorder.config.ConfigKeys$proxy$https$certificateAuthority$;
import io.gatling.recorder.config.ConfigKeys$proxy$https$keyStore$;
import io.gatling.recorder.config.ConfigKeys$proxy$outgoing$;
import io.gatling.recorder.config.CoreConfiguration;
import io.gatling.recorder.config.FiltersConfiguration;
import io.gatling.recorder.config.HttpConfiguration;
import io.gatling.recorder.config.HttpsModeConfiguration;
import io.gatling.recorder.config.KeyStoreConfiguration;
import io.gatling.recorder.config.NettyConfiguration;
import io.gatling.recorder.config.OutgoingProxyConfiguration;
import io.gatling.recorder.config.ProxyConfiguration;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.config.RecorderConfiguration$IntOption$;
import io.gatling.recorder.config.RecorderMode$;
import io.gatling.recorder.http.ssl.HttpsMode$;
import io.gatling.recorder.http.ssl.KeyStoreType$;
import io.gatling.recorder.render.template.Format$;
import io.gatling.recorder.render.template.Format$Java11$;
import io.gatling.recorder.render.template.Format$Java17$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple6;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Properties$;
import scala.util.Using;
import scala.util.Using$;
import scala.util.control.NonFatal$;

public final class RecorderConfiguration$
implements StrictLogging,
Serializable {
    public static final RecorderConfiguration$ MODULE$ = new RecorderConfiguration$();
    private static final ConfigRenderOptions RenderOptions;
    private static final Path DefaultSimulationsDirectory;
    private static final Path DefaultResourcesDirectory;
    private static Option<Path> configFile;
    private static Option<RecorderConfiguration> _configuration;
    private static final GatlingConfiguration gatlingConfiguration;
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
        RenderOptions = ConfigRenderOptions.concise().setFormatted(true).setJson(false);
        DefaultSimulationsDirectory = GatlingFiles$.MODULE$.resolvePath(Paths.get("user-files/simulations", new String[0]));
        DefaultResourcesDirectory = GatlingFiles$.MODULE$.resolvePath(Paths.get("user-files/resources", new String[0]));
        configFile = None$.MODULE$;
        _configuration = None$.MODULE$;
        gatlingConfiguration = GatlingConfiguration$.MODULE$.load((scala.collection.mutable.Map)Map$.MODULE$.empty());
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public int IntOption(int value) {
        return value;
    }

    private ConfigRenderOptions RenderOptions() {
        return RenderOptions;
    }

    private Path DefaultSimulationsDirectory() {
        return DefaultSimulationsDirectory;
    }

    private Path DefaultResourcesDirectory() {
        return DefaultResourcesDirectory;
    }

    private Option<Path> configFile() {
        return configFile;
    }

    private void configFile_$eq(Option<Path> x$1) {
        configFile = x$1;
    }

    private Option<RecorderConfiguration> _configuration() {
        return _configuration;
    }

    private void _configuration_$eq(Option<RecorderConfiguration> x$1) {
        _configuration = x$1;
    }

    public RecorderConfiguration recorderConfiguration() {
        return (RecorderConfiguration)this._configuration().getOrElse((Function0 & Serializable)() -> {
            throw new UnsupportedOperationException("RecorderConfiguration hasn't been loaded yet");
        });
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private Config getDefaultConfig(ClassLoader classLoader) {
        return ConfigFactory.parseResources((ClassLoader)classLoader, (String)"recorder-defaults.conf");
    }

    public RecorderConfiguration fakeConfig(scala.collection.mutable.Map<String, ?> props) {
        Config defaultConfig = this.getDefaultConfig(this.getClassLoader());
        return this.buildConfig(ConfigHelper$.MODULE$.configChain(ConfigFactory.parseMap((Map)CollectionConverters$.MODULE$.MutableMapHasAsJava(props).asJava()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Config[]{defaultConfig})));
    }

    public void initialSetup(scala.collection.mutable.Map<String, ?> props, Option<Path> recorderConfigFile) {
        ClassLoader classLoader = this.getClassLoader();
        Config defaultConfig = this.getDefaultConfig(classLoader);
        this.configFile_$eq((Option<Path>)recorderConfigFile.orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)classLoader.getResource("recorder.conf")).map((Function1 & Serializable)url -> Paths.get(url.toURI()))));
        Config customConfig = (Config)this.configFile().map((Function1 & Serializable)path -> ConfigFactory.parseFile((File)path.toFile())).getOrElse((Function0 & Serializable)() -> {
            Predef$.MODULE$.println((Object)"recorder.conf file couldn't be located or is outdated");
            Predef$.MODULE$.println((Object)"Recorder preferences won't be saved.");
            Predef$.MODULE$.println((Object)"If running from sbt, please run \"copyConfigFiles\" and check the plugin documentation.");
            return ConfigFactory.empty();
        });
        Config propertiesConfig = ConfigFactory.parseMap((Map)CollectionConverters$.MODULE$.MutableMapHasAsJava(props).asJava());
        try {
            this._configuration_$eq((Option<RecorderConfiguration>)new Some((Object)this.buildConfig(ConfigHelper$.MODULE$.configChain(ConfigFactory.systemProperties(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Config[]{propertiesConfig, customConfig, defaultConfig})))));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Loading configuration crashed: {}. Probable cause is a format change, resetting.", (Object)Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(throwable2)));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.configFile().foreach((Function1 & Serializable)file -> {
                    RecorderConfiguration$.$anonfun$initialSetup$5(file);
                    return BoxedUnit.UNIT;
                });
                this._configuration_$eq((Option<RecorderConfiguration>)new Some((Object)this.buildConfig(ConfigHelper$.MODULE$.configChain(ConfigFactory.systemProperties(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Config[]{propertiesConfig, defaultConfig})))));
            }
            throw throwable;
        }
    }

    public void reload(scala.collection.mutable.Map<String, ?> props) {
        Config frameConfig = ConfigFactory.parseMap((Map)CollectionConverters$.MODULE$.MutableMapHasAsJava(props).asJava());
        this._configuration_$eq((Option<RecorderConfiguration>)new Some((Object)this.buildConfig(ConfigHelper$.MODULE$.configChain(frameConfig, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Config[]{this.recorderConfiguration().config()})))));
    }

    public void saveConfig() {
        ConfigObject configToSave = this.recorderConfiguration().config().withoutPath(ConfigKeys$core$.MODULE$.ResourcesFolder()).root().withOnlyKey(ConfigKeys$.MODULE$.ConfigRoot());
        this.configFile().foreach((Function1 & Serializable)file -> {
            Using$.MODULE$.resource((Object)Files.newBufferedWriter(RecorderConfiguration$.MODULE$.createAndOpen(file), RecorderConfiguration$.gatlingConfiguration.core().charset(), new OpenOption[0]), (Function1 & Serializable)x$1 -> {
                x$1.write(configToSave$1.render(RecorderConfiguration$.MODULE$.RenderOptions()));
                return BoxedUnit.UNIT;
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            return BoxedUnit.UNIT;
        });
    }

    public Path createAndOpen(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            Path parent = path.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                throw new FileNotFoundException("Directory '" + ((Object)parent).toString() + "' for recorder configuration does not exist");
            }
            return Files.createFile(path, new FileAttribute[0]);
        }
        return path;
    }

    private RecorderConfiguration buildConfig(Config config) {
        return new RecorderConfiguration(new CoreConfiguration(RecorderMode$.MODULE$.apply(config.getString(ConfigKeys$core$.MODULE$.Mode())), config.getString(ConfigKeys$core$.MODULE$.Encoding()), this.getSimulationsFolder$1(config.getString(ConfigKeys$core$.MODULE$.SimulationsFolder())), this.getResourcesFolder$1(config), config.getString(ConfigKeys$core$.MODULE$.Package()), config.getString(ConfigKeys$core$.MODULE$.ClassName()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$core$.MODULE$.ThresholdForPauseCreation()))).milliseconds(), config.getBoolean(ConfigKeys$core$.MODULE$.SaveConfig()), config.getBoolean(ConfigKeys$core$.MODULE$.Headless()), (Option<String>)StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$core$.MODULE$.HarFilePath()))), config.hasPath(ConfigKeys$core$.MODULE$.Format()) ? Format$.MODULE$.fromString(config.getString(ConfigKeys$core$.MODULE$.Format()).trim()) : (Java$.MODULE$.MajorVersion() >= 17 ? Format$Java17$.MODULE$ : Format$Java11$.MODULE$)), new FiltersConfiguration(config.getBoolean(ConfigKeys$filters$.MODULE$.Enable()), new AllowList((Seq)CollectionConverters$.MODULE$.ListHasAsScala(config.getStringList(ConfigKeys$filters$.MODULE$.AllowListPatterns())).asScala().toList()), new DenyList((Seq)CollectionConverters$.MODULE$.ListHasAsScala(config.getStringList(ConfigKeys$filters$.MODULE$.DenyListPatterns())).asScala().toList())), new HttpConfiguration(config.getBoolean(ConfigKeys$http$.MODULE$.AutomaticReferer()), config.getBoolean(ConfigKeys$http$.MODULE$.FollowRedirect()), config.getBoolean(ConfigKeys$http$.MODULE$.InferHtmlResources()), config.getBoolean(ConfigKeys$http$.MODULE$.RemoveCacheHeaders()), config.getBoolean(ConfigKeys$http$.MODULE$.CheckResponseBodies()), config.getBoolean(ConfigKeys$http$.MODULE$.UseSimulationAsPrefix()), config.getBoolean(ConfigKeys$http$.MODULE$.UseMethodAndUriAsPostfix())), new ProxyConfiguration(config.getInt(ConfigKeys$proxy$.MODULE$.Port()), new HttpsModeConfiguration(HttpsMode$.MODULE$.apply(config.getString(ConfigKeys$proxy$https$.MODULE$.Mode())), new KeyStoreConfiguration(config.getString(ConfigKeys$proxy$https$keyStore$.MODULE$.Path()), config.getString(ConfigKeys$proxy$https$keyStore$.MODULE$.Password()), KeyStoreType$.MODULE$.apply(config.getString(ConfigKeys$proxy$https$keyStore$.MODULE$.Type()))), new CertificateAuthorityConfiguration(Paths.get(config.getString(ConfigKeys$proxy$https$certificateAuthority$.MODULE$.CertificatePath()), new String[0]), Paths.get(config.getString(ConfigKeys$proxy$https$certificateAuthority$.MODULE$.PrivateKeyPath()), new String[0]))), new OutgoingProxyConfiguration((Option<String>)StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$proxy$outgoing$.MODULE$.Host()))), (Option<String>)StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$proxy$outgoing$.MODULE$.Username()))), (Option<String>)StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$proxy$outgoing$.MODULE$.Password()))), RecorderConfiguration$IntOption$.MODULE$.toOption$extension(this.IntOption(config.getInt(ConfigKeys$proxy$outgoing$.MODULE$.Port()))), RecorderConfiguration$IntOption$.MODULE$.toOption$extension(this.IntOption(config.getInt(ConfigKeys$proxy$outgoing$.MODULE$.SslPort()))))), new NettyConfiguration(config.getInt(ConfigKeys$netty$.MODULE$.MaxInitialLineLength()), config.getInt(ConfigKeys$netty$.MODULE$.MaxHeaderSize()), config.getInt(ConfigKeys$netty$.MODULE$.MaxChunkSize()), config.getInt(ConfigKeys$netty$.MODULE$.MaxContentLength())), config);
    }

    public RecorderConfiguration apply(CoreConfiguration core, FiltersConfiguration filters, HttpConfiguration http, ProxyConfiguration proxy, NettyConfiguration netty, Config config) {
        return new RecorderConfiguration(core, filters, http, proxy, netty, config);
    }

    public Option<Tuple6<CoreConfiguration, FiltersConfiguration, HttpConfiguration, ProxyConfiguration, NettyConfiguration, Config>> unapply(RecorderConfiguration x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple6((Object)x$0.core(), (Object)x$0.filters(), (Object)x$0.http(), (Object)x$0.proxy(), (Object)x$0.netty(), (Object)x$0.config()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RecorderConfiguration$.class);
    }

    public static final /* synthetic */ void $anonfun$initialSetup$5(Path file) {
        if (Files.exists(file, new LinkOption[0])) {
            Files.delete(file);
            return;
        }
    }

    private final String getSimulationsFolder$1(String folder) {
        Option option = StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(folder));
        if (option instanceof Some) {
            Some some = (Some)option;
            String f = (String)some.value();
            return f;
        }
        if (scala.sys.package$.MODULE$.env().contains((Object)"GATLING_HOME")) {
            return ((Path)GatlingFiles$.MODULE$.customResourcesDirectory(gatlingConfiguration.core().directory()).getOrElse((Function0 & Serializable)() -> MODULE$.DefaultSimulationsDirectory())).toFile().toString();
        }
        return Properties$.MODULE$.userHome();
    }

    private final String getResourcesFolder$1(Config config$1) {
        if (config$1.hasPath(ConfigKeys$core$.MODULE$.ResourcesFolder())) {
            return config$1.getString(ConfigKeys$core$.MODULE$.ResourcesFolder());
        }
        return ((Path)GatlingFiles$.MODULE$.customResourcesDirectory(gatlingConfiguration.core().directory()).getOrElse((Function0 & Serializable)() -> MODULE$.DefaultResourcesDirectory())).toFile().toString();
    }

    private RecorderConfiguration$() {
    }
}

