/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.request.builder;

import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.core.body.Body;
import io.gatling.core.body.ByteArrayBody;
import io.gatling.core.body.ElBody;
import io.gatling.core.body.InputStreamBody;
import io.gatling.core.body.RawFileBody;
import io.gatling.core.body.ResourceAndCachedBytes;
import io.gatling.core.body.StringBody;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.core.util.Resource;
import io.gatling.http.cache.ContentCacheEntry;
import io.gatling.http.cache.Http2PriorKnowledgeSupport$;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.client.Param;
import io.gatling.http.client.Request;
import io.gatling.http.client.RequestBuilder;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.bytearray.ByteArrayRequestBodyBuilder;
import io.gatling.http.client.body.file.FileRequestBodyBuilder;
import io.gatling.http.client.body.form.FormUrlEncodedRequestBodyBuilder;
import io.gatling.http.client.body.is.InputStreamRequestBodyBuilder;
import io.gatling.http.client.body.multipart.MultipartFormDataRequestBodyBuilder;
import io.gatling.http.client.body.multipart.StringPart;
import io.gatling.http.client.body.string.StringRequestBodyBuilder;
import io.gatling.http.client.body.stringchunks.StringChunksRequestBodyBuilder;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.protocol.Remote$;
import io.gatling.http.request.builder.CommonAttributes;
import io.gatling.http.request.builder.HttpAttributes;
import io.gatling.http.request.builder.HttpParam;
import io.gatling.http.request.builder.HttpRequestExpressionBuilder$;
import io.gatling.http.request.builder.RequestExpressionBuilder;
import io.gatling.http.request.builder.RequestExpressionBuilder$;
import io.gatling.http.request.builder.package$;
import io.gatling.http.util.HttpHelper$;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tMr!\u0002\r\u001a\u0011\u0003!c!\u0002\u0014\u001a\u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003b\u0002\u0019\u0002\u0005\u0004%I!\r\u0005\u0007#\u0006\u0001\u000b\u0011\u0002\u001a\t\u000be\u000bA\u0011\u0002.\u0007\u000b\u0019J\u0002!a\u0005\t\u0015\u0005maA!A!\u0002\u0013\ti\u0002\u0003\u0006\u0002$\u0019\u0011\t\u0011)A\u0005\u0003KA!\"a\u000b\u0007\u0005\u0003\u0005\u000b\u0011BA\u0017\u0011)\tID\u0002B\u0001B\u0003%\u00111\b\u0005\u000b\u0003\u000f2!\u0011!Q\u0001\n\u0005%\u0003B\u0002\u0018\u0007\t\u0003\t)\u0006C\u0004\u0002d\u0019!I!!\u001a\t\u000f\u0005\u0015g\u0001\"\u0003\u0002H\"9\u0011q\u001b\u0004\u0005\n\u0005e\u0007bBAp\r\u0011%\u0011\u0011\u001d\u0005\b\u0003g4A\u0011BA{\u0011%\tYP\u0002b\u0001\n\u0013\ti\u0010\u0003\u0005\u0003\u000e\u0019\u0001\u000b\u0011BA\u0000\u0011\u001d\u0011yA\u0002C)\u0005#AqAa\u0007\u0007\t#\ni\u0010C\u0004\u0003\u001e\u0019!IAa\b\t\u000f\t5b\u0001\"\u0011\u00030\u0005a\u0002\n\u001e;q%\u0016\fX/Z:u\u000bb\u0004(/Z:tS>t')^5mI\u0016\u0014(B\u0001\u000e\u001c\u0003\u001d\u0011W/\u001b7eKJT!\u0001H\u000f\u0002\u000fI,\u0017/^3ti*\u0011adH\u0001\u0005QR$\bO\u0003\u0002!C\u00059q-\u0019;mS:<'\"\u0001\u0012\u0002\u0005%|7\u0001\u0001\t\u0003K\u0005i\u0011!\u0007\u0002\u001d\u0011R$\bOU3rk\u0016\u001cH/\u0012=qe\u0016\u001c8/[8o\u0005VLG\u000eZ3s'\t\t\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\n\u0011DY8esB\u000b'\u000f^:U_6+H\u000e^5qCJ$8OW3s_V\t!\u0007E\u00024qij\u0011\u0001\u000e\u0006\u0003kY\n!B^1mS\u0012\fG/[8o\u0015\t9t$A\u0004d_6lwN\\:\n\u0005e\"$A\u0003,bY&$\u0017\r^5p]B\u00191\b\u0011\"\u000e\u0003qR!!\u0010 \u0002\u0013%lW.\u001e;bE2,'BA +\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0003r\u0012A\u0001T5tiB\u00121i\u0014\t\u0004\t.kU\"A#\u000b\u0005\u0019;\u0015!C7vYRL\u0007/\u0019:u\u0015\tA\u0015*\u0001\u0003c_\u0012L(B\u0001&\u001e\u0003\u0019\u0019G.[3oi&\u0011A*\u0012\u0002\u0005!\u0006\u0014H\u000f\u0005\u0002O\u001f2\u0001A!\u0003)\u0005\u0003\u0003\u0005\tQ!\u0001S\u0005\ryF%M\u0001\u001bE>$\u0017\u0010U1siN$v.T;mi&\u0004\u0018M\u001d;t5\u0016\u0014x\u000eI\t\u0003'Z\u0003\"!\u000b+\n\u0005US#a\u0002(pi\"Lgn\u001a\t\u0003S]K!\u0001\u0017\u0016\u0003\u0007\u0005s\u00170A\u000bc_\u0012L\b+\u0019:ugR{W*\u001e7uSB\f'\u000f^:\u0015\u0007mc7\u000fE\u00024qq\u00032!X3h\u001d\tq6M\u0004\u0002`E6\t\u0001M\u0003\u0002bG\u00051AH]8pizJ\u0011aK\u0005\u0003I*\nq\u0001]1dW\u0006<W-\u0003\u0002BM*\u0011AM\u000b\u0019\u0003Q*\u00042\u0001R&j!\tq%\u000eB\u0005l\u000b\u0005\u0005\t\u0011!B\u0001%\n\u0019q\f\n\u001a\t\u000b5,\u0001\u0019\u00018\u0002\u0013\t|G-\u001f)beR\u001c\bcA/f_B\u0011\u0001/]\u0007\u00027%\u0011!o\u0007\u0002\t\u0005>$\u0017\u0010U1si\")A/\u0002a\u0001k\u000691/Z:tS>t\u0007C\u0001<{\u001b\u00059(B\u0001;y\u0015\tIx$\u0001\u0003d_J,\u0017BA>x\u0005\u001d\u0019Vm]:j_:Dc!B?\u0002\f\u00055\u0001c\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001\u00027b]\u001eT!!!\u0002\u0002\t)\fg/Y\u0005\u0004\u0003\u0013y(\u0001E*vaB\u0014Xm]:XCJt\u0017N\\4t\u0003\u00151\u0018\r\\;fY\t\ty!\t\u0002\u0002\u0012\u0005\u0001sN]4/o\u0006\u0014HO]3n_Z,'OL<beR\u001ch\u0006T5ti\u0006\u0003\b/\u001a8e'\r1\u0011Q\u0003\t\u0004K\u0005]\u0011bAA\r3\tA\"+Z9vKN$X\t\u001f9sKN\u001c\u0018n\u001c8Ck&dG-\u001a:\u0002!\r|W.\\8o\u0003R$(/\u001b2vi\u0016\u001c\bcA\u0013\u0002 %\u0019\u0011\u0011E\r\u0003!\r{W.\\8o\u0003R$(/\u001b2vi\u0016\u001c\u0018A\u00045uiB\fE\u000f\u001e:jEV$Xm\u001d\t\u0004K\u0005\u001d\u0012bAA\u00153\tq\u0001\n\u001e;q\u0003R$(/\u001b2vi\u0016\u001c\u0018A\u00035uiB\u001c\u0015m\u00195fgB!\u0011qFA\u001b\u001b\t\t\tDC\u0002\u00024u\tQaY1dQ\u0016LA!a\u000e\u00022\tQ\u0001\n\u001e;q\u0007\u0006\u001c\u0007.Z:\u0002\u0019!$H\u000f\u001d)s_R|7m\u001c7\u0011\t\u0005u\u00121I\u0007\u0003\u0003\u007fQ1!!\u0011\u001e\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA#\u0003\u007f\u0011A\u0002\u0013;uaB\u0013x\u000e^8d_2\fQbY8oM&<WO]1uS>t\u0007\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=\u00030\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003'\niE\u0001\u000bHCRd\u0017N\\4D_:4\u0017nZ;sCRLwN\u001c\u000b\r\u0003/\nI&a\u0017\u0002^\u0005}\u0013\u0011\r\t\u0003K\u0019Aq!a\u0007\r\u0001\u0004\ti\u0002C\u0004\u0002$1\u0001\r!!\n\t\u000f\u0005-B\u00021\u0001\u0002.!9\u0011\u0011\b\u0007A\u0002\u0005m\u0002bBA$\u0019\u0001\u0007\u0011\u0011J\u0001%[\u0016\u0014x-\u001a$pe6\u0004\u0016M]1ng\u0006sGMR8s[&sGo\u001c)be\u0006l'\nT5tiRA\u0011qMA>\u0003\u000f\u000b\u0019\r\u0005\u00034q\u0005%\u0004CBA6\u0003c\n\u0019(\u0004\u0002\u0002n)!\u0011qNA\u0002\u0003\u0011)H/\u001b7\n\u0007\u0005\u000bi\u0007\u0005\u0003\u0002v\u0005]T\"A%\n\u0007\u0005e\u0014JA\u0003QCJ\fW\u000eC\u0004\u0002~5\u0001\r!a \u0002\rA\f'/Y7t!\u0011iV-!!\u0011\u0007\u0015\n\u0019)C\u0002\u0002\u0006f\u0011\u0011\u0002\u0013;uaB\u000b'/Y7\t\u000f\u0005%U\u00021\u0001\u0002\f\u0006Iam\u001c:n\u001b\u0006L(-\u001a\t\u0006S\u00055\u0015\u0011S\u0005\u0004\u0003\u001fS#AB(qi&|g\u000e\u0005\u0004\u0002\u0014\u0006\u001d\u0016Q\u0016\b\u0005\u0003+\u000b)K\u0004\u0003\u0002\u0018\u0006\rf\u0002BAM\u0003CsA!a'\u0002 :\u0019q,!(\n\u0003\tJ!\u0001I\u0011\n\u0005e|\u0012B\u0001;y\u0013\t!w/\u0003\u0003\u0002*\u0006-&AC#yaJ,7o]5p]*\u0011Am\u001e\t\b\u0003_\u000b9,!0W\u001d\u0011\t\t,a-\u0011\u0005}S\u0013bAA[U\u00051\u0001K]3eK\u001aLA!!/\u0002<\n\u0019Q*\u00199\u000b\u0007\u0005U&\u0006\u0005\u0003\u00020\u0006}\u0016\u0002BAa\u0003w\u0013aa\u0015;sS:<\u0007\"\u0002;\u000e\u0001\u0004)\u0018AG2p]\u001aLw-\u001e:f\u001bVdG/\u001b9beR4uN]7ECR\fGCBAe\u0003#\f\u0019\u000e\u0005\u00034q\u0005-\u0007\u0003BA;\u0003\u001bL1!a4J\u00059\u0011V-];fgR\u0014U/\u001b7eKJDQ\u0001\u001e\bA\u0002UDq!!6\u000f\u0001\u0004\tY-\u0001\bsKF,Xm\u001d;Ck&dG-\u001a:\u0002/\r|gNZ5hkJ,gi\u001c:n+JdWI\\2pI\u0016$GCBAe\u00037\fi\u000eC\u0003u\u001f\u0001\u0007Q\u000fC\u0004\u0002V>\u0001\r!a3\u0002\u000fM,GOQ8esRA\u0011\u0011ZAr\u0003K\f9\u000fC\u0003u!\u0001\u0007Q\u000fC\u0004\u0002VB\u0001\r!a3\t\r!\u0003\u0002\u0019AAu!\u0011\tY/a<\u000e\u0005\u00055(B\u0001%y\u0013\u0011\t\t0!<\u0003\t\t{G-_\u0001\u000eG>tg-[4ve\u0016\u0014u\u000eZ=\u0015\r\u0005%\u0017q_A}\u0011\u0015!\u0018\u00031\u0001v\u0011\u001d\t).\u0005a\u0001\u0003\u0017\fqcY8oM&<WO]3Qe&|'o\u00138po2,GmZ3\u0016\u0005\u0005}\b\u0003\u0002B\u0001\u0005\u000fq1!\nB\u0002\u0013\r\u0011)!G\u0001\u0019%\u0016\fX/Z:u\u000bb\u0004(/Z:tS>t')^5mI\u0016\u0014\u0018\u0002\u0002B\u0005\u0005\u0017\u0011qCU3rk\u0016\u001cHOQ;jY\u0012,'oQ8oM&<WO]3\u000b\u0007\t\u0015\u0011$\u0001\rd_:4\u0017nZ;sKB\u0013\u0018n\u001c:L]><H.\u001a3hK\u0002\nqcY8oM&<WO]3SKF,Xm\u001d;US6,w.\u001e;\u0015\t\tM!\u0011\u0004\t\u0004S\tU\u0011b\u0001B\fU\t!QK\\5u\u0011\u001d\t)\u000e\u0006a\u0001\u0003\u0017\f!eY8oM&<WO]3SKF,Xm\u001d;Ck&dG-\u001a:G_J\u0004&o\u001c;pG>d\u0017aF2p]\u001aLw-\u001e:f\u0007\u0006\u001c\u0007.\u001b8h\u0011\u0016\fG-\u001a:t)\u0011\u0011\tCa\u000b\u0015\t\t\r\"\u0011\u0006\t\u0005\u0003k\u0012)#C\u0002\u0003(%\u0013qAU3rk\u0016\u001cH\u000f\u0003\u0004\u001d-\u0001\u0007!1\u0005\u0005\u0006iZ\u0001\r!^\u0001\u0006EVLG\u000eZ\u000b\u0003\u0005c\u0001b!a%\u0002(\n\r\u0002")
public class HttpRequestExpressionBuilder
extends RequestExpressionBuilder {
    private final HttpAttributes httpAttributes;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final GatlingConfiguration configuration;
    private final Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configurePriorKnowledge;

    private Validation<java.util.List<Param>> mergeFormParamsAndFormIntoParamJList(List<HttpParam> params, Option<Function1<Session, Validation<Map<String, Object>>>> formMaybe, Session session) {
        Validation validation;
        Validation formParams = package$.MODULE$.resolveParamJList(params, session);
        Option<Function1<Session, Validation<Map<String, Object>>>> option = formMaybe;
        if (option instanceof Some) {
            Some some = (Some)option;
            Function1 form = (Function1)some.value();
            validation = formParams.flatMap((Function1 & Serializable)resolvedFormParams -> ((Validation)form.apply((Object)session)).map((Function1 & Serializable)resolvedForm -> {
                Map formParamsByName = CollectionConverters$.MODULE$.ListHasAsScala(resolvedFormParams).asScala().groupBy((Function1 & Serializable)x$1 -> x$1.getName());
                Map formFieldsByName = (Map)resolvedForm.map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = x0$1;
                    if (tuple22 != null) {
                        String key = (String)tuple22._1();
                        Object value2 = tuple22._2();
                        Object object = value2;
                        if (object instanceof scala.collection.immutable.Seq) {
                            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)object;
                            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), seq.map((Function1 & Serializable)value -> new Param(key, value.toString())));
                        } else {
                            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Param[]{new Param(key, object.toString())})));
                        }
                    } else {
                        throw new MatchError((Object)tuple22);
                    }
                    Tuple2 tuple23 = tuple2;
                    return tuple23;
                });
                java.util.List javaParams = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((MapOps)formFieldsByName.$plus$plus((IterableOnce)formParamsByName)).values().flatten(Predef$.MODULE$.$conforms())).toSeq()).asJava();
                return javaParams;
            }));
        } else {
            validation = formParams;
        }
        return validation;
    }

    private Validation<RequestBuilder> configureMultipartFormData(Session session, RequestBuilder requestBuilder) {
        return this.mergeFormParamsAndFormIntoParamJList(this.httpAttributes.formParams(), this.httpAttributes.form(), session).flatMap((Function1 & Serializable)params -> {
            Buffer stringParts = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(params).asScala().map((Function1 & Serializable)param -> new StringPart(param.getName(), param.getValue(), this.charset(), null, null, null, null, null));
            return HttpRequestExpressionBuilder$.MODULE$.io$gatling$http$request$builder$HttpRequestExpressionBuilder$$bodyPartsToMultiparts($this.httpAttributes.bodyParts(), session).map((Function1 & Serializable)parts -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new MultipartFormDataRequestBodyBuilder(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)stringParts.$plus$plus((IterableOnce)parts)).asJava())));
        });
    }

    private Validation<RequestBuilder> configureFormUrlEncoded(Session session, RequestBuilder requestBuilder) {
        return this.mergeFormParamsAndFormIntoParamJList(this.httpAttributes.formParams(), this.httpAttributes.form(), session).map((Function1 & Serializable)params -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new FormUrlEncodedRequestBodyBuilder(params)));
    }

    private Validation<RequestBuilder> setBody(Session session, RequestBuilder requestBuilder, Body body) {
        Validation validation;
        Body body2 = body;
        if (body2 instanceof StringBody) {
            StringBody stringBody = (StringBody)body2;
            Function1 string = stringBody.string();
            validation = ((Validation)string.apply((Object)session)).map((Function1 & Serializable)s -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new StringRequestBodyBuilder(s)));
        } else if (body2 instanceof RawFileBody) {
            RawFileBody rawFileBody = (RawFileBody)body2;
            Function1 resourceWithCachedBytes = rawFileBody.resourceAndCachedBytes();
            validation = ((Validation)resourceWithCachedBytes.apply((Object)session)).map((Function1 & Serializable)x0$1 -> {
                FileRequestBodyBuilder fileRequestBodyBuilder;
                ResourceAndCachedBytes resourceAndCachedBytes = x0$1;
                if (resourceAndCachedBytes != null) {
                    Resource resource = resourceAndCachedBytes.resource();
                    Option cachedBytes = resourceAndCachedBytes.cachedBytes();
                    Option option = cachedBytes;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        byte[] bytes = (byte[])some.value();
                        fileRequestBodyBuilder = new ByteArrayRequestBodyBuilder(bytes, resource.name());
                    } else {
                        fileRequestBodyBuilder = new FileRequestBodyBuilder(resource.file());
                    }
                } else {
                    throw new MatchError((Object)resourceAndCachedBytes);
                }
                FileRequestBodyBuilder requestBodyBuilder = fileRequestBodyBuilder;
                RequestBuilder requestBuilder = requestBuilder.setBodyBuilder((RequestBodyBuilder)requestBodyBuilder);
                return requestBuilder;
            });
        } else if (body2 instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = (ByteArrayBody)body2;
            Function1 bytes = byteArrayBody.bytes();
            validation = ((Validation)bytes.apply((Object)session)).map((Function1 & Serializable)b -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new ByteArrayRequestBodyBuilder(b, null)));
        } else if (body2 instanceof ElBody) {
            ElBody elBody = (ElBody)body2;
            validation = ((Validation)elBody.asStringWithCachedBytes().apply((Object)session)).map((Function1 & Serializable)chunks -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new StringChunksRequestBodyBuilder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)chunks).asJava())));
        } else if (body2 instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = (InputStreamBody)body2;
            Function1 is2 = inputStreamBody.is();
            validation = ((Validation)is2.apply((Object)session)).map((Function1 & Serializable)is -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new InputStreamRequestBodyBuilder(is)));
        } else {
            throw new MatchError((Object)body2);
        }
        return validation;
    }

    private Validation<RequestBuilder> configureBody(Session session, RequestBuilder requestBuilder) {
        Validation<RequestBuilder> validation;
        Predef$.MODULE$.require(this.httpAttributes.body().isEmpty() || this.httpAttributes.bodyParts().isEmpty(), (Function0 & Serializable)() -> "Can't have both a body and body parts!");
        Option<Body> option = this.httpAttributes.body();
        if (option instanceof Some) {
            Some some = (Some)option;
            Body body = (Body)some.value();
            validation = this.setBody(session, requestBuilder, body);
        } else {
            boolean hasParts = this.httpAttributes.bodyParts().nonEmpty();
            boolean hasForm = this.httpAttributes.formParams().nonEmpty() || this.httpAttributes.form().nonEmpty();
            boolean hadExplicitFormDataContentType = HttpHelper$.MODULE$.isMultipartFormData(requestBuilder.getContentType());
            validation = hasParts || hasForm && hadExplicitFormDataContentType ? this.configureMultipartFormData(session, requestBuilder) : (hasForm ? this.configureFormUrlEncoded(session, requestBuilder) : package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)requestBuilder)));
        }
        return validation;
    }

    private Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configurePriorKnowledge() {
        return this.configurePriorKnowledge;
    }

    @Override
    public void configureRequestTimeout(RequestBuilder requestBuilder) {
        requestBuilder.setRequestTimeout(((FiniteDuration)this.httpAttributes.requestTimeout().getOrElse((Function0 & Serializable)() -> $this.configuration.http().requestTimeout())).toMillis());
    }

    @Override
    public Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configureRequestBuilderForProtocol() {
        return (Function1 & Serializable)session -> (Function1 & Serializable)requestBuilder -> this.configureBody((Session)session, (RequestBuilder)requestBuilder).flatMap((Function1)this.configurePriorKnowledge().apply(session));
    }

    private Request configureCachingHeaders(Session session, Request request) {
        this.httpCaches.contentCacheEntry(session, request).foreach((Function1 & Serializable)x0$1 -> {
            HttpRequestExpressionBuilder.$anonfun$configureCachingHeaders$1(request, x0$1);
            return BoxedUnit.UNIT;
        });
        return request;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Function1<Session, Validation<Request>> build() {
        void var1_1;
        Function1<Session, Validation<Request>> exp = super.build();
        return this.httpProtocol.requestPart().cache() ? session -> ((Validation)exp.apply(session)).map((Function1 & Serializable)request -> this.configureCachingHeaders((Session)session, (Request)request)) : var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$configurePriorKnowledge$3(boolean x$3) {
        return x$3;
    }

    public static final /* synthetic */ void $anonfun$configureCachingHeaders$1(Request request$1, ContentCacheEntry x0$1) {
        ContentCacheEntry contentCacheEntry = x0$1;
        if (contentCacheEntry == null) {
            throw new MatchError((Object)contentCacheEntry);
        }
        Option<String> etag = contentCacheEntry.etag();
        Option<String> lastModified = contentCacheEntry.lastModified();
        etag.foreach((Function1 & Serializable)x$4 -> request$1.getHeaders().set((CharSequence)HttpHeaderNames.IF_NONE_MATCH, x$4));
        lastModified.foreach((Function1 & Serializable)x$5 -> request$1.getHeaders().set((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE, x$5));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public HttpRequestExpressionBuilder(CommonAttributes commonAttributes, HttpAttributes httpAttributes, HttpCaches httpCaches, HttpProtocol httpProtocol, GatlingConfiguration configuration) {
        this.httpAttributes = httpAttributes;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        this.configuration = configuration;
        super(commonAttributes, httpCaches, httpProtocol, configuration);
        this.configurePriorKnowledge = httpProtocol.enginePart().enableHttp2() ? session -> (Function1 & Serializable)requestBuilder -> {
            Option<Object> http2PriorKnowledge = Http2PriorKnowledgeSupport$.MODULE$.isHttp2PriorKnowledge((Session)session, Remote$.MODULE$.apply(requestBuilder.getUri()));
            return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)requestBuilder.setHttp2Enabled(true).setAlpnRequired(http2PriorKnowledge.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HttpRequestExpressionBuilder.$anonfun$configurePriorKnowledge$3(BoxesRunTime.unboxToBoolean((Object)x$3))))).setHttp2PriorKnowledge(http2PriorKnowledge.contains((Object)BoxesRunTime.boxToBoolean((boolean)true)))));
        } : RequestExpressionBuilder$.MODULE$.ConfigureIdentity();
    }
}

