/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.ws.fsm;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.Status;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.http.action.ws.fsm.NextWsState;
import io.gatling.http.action.ws.fsm.SendBinaryFrame;
import io.gatling.http.action.ws.fsm.SendFrame;
import io.gatling.http.action.ws.fsm.SendTextFrame;
import io.gatling.http.action.ws.fsm.WsClosedState;
import io.gatling.http.action.ws.fsm.WsConnectingState$;
import io.gatling.http.action.ws.fsm.WsFsm;
import io.gatling.http.action.ws.fsm.WsState;
import io.gatling.http.check.ws.WsFrameCheck;
import io.gatling.http.check.ws.WsFrameCheckSequence;
import java.io.Serializable;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001\u0002\u0006\f\u0005aA\u0001\u0002\u0004\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!AA\b\u0001BC\u0002\u0013\u0005Q\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u0015A\u0005\u0001\"\u0011J\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015Y\b\u0001\"\u0011}\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'\u0011abV:De\u0006\u001c\b.\u001a3Ti\u0006$XM\u0003\u0002\r\u001b\u0005\u0019am]7\u000b\u00059y\u0011AA<t\u0015\t\u0001\u0012#\u0001\u0004bGRLwN\u001c\u0006\u0003%M\tA\u0001\u001b;ua*\u0011A#F\u0001\bO\u0006$H.\u001b8h\u0015\u00051\u0012AA5p\u0007\u0001\u00192\u0001A\r\u001e!\tQ2$D\u0001\f\u0013\ta2BA\u0004XgN#\u0018\r^3\u0011\u0005y)S\"A\u0010\u000b\u0005\u0001\n\u0013\u0001D:dC2\fGn\\4hS:<'B\u0001\u0012$\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0013\u0002\u0007\r|W.\u0003\u0002'?\ti1\u000b\u001e:jGRdunZ4j]\u001e\u0004\"A\u0007\u0015\n\u0005%Z!!B,t\rNl\u0017\u0001D3se>\u0014X*Z:tC\u001e,\u0007c\u0001\u00170c5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TF\u0001\u0004PaRLwN\u001c\t\u0003eer!aM\u001c\u0011\u0005QjS\"A\u001b\u000b\u0005Y:\u0012A\u0002\u001fs_>$h(\u0003\u00029[\u00051\u0001K]3eK\u001aL!AO\u001e\u0003\rM#(/\u001b8h\u0015\tAT&A\nsK6\f\u0017N\\5oOJ+7m\u001c8oK\u000e$8/F\u0001?!\tas(\u0003\u0002A[\t\u0019\u0011J\u001c;\u0002)I,W.Y5oS:<'+Z2p]:,7\r^:!\u0003\u0019a\u0014N\\5u}Q!A)\u0012$H!\tQ\u0002\u0001C\u0003\r\u000b\u0001\u0007q\u0005C\u0003+\u000b\u0001\u00071\u0006C\u0003=\u000b\u0001\u0007a(\u0001\u000bp]\u000ec\u0017.\u001a8u\u00072|7/\u001a*fcV,7\u000f\u001e\u000b\u0005\u00156{\u0005\f\u0005\u0002\u001b\u0017&\u0011Aj\u0003\u0002\f\u001d\u0016DHoV:Ti\u0006$X\rC\u0003O\r\u0001\u0007\u0011'\u0001\u0006bGRLwN\u001c(b[\u0016DQ\u0001\u0015\u0004A\u0002E\u000bqa]3tg&|g\u000e\u0005\u0002S-6\t1K\u0003\u0002Q)*\u0011QkE\u0001\u0005G>\u0014X-\u0003\u0002X'\n91+Z:tS>t\u0007\"B-\u0007\u0001\u0004Q\u0016\u0001\u00028fqR\u0004\"aW/\u000e\u0003qS!\u0001\u0005+\n\u0005yc&AB!di&|g.A\bp]N+g\u000e\u001a+fqR4%/Y7f)\u0019Q\u0015M\u00193zu\")aj\u0002a\u0001c!)1m\u0002a\u0001c\u00059Q.Z:tC\u001e,\u0007\"B3\b\u0001\u00041\u0017AD2iK\u000e\\7+Z9vK:\u001cWm\u001d\t\u0004O2|gB\u00015k\u001d\t!\u0014.C\u0001/\u0013\tYW&A\u0004qC\u000e\\\u0017mZ3\n\u00055t'\u0001\u0002'jgRT!a[\u0017\u0011\u0007A$h/D\u0001r\u0015\tq!O\u0003\u0002t#\u0005)1\r[3dW&\u0011Q/\u001d\u0002\u0015/N4%/Y7f\u0007\",7m[*fcV,gnY3\u0011\u0005A<\u0018B\u0001=r\u0005196O\u0012:b[\u0016\u001c\u0005.Z2l\u0011\u0015\u0001v\u00011\u0001R\u0011\u0015Iv\u00011\u0001[\u0003EygnU3oI\nKg.\u0019:z\rJ\fW.\u001a\u000b\n\u0015vt\u00181BA\u0007\u0003\u001fAQA\u0014\u0005A\u0002EBQa\u0019\u0005A\u0002}\u0004R\u0001LA\u0001\u0003\u000bI1!a\u0001.\u0005\u0015\t%O]1z!\ra\u0013qA\u0005\u0004\u0003\u0013i#\u0001\u0002\"zi\u0016DQ!\u001a\u0005A\u0002\u0019DQ\u0001\u0015\u0005A\u0002ECQ!\u0017\u0005A\u0002i\u000ba\u0003[1oI2,7+\u001a8e\rJ\fW.\u001a$bS2,(/\u001a\u000b\f\u0015\u0006U\u0011qCA\r\u00037\t)\u0003C\u0003O\u0013\u0001\u0007\u0011\u0007C\u0003Q\u0013\u0001\u0007\u0011\u000bC\u0003Z\u0013\u0001\u0007!\fC\u0004\u0002\u001e%\u0001\r!a\b\u0002)\u00054G/\u001a:SK\u000e|gN\\3di\u0006\u001bG/[8o!\rQ\u0012\u0011E\u0005\u0004\u0003GY!!C*f]\u00124%/Y7f\u0011\u0019\t9#\u0003a\u0001c\u0005IaM]1nKRK\b/\u001a")
public final class WsCrashedState
extends WsState {
    private final WsFsm fsm;
    private final Option<String> errorMessage;
    private final int remainingReconnects;

    @Override
    public int remainingReconnects() {
        return this.remainingReconnects;
    }

    @Override
    public NextWsState onClientCloseRequest(String actionName, Session session, Action next) {
        Session session2;
        Option<String> option = this.errorMessage;
        if (option instanceof Some) {
            Some some = (Some)option;
            String mess = (String)some.value();
            Session newSession = session.markAsFailed();
            this.fsm.statsEngine().logCrash(session.scenario(), session.groups(), actionName, new StringBuilder(61).append("Client issued close order but WebSocket was already crashed: ").append(mess).toString());
            session2 = newSession;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Client issued close order but WebSocket was already closed");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            session2 = session;
        }
        Session newSession = session2.remove(this.fsm.wsName());
        return new NextWsState(new WsClosedState(this.fsm), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> next.$bang(newSession));
    }

    @Override
    public NextWsState onSendTextFrame(String actionName, String message, List<WsFrameCheckSequence<WsFrameCheck>> checkSequences, Session session, Action next) {
        return this.handleSendFrameFailure(actionName, session, next, new SendTextFrame(actionName, message, checkSequences, next), "text");
    }

    @Override
    public NextWsState onSendBinaryFrame(String actionName, byte[] message, List<WsFrameCheckSequence<WsFrameCheck>> checkSequences, Session session, Action next) {
        return this.handleSendFrameFailure(actionName, session, next, new SendBinaryFrame(actionName, message, checkSequences, next), "binary");
    }

    private NextWsState handleSendFrameFailure(String actionName, Session session, Action next, SendFrame afterReconnectAction, String frameType) {
        NextWsState nextWsState;
        BoxedUnit boxedUnit;
        String string;
        Option<String> option = this.errorMessage;
        if (option instanceof Some) {
            Some some = (Some)option;
            String mess = (String)some.value();
            string = new StringBuilder(58).append("Client issued a ").append(frameType).append(" frame but WebSocket was already crashed: ").append(mess).toString();
        } else {
            string = "Client issued a $frameType frame but WebSocket was already closed";
        }
        String loggedMessage = string;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(loggedMessage);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.remainingReconnects() > 0) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Reconnecting WebSocket remainingReconnects={}", (Object)BoxesRunTime.boxToInteger((int)this.remainingReconnects()));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            nextWsState = WsConnectingState$.MODULE$.gotoConnecting(this.fsm, session, (Either<Action, SendFrame>)package$.MODULE$.Right().apply((Object)afterReconnectAction), this.remainingReconnects() - 1);
        } else {
            BoxedUnit boxedUnit3;
            long now = this.fsm.clock().nowMillis();
            String message = new StringBuilder(86).append("Client issued ").append(frameType).append(" frame but server has closed the WebSocket and max reconnects is reached").toString();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(message);
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            Session newSession = this.logResponse(session, actionName, now, now, (Status)KO$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)message));
            nextWsState = new NextWsState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> next.$bang(newSession));
        }
        return nextWsState;
    }

    public WsCrashedState(WsFsm fsm, Option<String> errorMessage, int remainingReconnects) {
        this.fsm = fsm;
        this.errorMessage = errorMessage;
        this.remainingReconnects = remainingReconnects;
        super(fsm);
    }
}

