/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine;

import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Hex$;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.http.client.HttpListener;
import io.gatling.http.engine.GatlingHttpListener$;
import io.gatling.http.engine.response.ResponseProcessor;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.response.HttpResult;
import io.gatling.http.response.Response;
import io.gatling.http.response.ResponseBody;
import io.gatling.http.response.ResponseBody$;
import io.gatling.http.util.HttpHelper$;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.MapFactory;
import scala.collection.MapFactory$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t\rs!B\u00193\u0011\u0003Yd!B\u001f3\u0011\u0003q\u0004\"B(\u0002\t\u0003\u0001\u0006\"B)\u0002\t\u0013\u0011\u0006\"\u00027\u0002\t\u0013ig!B\u001f3\u0001\u00055\u0001\u0002\u0003:\u0006\u0005\u0003\u0005\u000b\u0011B:\t\u0015\u0005\u001dRA!A!\u0002\u0013\tI\u0003\u0003\u0006\u0002:\u0015\u0011\t\u0011)A\u0005\u0003wAaaT\u0003\u0005\u0002\u0005\u001d\u0003\"CA)\u000b\u0001\u0007I\u0011BA*\u0011%\tY&\u0002a\u0001\n\u0013\ti\u0006\u0003\u0005\u0002d\u0015\u0001\u000b\u0015BA+\u0011%\t)'\u0002a\u0001\n\u0013\t\u0019\u0006C\u0005\u0002h\u0015\u0001\r\u0011\"\u0003\u0002j!A\u0011QN\u0003!B\u0013\t)\u0006C\u0006\u0002p\u0015\u0001\r\u00111A\u0005\n\u0005M\u0003bCA9\u000b\u0001\u0007\t\u0019!C\u0005\u0003gB1\"a\u001e\u0006\u0001\u0004\u0005\t\u0015)\u0003\u0002V!Y\u0011\u0011P\u0003A\u0002\u0003\u0007I\u0011BA>\u0011-\t\u0019)\u0002a\u0001\u0002\u0004%I!!\"\t\u0017\u0005%U\u00011A\u0001B\u0003&\u0011Q\u0010\u0005\f\u0003\u0017+\u0001\u0019!a\u0001\n\u0013\tY\bC\u0006\u0002\u000e\u0016\u0001\r\u00111A\u0005\n\u0005=\u0005bCAJ\u000b\u0001\u0007\t\u0011)Q\u0005\u0003{B1\"!&\u0006\u0001\u0004\u0005\r\u0011\"\u0003\u0002T!Y\u0011qS\u0003A\u0002\u0003\u0007I\u0011BAM\u0011-\ti*\u0002a\u0001\u0002\u0003\u0006K!!\u0016\t\u0017\u0005}U\u00011AA\u0002\u0013%\u0011\u0011\u0015\u0005\f\u0003S+\u0001\u0019!a\u0001\n\u0013\tY\u000bC\u0006\u00020\u0016\u0001\r\u0011!Q!\n\u0005\r\u0006\u0002\u00030\u0006\u0001\u0004%I!!-\t\u0013\u0005MV\u00011A\u0005\n\u0005U\u0006bBA]\u000b\u0001\u0006Ka\u0018\u0005\n\u0003w+\u0001\u0019!C\u0005\u0003{C\u0011\"!2\u0006\u0001\u0004%I!a2\t\u0011\u0005-W\u0001)Q\u0005\u0003\u007fC\u0011\"!4\u0006\u0001\u0004%I!a4\t\u0013\u0005\rX\u00011A\u0005\n\u0005\u0015\b\u0002CAu\u000b\u0001\u0006K!!5\t\u000f\u0005-X\u0001\"\u0011\u0002n\"9\u0011q^\u0003\u0005B\u0005E\bbBA{\u000b\u0011\u0005\u0013q\u001f\u0005\b\u0003{,A\u0011IA\u0000\u0011\u001d\u0011I!\u0002C\u0005\u0005\u0017AqAa\u0006\u0006\t\u0013\u0011I\u0002C\u0004\u0003\u0018\u0015!IA!\n\t\u000f\tmR\u0001\"\u0003\u0002n\"9!QH\u0003\u0005B\t}\u0012aE$bi2Lgn\u001a%uiBd\u0015n\u001d;f]\u0016\u0014(BA\u001a5\u0003\u0019)gnZ5oK*\u0011QGN\u0001\u0005QR$\bO\u0003\u00028q\u00059q-\u0019;mS:<'\"A\u001d\u0002\u0005%|7\u0001\u0001\t\u0003y\u0005i\u0011A\r\u0002\u0014\u000f\u0006$H.\u001b8h\u0011R$\b\u000fT5ti\u0016tWM]\n\u0004\u0003}*\u0005C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%AB!osJ+g\r\u0005\u0002G\u001b6\tqI\u0003\u0002I\u0013\u0006a1oY1mC2|wmZ5oO*\u0011!jS\u0001\tif\u0004Xm]1gK*\tA*A\u0002d_6L!AT$\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t1(\u0001\bsKN|GN^3DQ\u0006\u00148/\u001a;\u0015\u0007Mk&\u000e\u0005\u0002U76\tQK\u0003\u0002W/\u000691\r[1sg\u0016$(B\u0001-Z\u0003\rq\u0017n\u001c\u0006\u00025\u0006!!.\u0019<b\u0013\taVKA\u0004DQ\u0006\u00148/\u001a;\t\u000by\u001b\u0001\u0019A0\u0002\u000f!,\u0017\rZ3sgB\u0011\u0001\r[\u0007\u0002C*\u0011QG\u0019\u0006\u0003G\u0012\fQaY8eK\u000eT!!\u001a4\u0002\u000f!\fg\u000e\u001a7fe*\u0011q\rO\u0001\u0006]\u0016$H/_\u0005\u0003S\u0006\u00141\u0002\u0013;ua\"+\u0017\rZ3sg\")1n\u0001a\u0001'\u0006qA-\u001a4bk2$8\t[1sg\u0016$\u0018a\u00047pOJ+\u0017/^3ti\u000e\u0013\u0018m\u001d5\u0015\u00079\f\b\u0010\u0005\u0002A_&\u0011\u0001/\u0011\u0002\u0005+:LG\u000fC\u0003s\t\u0001\u00071/\u0001\u0002uqB\u0011AO^\u0007\u0002k*\u0011!OM\u0005\u0003oV\u0014a\u0001\u0013;uaRC\b\"B=\u0005\u0001\u0004Q\u0018!\u0003;ie><\u0018M\u00197f!\rY\u0018q\u0001\b\u0004y\u0006\rabA?\u0002\u00025\taP\u0003\u0002\u0000u\u00051AH]8pizJ\u0011AQ\u0005\u0004\u0003\u000b\t\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003\u0013\tYAA\u0005UQJ|w/\u00192mK*\u0019\u0011QA!\u0014\u000b\u0015\ty!a\u0007\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006Z\u0003\u0011a\u0017M\\4\n\t\u0005e\u00111\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t5\u0003\u0019\u0019G.[3oi&!\u0011QEA\u0010\u00051AE\u000f\u001e9MSN$XM\\3s\u0003\u0015\u0019Gn\\2l!\u0011\tY#!\u000e\u000e\u0005\u00055\"\u0002BA\u0018\u0003c\tA!\u001e;jY*\u0019\u00111\u0007\u001c\u0002\u000f\r|W.\\8og&!\u0011qGA\u0017\u0005\u0015\u0019En\\2l\u0003E\u0011Xm\u001d9p]N,\u0007K]8dKN\u001cxN\u001d\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011\t\u001a\u0002\u0011I,7\u000f]8og\u0016LA!!\u0012\u0002@\t\t\"+Z:q_:\u001cX\r\u0015:pG\u0016\u001c8o\u001c:\u0015\u0011\u0005%\u00131JA'\u0003\u001f\u0002\"\u0001P\u0003\t\u000bIL\u0001\u0019A:\t\u000f\u0005\u001d\u0012\u00021\u0001\u0002*!9\u0011\u0011H\u0005A\u0002\u0005m\u0012\u0001B5oSR,\"!!\u0016\u0011\u0007\u0001\u000b9&C\u0002\u0002Z\u0005\u0013qAQ8pY\u0016\fg.\u0001\u0005j]&$x\fJ3r)\rq\u0017q\f\u0005\n\u0003CZ\u0011\u0011!a\u0001\u0003+\n1\u0001\u001f\u00132\u0003\u0015Ig.\u001b;!\u0003\u0011!wN\\3\u0002\u0011\u0011|g.Z0%KF$2A\\A6\u0011%\t\tGDA\u0001\u0002\u0004\t)&A\u0003e_:,\u0007%\u0001\bti>\u0014X\r\u0013;nY>\u00138i]:\u0002%M$xN]3Ii6dwJ]\"tg~#S-\u001d\u000b\u0004]\u0006U\u0004\"CA1#\u0005\u0005\t\u0019AA+\u0003=\u0019Ho\u001c:f\u0011RlGn\u0014:DgN\u0004\u0013!\u0006:fcV,7\u000f^*uCJ$H+[7fgR\fW\u000e]\u000b\u0003\u0003{\u00022\u0001QA@\u0013\r\t\t)\u0011\u0002\u0005\u0019>tw-A\rsKF,Xm\u001d;Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9`I\u0015\fHc\u00018\u0002\b\"I\u0011\u0011\r\u000b\u0002\u0002\u0003\u0007\u0011QP\u0001\u0017e\u0016\fX/Z:u'R\f'\u000f\u001e+j[\u0016\u001cH/Y7qA\u0005\u0019\"/Z9vKN$XI\u001c3US6,7\u000f^1na\u00069\"/Z9vKN$XI\u001c3US6,7\u000f^1na~#S-\u001d\u000b\u0004]\u0006E\u0005\"CA1/\u0005\u0005\t\u0019AA?\u0003Q\u0011X-];fgR,e\u000e\u001a+j[\u0016\u001cH/Y7qA\u00059\u0011n\u001d%uiB\u0014\u0014aC5t\u0011R$\bOM0%KF$2A\\AN\u0011%\t\tGGA\u0001\u0002\u0004\t)&\u0001\u0005jg\"#H\u000f\u001d\u001a!\u0003\u0019\u0019H/\u0019;vgV\u0011\u00111\u0015\t\u0004A\u0006\u0015\u0016bAATC\n\u0011\u0002\n\u001e;q%\u0016\u001c\bo\u001c8tKN#\u0018\r^;t\u0003)\u0019H/\u0019;vg~#S-\u001d\u000b\u0004]\u00065\u0006\"CA1;\u0005\u0005\t\u0019AAR\u0003\u001d\u0019H/\u0019;vg\u0002*\u0012aX\u0001\fQ\u0016\fG-\u001a:t?\u0012*\u0017\u000fF\u0002o\u0003oC\u0001\"!\u0019!\u0003\u0003\u0005\raX\u0001\tQ\u0016\fG-\u001a:tA\u0005Q!m\u001c3z\u0019\u0016tw\r\u001e5\u0016\u0005\u0005}\u0006c\u0001!\u0002B&\u0019\u00111Y!\u0003\u0007%sG/\u0001\bc_\u0012LH*\u001a8hi\"|F%Z9\u0015\u00079\fI\rC\u0005\u0002b\r\n\t\u00111\u0001\u0002@\u0006Y!m\u001c3z\u0019\u0016tw\r\u001e5!\u0003\u0019\u0019\u0007.\u001e8lgV\u0011\u0011\u0011\u001b\t\u0006w\u0006M\u0017q[\u0005\u0005\u0003+\fYA\u0001\u0003MSN$\b\u0003BAm\u0003?l!!a7\u000b\u0007\u0005ug-\u0001\u0004ck\u001a4WM]\u0005\u0005\u0003C\fYNA\u0004CsR,')\u001e4\u0002\u0015\rDWO\\6t?\u0012*\u0017\u000fF\u0002o\u0003OD\u0011\"!\u0019'\u0003\u0003\u0005\r!!5\u0002\u000f\rDWO\\6tA\u00051qN\\*f]\u0012$\u0012A\\\u0001\u0014_:\u0004&o\u001c;pG>d\u0017i^1sK:,7o\u001d\u000b\u0004]\u0006M\bbBAKS\u0001\u0007\u0011QK\u0001\u000f_:DE\u000f\u001e9SKN\u0004xN\\:f)\u0015q\u0017\u0011`A~\u0011\u001d\tyJ\u000ba\u0001\u0003GCQA\u0018\u0016A\u0002}\u000bqc\u001c8IiR\u0004(+Z:q_:\u001cXMQ8es\u000eCWO\\6\u0015\u000b9\u0014\tA!\u0002\t\u000f\t\r1\u00061\u0001\u0002X\u0006)1\r[;oW\"9!qA\u0016A\u0002\u0005U\u0013\u0001\u00027bgR\fQBY;jY\u0012\u0014Vm\u001d9p]N,WC\u0001B\u0007!\u0011\u0011yAa\u0005\u000e\u0005\tE!bAA!i%!!Q\u0003B\t\u0005)AE\u000f\u001e9SKN,H\u000e^\u0001\rEVLG\u000e\u001a$bS2,(/\u001a\u000b\u0005\u00057\u0011\t\u0003\u0005\u0003\u0003\u0010\tu\u0011\u0002\u0002B\u0010\u0005#\u00111\u0002\u0013;ua\u001a\u000b\u0017\u000e\\;sK\"1!1E\u0017A\u0002i\f\u0011\u0001\u001e\u000b\u0005\u00057\u00119\u0003C\u0004\u0003*9\u0002\rAa\u000b\u0002\u0019\u0015\u0014(o\u001c:NKN\u001c\u0018mZ3\u0011\t\t5\"Q\u0007\b\u0005\u0005_\u0011\t\u0004\u0005\u0002~\u0003&\u0019!1G!\u0002\rA\u0013X\rZ3g\u0013\u0011\u00119D!\u000f\u0003\rM#(/\u001b8h\u0015\r\u0011\u0019$Q\u0001\u000ee\u0016dW-Y:f\u0007\",hn[:\u0002\u0017=tG\u000b\u001b:po\u0006\u0014G.\u001a\u000b\u0004]\n\u0005\u0003\"B=1\u0001\u0004Q\b")
public class GatlingHttpListener
implements HttpListener {
    private final HttpTx tx;
    private final Clock clock;
    private final ResponseProcessor responseProcessor;
    private boolean init;
    private boolean done;
    private boolean storeHtmlOrCss;
    private long requestStartTimestamp;
    private long requestEndTimestamp;
    private boolean isHttp2;
    private HttpResponseStatus status;
    private HttpHeaders headers;
    private int bodyLength;
    private List<ByteBuf> chunks;

    public void onWrite(Channel x$1) {
        super.onWrite(x$1);
    }

    private boolean init() {
        return this.init;
    }

    private void init_$eq(boolean x$1) {
        this.init = x$1;
    }

    private boolean done() {
        return this.done;
    }

    private void done_$eq(boolean x$1) {
        this.done = x$1;
    }

    private boolean storeHtmlOrCss() {
        return this.storeHtmlOrCss;
    }

    private void storeHtmlOrCss_$eq(boolean x$1) {
        this.storeHtmlOrCss = x$1;
    }

    private long requestStartTimestamp() {
        return this.requestStartTimestamp;
    }

    private void requestStartTimestamp_$eq(long x$1) {
        this.requestStartTimestamp = x$1;
    }

    private long requestEndTimestamp() {
        return this.requestEndTimestamp;
    }

    private void requestEndTimestamp_$eq(long x$1) {
        this.requestEndTimestamp = x$1;
    }

    private boolean isHttp2() {
        return this.isHttp2;
    }

    private void isHttp2_$eq(boolean x$1) {
        this.isHttp2 = x$1;
    }

    private HttpResponseStatus status() {
        return this.status;
    }

    private void status_$eq(HttpResponseStatus x$1) {
        this.status = x$1;
    }

    private HttpHeaders headers() {
        return this.headers;
    }

    private void headers_$eq(HttpHeaders x$1) {
        this.headers = x$1;
    }

    private int bodyLength() {
        return this.bodyLength;
    }

    private void bodyLength_$eq(int x$1) {
        this.bodyLength = x$1;
    }

    private List<ByteBuf> chunks() {
        return this.chunks;
    }

    private void chunks_$eq(List<ByteBuf> x$1) {
        this.chunks = x$1;
    }

    public void onSend() {
        block0: {
            if (this.init()) break block0;
            this.init_$eq(true);
            this.requestStartTimestamp_$eq(this.clock.nowMillis());
        }
    }

    public void onProtocolAwareness(boolean isHttp2) {
        this.isHttp2_$eq(isHttp2);
    }

    public void onHttpResponse(HttpResponseStatus status, HttpHeaders headers) {
        block0: {
            if (this.done()) break block0;
            this.requestEndTimestamp_$eq(this.clock.nowMillis());
            this.status_$eq(status);
            this.headers_$eq(headers);
            this.storeHtmlOrCss_$eq(this.tx.request().requestConfig().httpProtocol().responsePart().inferHtmlResources() && (HttpHelper$.MODULE$.isHtml(headers) || HttpHelper$.MODULE$.isCss(headers)));
        }
    }

    public void onHttpResponseBodyChunk(ByteBuf chunk, boolean last) {
        if (!this.done()) {
            this.requestEndTimestamp_$eq(this.clock.nowMillis());
            int chunkLength = chunk.readableBytes();
            if (chunkLength > 0) {
                this.bodyLength_$eq(this.bodyLength() + chunkLength);
                if (this.tx.request().requestConfig().storeBodyParts() || this.storeHtmlOrCss()) {
                    ByteBuf byteBuf = chunk.retain();
                    this.chunks_$eq((List<ByteBuf>)this.chunks().$colon$colon((Object)byteBuf));
                }
                if (this.tx.request().requestConfig().digests().nonEmpty()) {
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])chunk.nioBuffers()), (Function1 & Serializable)nioBuffer -> {
                        GatlingHttpListener.$anonfun$onHttpResponseBodyChunk$1(this, nioBuffer);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            if (last) {
                this.done_$eq(true);
                try {
                    this.responseProcessor.onComplete(this.buildResponse());
                }
                finally {
                    this.releaseChunks();
                }
            }
        }
    }

    private HttpResult buildResponse() {
        Product product;
        if (this.status() == null) {
            product = this.buildFailure("How come we're trying to build a response with no status?!");
        } else {
            try {
                this.requestEndTimestamp_$eq(package$.MODULE$.max(this.requestEndTimestamp(), this.requestStartTimestamp()));
                Map checksums = (Map)this.tx.request().requestConfig().digests().view().mapValues((Function1 & Serializable)md -> Hex$.MODULE$.toHexString(md.digest())).to(MapFactory$.MODULE$.toFactory((MapFactory)Predef$.MODULE$.Map()));
                List chunksOrderedByArrival = this.chunks().reverse();
                ResponseBody body = ResponseBody$.MODULE$.apply(this.bodyLength(), (List<ByteBuf>)chunksOrderedByArrival, GatlingHttpListener$.MODULE$.io$gatling$http$engine$GatlingHttpListener$$resolveCharset(this.headers(), this.tx.request().requestConfig().defaultCharset()));
                product = new Response(this.tx.request().clientRequest(), this.requestStartTimestamp(), this.requestEndTimestamp(), this.status(), this.headers(), body, (Map<String, String>)checksums, this.isHttp2());
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                Throwable t = (Throwable)option.get();
                HttpFailure httpFailure = this.buildFailure(t);
                product = httpFailure;
            }
        }
        return product;
    }

    private HttpFailure buildFailure(Throwable t) {
        return this.buildFailure(Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(t)));
    }

    private HttpFailure buildFailure(String errorMessage) {
        return new HttpFailure(this.tx.request().clientRequest(), this.requestStartTimestamp(), this.requestEndTimestamp(), errorMessage);
    }

    private void releaseChunks() {
        this.chunks().foreach((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.release()));
        this.chunks_$eq((List<ByteBuf>)Nil$.MODULE$);
    }

    public void onThrowable(Throwable throwable) {
        this.requestEndTimestamp_$eq(this.clock.nowMillis());
        GatlingHttpListener$.MODULE$.io$gatling$http$engine$GatlingHttpListener$$logRequestCrash(this.tx, throwable);
        try {
            this.responseProcessor.onComplete(this.buildFailure(throwable));
        }
        finally {
            this.releaseChunks();
        }
    }

    public static final /* synthetic */ void $anonfun$onHttpResponseBodyChunk$1(GatlingHttpListener $this, ByteBuffer nioBuffer) {
        $this.tx.request().requestConfig().digests().values().foreach((Function1 & Serializable)digest -> {
            digest.update(nioBuffer.duplicate());
            return BoxedUnit.UNIT;
        });
    }

    public GatlingHttpListener(HttpTx tx, Clock clock, ResponseProcessor responseProcessor) {
        this.tx = tx;
        this.clock = clock;
        this.responseProcessor = responseProcessor;
        this.init = false;
        this.done = false;
        this.headers = EmptyHttpHeaders.INSTANCE;
        this.bodyLength = 0;
        this.chunks = Nil$.MODULE$;
    }
}

