/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.fetch;

import com.ning.http.client.Request;
import com.ning.http.client.uri.Uri;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.config.GatlingConfiguration$;
import io.gatling.core.filter.Filters;
import io.gatling.core.session.Session;
import io.gatling.core.util.cache.ThreadSafeCache;
import io.gatling.core.util.cache.ThreadSafeCache$;
import io.gatling.core.validation.Failure;
import io.gatling.core.validation.Success;
import io.gatling.core.validation.Validation;
import io.gatling.http.action.RequestAction$;
import io.gatling.http.ahc.HttpTx;
import io.gatling.http.config.HttpProtocol;
import io.gatling.http.fetch.EmbeddedResource;
import io.gatling.http.fetch.HtmlParser;
import io.gatling.http.fetch.InferredPageResources;
import io.gatling.http.fetch.ResourceFetcher;
import io.gatling.http.fetch.UserAgent$;
import io.gatling.http.fetch.package$;
import io.gatling.http.fetch.package$EmbeddedResourcesFilters$;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestConfig;
import io.gatling.http.request.HttpRequestDef;
import io.gatling.http.response.Response;
import io.gatling.http.util.HttpHelper$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ResourceFetcher$
implements StrictLogging {
    public static final ResourceFetcher$ MODULE$;
    private final ThreadSafeCache<Uri, List<EmbeddedResource>> CssContentCache;
    private final ThreadSafeCache<ResourceFetcher.InferredResourcesCacheKey, InferredPageResources> InferredResourcesCache;
    private final Logger logger;

    static {
        new ResourceFetcher$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ThreadSafeCache<Uri, List<EmbeddedResource>> CssContentCache() {
        return this.CssContentCache;
    }

    public ThreadSafeCache<ResourceFetcher.InferredResourcesCacheKey, InferredPageResources> InferredResourcesCache() {
        return this.InferredResourcesCache;
    }

    public List<EmbeddedResource> io$gatling$http$fetch$ResourceFetcher$$applyResourceFilters(List<EmbeddedResource> resources, Option<Filters> filters) {
        List<EmbeddedResource> list;
        Option<Filters> option = filters;
        if (option instanceof Some) {
            Some some = (Some)option;
            Filters f = (Filters)some.x();
            list = package$EmbeddedResourcesFilters$.MODULE$.filter$extension(package$.MODULE$.EmbeddedResourcesFilters(f), resources);
        } else {
            list = resources;
        }
        return list;
    }

    public List<HttpRequest> io$gatling$http$fetch$ResourceFetcher$$resourcesToRequests(List<EmbeddedResource> resources, Session session, HttpProtocol protocol, boolean throttled) {
        return (List)resources.flatMap((Function1)new Serializable(session, protocol, throttled){
            public static final long serialVersionUID = 0L;
            private final Session session$1;
            private final HttpProtocol protocol$1;
            private final boolean throttled$1;

            public final Iterable<HttpRequest> apply(EmbeddedResource x$1) {
                Validation<HttpRequest> validation;
                block7: {
                    Iterable iterable;
                    block6: {
                        BoxedUnit boxedUnit;
                        block5: {
                            validation = x$1.toRequest(this.session$1, this.protocol$1, this.throttled$1);
                            if (!(validation instanceof Success)) break block5;
                            Success success = (Success)validation;
                            HttpRequest httpRequest = (HttpRequest)success.value();
                            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)httpRequest));
                            break block6;
                        }
                        if (!(validation instanceof Failure)) break block7;
                        Failure failure = (Failure)validation;
                        String m = failure.message();
                        if (ResourceFetcher$.MODULE$.logger().underlying().isErrorEnabled()) {
                            ResourceFetcher$.MODULE$.logger().underlying().error(new StringBuilder().append((Object)"Could build request for embedded resource: ").append((Object)m).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return iterable;
                }
                throw new MatchError(validation);
            }
            {
                this.session$1 = session$1;
                this.protocol$1 = protocol$1;
                this.throttled$1 = throttled$1;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     */
    private List<HttpRequest> inferPageResources(Request request, Response response, Session session, HttpRequestConfig config) {
        block10: {
            htmlDocumentUri = response.request().getUri();
            protocol = config.protocol();
            var7_7 = false;
            var8_8 = null;
            var9_9 = response.statusCode();
            if (!(var9_9 instanceof Some)) ** GOTO lbl37
            var7_7 = true;
            var8_8 = (Some)var9_9;
            var10_10 = BoxesRunTime.unboxToInt((Object)var8_8.x());
            if (200 != var10_10) ** GOTO lbl37
            var12_11 = response.lastModifiedOrEtag(protocol);
            if (!(var12_11 instanceof Some)) break block10;
            var13_12 = (Some)var12_11;
            newLastModifiedOrEtag = (String)var13_12.x();
            cacheKey = new ResourceFetcher.InferredResourcesCacheKey(protocol, htmlDocumentUri);
            var17_15 = this.InferredResourcesCache().cache().get((Object)cacheKey);
            if (!(var17_15 instanceof Some) || (var19_17 = (InferredPageResources)(var18_16 = (Some)var17_15).x()) == null) ** GOTO lbl-1000
            var20_18 = var19_17.expire();
            res = var19_17.requests();
            v0 = newLastModifiedOrEtag;
            var22_20 = var20_18;
            if (!(v0 != null ? v0.equals(var22_20) == false : var22_20 != null)) {
                var23_21 = res;
            } else lbl-1000:
            // 2 sources

            {
                inferredResources = this.inferredResourcesRequests$1(request, response, session, config, htmlDocumentUri, protocol);
                this.InferredResourcesCache().cache().put((Object)cacheKey, (Object)new InferredPageResources(newLastModifiedOrEtag, inferredResources));
                var23_21 = inferredResources;
            }
            var15_23 = var23_21;
            ** GOTO lbl34
        }
        if (None$.MODULE$.equals(var12_11)) {
            var15_23 = this.inferredResourcesRequests$1(request, response, session, config, htmlDocumentUri, protocol);
lbl34:
            // 2 sources

            var11_24 = var15_23;
        } else {
            throw new MatchError(var12_11);
lbl37:
            // 2 sources

            if (var7_7 && 304 == (var25_25 = BoxesRunTime.unboxToInt((Object)var8_8.x()))) {
                var26_26 = this.InferredResourcesCache().cache().get((Object)new ResourceFetcher.InferredResourcesCacheKey(protocol, htmlDocumentUri));
                if (var26_26 instanceof Some) {
                    var27_27 = (Some)var26_26;
                    inferredPageResources = (InferredPageResources)var27_27.x();
                    var29_29 = inferredPageResources.requests();
                } else {
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got a 304 for ", " but could find cache entry?!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{htmlDocumentUri})));
                        v1 = BoxedUnit.UNIT;
                    } else {
                        v1 = BoxedUnit.UNIT;
                    }
                    var29_29 = Nil$.MODULE$;
                }
                var11_24 = var29_29;
            } else {
                var11_24 = Nil$.MODULE$;
            }
        }
        return var11_24;
    }

    private List<HttpRequest> buildExplicitResources(List<HttpRequestDef> resources, Session session) {
        return (List)resources.flatMap((Function1)new Serializable(session){
            public static final long serialVersionUID = 0L;
            private final Session session$3;

            public final Iterable<HttpRequest> apply(HttpRequestDef resource) {
                Validation validation;
                block10: {
                    Iterable iterable;
                    block9: {
                        BoxedUnit boxedUnit;
                        block5: {
                            Validation<HttpRequest> validation2;
                            block8: {
                                Iterable iterable2;
                                block7: {
                                    String requestName;
                                    block6: {
                                        validation = (Validation)resource.requestName().apply((Object)this.session$3);
                                        if (!(validation instanceof Success)) break block5;
                                        Success success = (Success)validation;
                                        requestName = (String)success.value();
                                        validation2 = resource.build(requestName, this.session$3);
                                        if (!(validation2 instanceof Success)) break block6;
                                        Success success2 = (Success)validation2;
                                        HttpRequest httpRequest = (HttpRequest)success2.value();
                                        iterable2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)httpRequest));
                                        break block7;
                                    }
                                    if (!(validation2 instanceof Failure)) break block8;
                                    Failure failure = (Failure)validation2;
                                    String m = failure.message();
                                    RequestAction$.MODULE$.reportUnbuildableRequest(requestName, this.session$3, m);
                                    iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                                }
                                iterable = iterable2;
                                break block9;
                            }
                            throw new MatchError(validation2);
                        }
                        if (!(validation instanceof Failure)) break block10;
                        Failure failure = (Failure)validation;
                        String m = failure.message();
                        if (ResourceFetcher$.MODULE$.logger().underlying().isErrorEnabled()) {
                            ResourceFetcher$.MODULE$.logger().underlying().error(new StringBuilder().append((Object)"Could build request name for explicitResource: ").append((Object)m).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return iterable;
                }
                throw new MatchError((Object)validation);
            }
            {
                this.session$3 = session$3;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    private Option<Function0<ResourceFetcher>> resourceFetcher(HttpTx tx, List<HttpRequest> inferredResources, List<HttpRequest> explicitResources) {
        List<HttpRequest> list = inferredResources;
        List list2 = explicitResources.$colon$colon$colon(list);
        Object object = Nil$.MODULE$.equals(list2) ? None$.MODULE$ : new Some((Object)new Serializable(tx, list2){
            public static final long serialVersionUID = 0L;
            private final HttpTx tx$1;
            private final List x1$1;

            public final ResourceFetcher apply() {
                return new ResourceFetcher(this.tx$1, (Seq<HttpRequest>)this.x1$1);
            }
            {
                this.tx$1 = tx$1;
                this.x1$1 = x1$1;
            }
        });
        return object;
    }

    public Option<Function0<ResourceFetcher>> resourceFetcherForCachedPage(Uri htmlDocumentURI, HttpTx tx) {
        Option option;
        block4: {
            List<HttpRequest> list;
            block3: {
                block2: {
                    option = this.InferredResourcesCache().cache().get((Object)new ResourceFetcher.InferredResourcesCacheKey(tx.request().config().protocol(), htmlDocumentURI));
                    if (!None$.MODULE$.equals(option)) break block2;
                    list = Nil$.MODULE$;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                InferredPageResources resources = (InferredPageResources)some.x();
                list = resources.requests();
            }
            List<HttpRequest> inferredResources = list;
            List<HttpRequest> explicitResources = this.buildExplicitResources(tx.request().config().explicitResources(), tx.session());
            return this.resourceFetcher(tx, inferredResources, explicitResources);
        }
        throw new MatchError((Object)option);
    }

    public Option<Function0<ResourceFetcher>> resourceFetcherForFetchedPage(Request request, Response response, HttpTx tx) {
        HttpProtocol protocol = tx.request().config().protocol();
        List<HttpRequest> explicitResources = tx.request().config().explicitResources().nonEmpty() ? this.buildExplicitResources(tx.request().config().explicitResources(), tx.session()) : Nil$.MODULE$;
        List<HttpRequest> inferredResources = protocol.responsePart().inferHtmlResources() && response.isReceived() && HttpHelper$.MODULE$.isHtml(response.headers()) ? this.inferPageResources(request, response, tx.session(), tx.request().config()) : Nil$.MODULE$;
        return this.resourceFetcher(tx, inferredResources, explicitResources);
    }

    private final List inferredResourcesRequests$1(Request request$1, Response response$1, Session session$2, HttpRequestConfig config$1, Uri htmlDocumentUri$1, HttpProtocol protocol$2) {
        List<EmbeddedResource> inferred = new HtmlParser().getEmbeddedResources(htmlDocumentUri$1, response$1.body().string(), UserAgent$.MODULE$.getAgent(request$1));
        List<EmbeddedResource> filtered = this.io$gatling$http$fetch$ResourceFetcher$$applyResourceFilters(inferred, protocol$2.responsePart().htmlResourcesInferringFilters());
        return this.io$gatling$http$fetch$ResourceFetcher$$resourcesToRequests(filtered, session$2, protocol$2, config$1.throttled());
    }

    private ResourceFetcher$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.CssContentCache = ThreadSafeCache$.MODULE$.apply(GatlingConfiguration$.MODULE$.configuration().http().fetchedCssCacheMaxCapacity());
        this.InferredResourcesCache = ThreadSafeCache$.MODULE$.apply(GatlingConfiguration$.MODULE$.configuration().http().fetchedHtmlCacheMaxCapacity());
    }
}

