/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.domain;

import io.gatling.plugin.EnterprisePlugin;
import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.domain.RunStatusTask;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.SimulationOngoingRunException;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.model.DeployedSimulationInfo;
import io.gatling.plugin.model.RunAssertion;
import io.gatling.plugin.model.RunComment;
import io.gatling.plugin.model.RunStatus;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.model.SimulationEndResult;
import io.gatling.plugin.util.ObjectsUtil;
import java.net.URL;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;

abstract class PluginClient
implements EnterprisePlugin {
    protected final EnterpriseClient enterpriseClient;
    protected final PluginLogger logger;
    protected final URL webAppUrl;

    public PluginClient(EnterpriseClient enterpriseClient, PluginLogger pluginLogger, URL uRL) {
        this.enterpriseClient = enterpriseClient;
        this.logger = pluginLogger;
        this.webAppUrl = uRL;
    }

    protected RunSummary startSimulation(DeployedSimulationInfo deployedSimulationInfo, RunComment runComment) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(deployedSimulationInfo, "deployedSimulationInfo");
        this.logger.info(String.format("Starting simulation '%s' (id='%s')", deployedSimulationInfo.name, deployedSimulationInfo.id));
        return this.enterpriseClient.startSimulation(deployedSimulationInfo.id, runComment);
    }

    @Override
    public SimulationEndResult waitForRunEnd(RunSummary runSummary) throws EnterprisePluginException {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Timer timer = new Timer();
        RunStatusTask runStatusTask = new RunStatusTask(this.enterpriseClient, this.logger, runSummary.runId, countDownLatch);
        try {
            timer.schedule((TimerTask)runStatusTask, 5000L, 5000L);
            countDownLatch.await();
        }
        catch (Exception exception) {
            throw new SimulationOngoingRunException(runSummary.runId, exception);
        }
        finally {
            timer.cancel();
        }
        if (runStatusTask.exception != null) {
            throw new SimulationOngoingRunException(runSummary.runId, runStatusTask.exception);
        }
        SimulationEndResult simulationEndResult = runStatusTask.result;
        this.logAssertionResults(simulationEndResult.assertions);
        this.logResult(runSummary, simulationEndResult.status);
        return simulationEndResult;
    }

    @Override
    public boolean abortRun(String string) throws EnterprisePluginException {
        return this.enterpriseClient.abortRun(string);
    }

    private void logAssertionResults(List<RunAssertion> list) {
        if (!list.isEmpty()) {
            this.logger.info("Assertion results:");
            for (RunAssertion runAssertion : list) {
                if (runAssertion.result) {
                    this.logger.info("> " + runAssertion.message + " succeeded with value " + runAssertion.actualValue);
                    continue;
                }
                this.logger.error("> " + runAssertion.message + " failed with value " + runAssertion.actualValue);
            }
            this.logger.info("");
        }
    }

    private void logResult(RunSummary runSummary, RunStatus runStatus) {
        if (runStatus.successful) {
            this.logger.info("Simulation result: Run " + runSummary.runId + " finished with status " + String.valueOf((Object)runStatus));
        } else {
            this.logger.error("Simulation result: Run " + runSummary.runId + " failed with status " + String.valueOf((Object)runStatus));
        }
        this.logger.info("See the run reports at " + String.valueOf(this.webAppUrl) + runSummary.reportsPath);
    }
}

