/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client;

import com.fasterxml.jackson.databind.JsonNode;
import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.client.http.api.ApiPath;
import io.gatling.plugin.client.http.api.ArtifactsApi;
import io.gatling.plugin.client.http.api.InfoApi;
import io.gatling.plugin.client.http.api.JulHttpLogging;
import io.gatling.plugin.client.http.api.PkgsApi;
import io.gatling.plugin.client.http.api.PrivateApi;
import io.gatling.plugin.client.http.api.PrivatePackagesApi;
import io.gatling.plugin.client.http.api.RunsApi;
import io.gatling.plugin.client.http.api.SimulationsApi;
import io.gatling.plugin.client.http.requests.ArtifactCreationRequest;
import io.gatling.plugin.client.http.requests.BuildPluginRequest;
import io.gatling.plugin.client.http.requests.CoordinatesRequest;
import io.gatling.plugin.client.http.requests.PkgDeployRequest;
import io.gatling.plugin.client.http.requests.PkgStorageTypeRequest;
import io.gatling.plugin.client.http.requests.SimulationDeployRequest;
import io.gatling.plugin.client.http.requests.StartOptionsRequest;
import io.gatling.plugin.client.http.responses.ArtifactIndexResponse;
import io.gatling.plugin.client.http.responses.ArtifactResponse;
import io.gatling.plugin.client.http.responses.DeployedPkgInfoResponse;
import io.gatling.plugin.client.http.responses.DeployedSimulationInfoResponse;
import io.gatling.plugin.client.http.responses.RequestsSummaryResponse;
import io.gatling.plugin.client.http.responses.RunInformationResponse;
import io.gatling.plugin.client.http.responses.RunSummaryResponse;
import io.gatling.plugin.client.http.responses.SeriesResponse;
import io.gatling.plugin.client.http.responses.SimulationResponse;
import io.gatling.plugin.client.http.responses.VersionSupportedResponse;
import io.gatling.plugin.exceptions.ApiCallIOException;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.InvalidBaseUrlException;
import io.gatling.plugin.exceptions.PackageNotFoundException;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.model.BuildPlugin;
import io.gatling.plugin.model.DeployedPkgInfo;
import io.gatling.plugin.model.DeployedSimulationInfo;
import io.gatling.plugin.model.Pkg;
import io.gatling.plugin.model.PkgFile;
import io.gatling.plugin.model.PkgIndex;
import io.gatling.plugin.model.RequestsSummary;
import io.gatling.plugin.model.RunAssertion;
import io.gatling.plugin.model.RunComment;
import io.gatling.plugin.model.RunInformation;
import io.gatling.plugin.model.RunStatus;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.model.Series;
import io.gatling.plugin.model.ServerInformation;
import io.gatling.plugin.model.Simulation;
import io.gatling.plugin.model.VersionSupported;
import io.gatling.plugin.model.Versions;
import io.gatling.plugin.util.SystemProperties;
import io.gatling.plugin.util.checksum.PkgChecksum;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class HttpEnterpriseClient
extends EnterpriseClient {
    private final InfoApi infoApiRequests;
    private final ArtifactsApi artifactsApiRequests;
    private final PrivatePackagesApi privatePackagesApiRequests;
    private final SimulationsApi simulationsApi;
    private final RunsApi runsApi;
    private final PkgsApi pkgsApi;

    public HttpEnterpriseClient(URL uRL2, String string, URL uRL3, BuildPlugin buildPlugin, PluginLogger pluginLogger) throws EnterprisePluginException {
        super(buildPlugin);
        if (!"http".equals(uRL2.getProtocol()) && !"https".equals(uRL2.getProtocol())) {
            throw new InvalidBaseUrlException(uRL2);
        }
        if (pluginLogger != null) {
            JulHttpLogging.pipeTo(pluginLogger);
        }
        URL uRL4 = ApiPath.of("api", "public").buildUrl(uRL2);
        this.infoApiRequests = new InfoApi(uRL4, string);
        this.artifactsApiRequests = new ArtifactsApi(uRL4, string);
        this.privatePackagesApiRequests = Optional.ofNullable(uRL3).map(uRL -> new PrivatePackagesApi((URL)uRL, string)).orElse(null);
        this.simulationsApi = new SimulationsApi(uRL4, string);
        this.runsApi = new RunsApi(uRL4, string);
        this.pkgsApi = new PkgsApi(uRL4, string);
        new PrivateApi(uRL4, string).checkVersionSupport(buildPlugin.buildTool.value, buildPlugin.pluginVersion);
    }

    @Override
    public ServerInformation getServerInformation() throws EnterprisePluginException {
        VersionSupportedResponse versionSupportedResponse = this.infoApiRequests.getServerInformation().versions.java;
        return new ServerInformation(new Versions(new VersionSupported(versionSupportedResponse.min, versionSupportedResponse.max)));
    }

    @Override
    public Simulation getSimulation(String string) throws EnterprisePluginException {
        SimulationResponse simulationResponse = this.simulationsApi.getSimulation(string);
        return new Simulation(simulationResponse.id, simulationResponse.name, simulationResponse.teamId, simulationResponse.className, simulationResponse.pkgId);
    }

    @Override
    public List<PkgIndex> getPackages() throws EnterprisePluginException {
        List<ArtifactIndexResponse> list = this.artifactsApiRequests.listPackages().data;
        return list.stream().map(artifactIndexResponse -> new PkgIndex(artifactIndexResponse.id, artifactIndexResponse.teamId, artifactIndexResponse.name, artifactIndexResponse.fileName)).collect(Collectors.toList());
    }

    @Override
    public Pkg getPackage(String string) throws EnterprisePluginException {
        ArtifactResponse artifactResponse = this.artifactsApiRequests.readPackage(string);
        PkgFile pkgFile = Optional.ofNullable(artifactResponse.file).map(pkgFileResponse -> new PkgFile(pkgFileResponse.filename, pkgFileResponse.version, pkgFileResponse.checksum)).orElse(null);
        return new Pkg(artifactResponse.id, artifactResponse.teamId, artifactResponse.name, pkgFile);
    }

    @Override
    public long uploadPackage(String string, File file) throws EnterprisePluginException {
        return this.privatePackagesApiRequests != null ? this.privatePackagesApiRequests.uploadPackage(string, file) : this.artifactsApiRequests.uploadPackage(string, file);
    }

    private boolean checksumComparison(String string, File file) throws EnterprisePluginException {
        try {
            Pkg pkg = this.getPackage(string);
            return pkg.file != null && PkgChecksum.computeChecksum(file).equals(pkg.file.checksum);
        }
        catch (PackageNotFoundException packageNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            throw new ApiCallIOException("Fail to compute package checksum", iOException);
        }
    }

    @Override
    public long uploadPackageWithChecksum(String string, File file) throws EnterprisePluginException {
        return this.checksumComparison(string, file) ? -1L : this.uploadPackage(string, file);
    }

    @Override
    public Pkg createPackage(String string, String string2) throws EnterprisePluginException {
        PkgStorageTypeRequest pkgStorageTypeRequest = this.privatePackagesApiRequests != null ? PkgStorageTypeRequest.PRIVATE : PkgStorageTypeRequest.PUBLIC;
        ArtifactResponse artifactResponse = this.artifactsApiRequests.createPackage(new ArtifactCreationRequest(string, string2, pkgStorageTypeRequest));
        PkgFile pkgFile = Optional.ofNullable(artifactResponse.file).map(pkgFileResponse -> new PkgFile(pkgFileResponse.filename, pkgFileResponse.version, pkgFileResponse.checksum)).orElse(null);
        return new Pkg(artifactResponse.id, artifactResponse.teamId, artifactResponse.name, pkgFile);
    }

    @Override
    public RunInformation getRunInformation(String string) throws EnterprisePluginException {
        RunInformationResponse runInformationResponse = this.runsApi.getRunInformation(string);
        List<RunAssertion> list = runInformationResponse.assertions.stream().map(runAssertionResponse -> new RunAssertion(runAssertionResponse.message, runAssertionResponse.result, runAssertionResponse.actualValue)).collect(Collectors.toList());
        return new RunInformation(runInformationResponse.runId, runInformationResponse.scenario, runInformationResponse.injectStart, RunStatus.valueOf(runInformationResponse.status), list);
    }

    @Override
    public List<Series> getConcurrentUserMetric(String string, String string2) throws EnterprisePluginException {
        List<SeriesResponse> list = this.runsApi.getConcurrentUserMetric(string, string2);
        return list.stream().map(seriesResponse -> new Series(seriesResponse.values)).collect(Collectors.toList());
    }

    private static RequestsSummary.In requestsSummaryInFromResponse(RequestsSummaryResponse.In in) {
        return new RequestsSummary.In(new RequestsSummary.KoPercent(in.counts.koPercent), new RequestsSummary.Total(in.rps.total));
    }

    private static RequestsSummary.Out requestsSummaryOutFromResponse(RequestsSummaryResponse.Out out) {
        return new RequestsSummary.Out(new RequestsSummary.Total(out.counts.total), new RequestsSummary.Total(out.rps.total));
    }

    private static RequestsSummary.Child requestsSummaryChildFromResponse(RequestsSummaryResponse.Child child) {
        return new RequestsSummary.Child(child.name, HttpEnterpriseClient.requestsSummaryInFromResponse(child.in), HttpEnterpriseClient.requestsSummaryOutFromResponse(child.out), child.index, child.children != null ? child.children.stream().map(HttpEnterpriseClient::requestsSummaryChildFromResponse).collect(Collectors.toList()) : null);
    }

    @Override
    public RequestsSummary getRequestsSummary(String string) throws EnterprisePluginException {
        RequestsSummaryResponse requestsSummaryResponse = this.runsApi.getRequestsSummary(string);
        RequestsSummary.In in = HttpEnterpriseClient.requestsSummaryInFromResponse(requestsSummaryResponse.in);
        RequestsSummary.Out out = HttpEnterpriseClient.requestsSummaryOutFromResponse(requestsSummaryResponse.out);
        List<RequestsSummary.Child> list = requestsSummaryResponse.children.stream().map(HttpEnterpriseClient::requestsSummaryChildFromResponse).collect(Collectors.toList());
        return new RequestsSummary(in, out, list);
    }

    @Override
    public boolean abortRun(String string) throws EnterprisePluginException {
        return this.simulationsApi.abortRun(string);
    }

    @Override
    public DeployedPkgInfo deployPkg(JsonNode jsonNode, String string, Boolean bl) throws EnterprisePluginException {
        DeployedPkgInfoResponse deployedPkgInfoResponse = this.pkgsApi.deployPackage((PkgDeployRequest)new PkgDeployRequest((BuildPluginRequest)new BuildPluginRequest((String)this.buildPlugin.pluginVersion, (String)this.buildPlugin.buildTool.value, (boolean)this.buildPlugin.interactive.booleanValue(), (boolean)this.buildPlugin.ci.booleanValue()), (CoordinatesRequest)new CoordinatesRequest((String)string), (Boolean)bl, (JsonNode)jsonNode)).data;
        return new DeployedPkgInfo(deployedPkgInfoResponse.id, deployedPkgInfoResponse.name);
    }

    @Override
    public List<DeployedSimulationInfo> deploySimulations(String string, JsonNode jsonNode) throws EnterprisePluginException {
        List<DeployedSimulationInfoResponse> list = this.pkgsApi.deploySimulations((String)string, (SimulationDeployRequest)new SimulationDeployRequest((BuildPluginRequest)new BuildPluginRequest((String)this.buildPlugin.pluginVersion, (String)this.buildPlugin.buildTool.value, (boolean)this.buildPlugin.interactive.booleanValue(), (boolean)this.buildPlugin.ci.booleanValue()), (JsonNode)jsonNode)).data;
        return list.stream().map(deployedSimulationInfoResponse -> new DeployedSimulationInfo(deployedSimulationInfoResponse.id, deployedSimulationInfoResponse.name)).collect(Collectors.toList());
    }

    @Override
    public RunSummary startSimulation(String string, RunComment runComment) throws EnterprisePluginException {
        Map.Entry<Object, Object> entry2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry2 : System.getProperties().entrySet()) {
            String string2 = entry2.getKey().toString();
            if (!SystemProperties.isSystemPropertyPropagated(string2)) continue;
            hashMap.put(string2, entry2.getValue().toString());
        }
        StartOptionsRequest startOptionsRequest = new StartOptionsRequest(hashMap, Map.of(), runComment.title, runComment.description);
        entry2 = this.simulationsApi.startSimulation(string, startOptionsRequest);
        return new RunSummary(((RunSummaryResponse)((Object)entry2)).runId, ((RunSummaryResponse)((Object)entry2)).className, ((RunSummaryResponse)((Object)entry2)).reportsPath);
    }
}

