/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.commons.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.GatlingVersion;
import io.gatling.commons.util.LatestGatlingRelease;
import io.gatling.commons.util.LatestGatlingRelease$OnFailureTry$;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.prefs.Preferences;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class LatestGatlingRelease$
implements StrictLogging {
    public static final LatestGatlingRelease$ MODULE$ = new LatestGatlingRelease$();
    private static final Preferences Prefs;
    private static final String LastCheckTimestampPref;
    private static final String LastCheckSuccessPref;
    private static final String LatestReleaseNumberPref;
    private static final String LatestReleaseDatePref;
    private static final String MavenCentralQuery;
    private static final int MavenCentralQueryTimeoutMillis;
    private static final Regex MavenCentralQueryVersionLatestRegex;
    private static final Regex MavenCentralQueryLastUpdatedRegex;
    private static final DateTimeFormatter MavenCentralDateTimeFormatter;
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
        Prefs = Preferences.userRoot().node("/io/gatling/latestVersion");
        LastCheckTimestampPref = "lastCheckTimestamp";
        LastCheckSuccessPref = "lastCheckSuccess";
        LatestReleaseNumberPref = "latestReleaseNumber";
        LatestReleaseDatePref = "latestReleaseDate";
        MavenCentralQuery = "https://repo1.maven.org/maven2/io/gatling/gatling-core/maven-metadata.xml";
        MavenCentralQueryTimeoutMillis = 1000;
        MavenCentralQueryVersionLatestRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("<latest>(.+?)</latest>"));
        MavenCentralQueryLastUpdatedRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("<lastUpdated>(\\d+)</lastUpdated>"));
        MavenCentralDateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss z");
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    private Preferences Prefs() {
        return Prefs;
    }

    private String LastCheckTimestampPref() {
        return LastCheckTimestampPref;
    }

    private String LastCheckSuccessPref() {
        return LastCheckSuccessPref;
    }

    private String LatestReleaseNumberPref() {
        return LatestReleaseNumberPref;
    }

    private String LatestReleaseDatePref() {
        return LatestReleaseDatePref;
    }

    private String MavenCentralQuery() {
        return MavenCentralQuery;
    }

    private int MavenCentralQueryTimeoutMillis() {
        return MavenCentralQueryTimeoutMillis;
    }

    private Regex MavenCentralQueryVersionLatestRegex() {
        return MavenCentralQueryVersionLatestRegex;
    }

    private Regex MavenCentralQueryLastUpdatedRegex() {
        return MavenCentralQueryLastUpdatedRegex;
    }

    private DateTimeFormatter MavenCentralDateTimeFormatter() {
        return MavenCentralDateTimeFormatter;
    }

    private Try<LatestGatlingRelease.FetchResult> loadPersisted() {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            long lastCheckTimestamp = MODULE$.Prefs().getLong(MODULE$.LastCheckTimestampPref(), 0L);
            if (MODULE$.Prefs().getBoolean(MODULE$.LastCheckSuccessPref(), false)) {
                return new LatestGatlingRelease.FetchResult.Success(lastCheckTimestamp, new GatlingVersion((String)Option$.MODULE$.apply((Object)MODULE$.Prefs().get(MODULE$.LatestReleaseNumberPref(), null)).getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalStateException(MODULE$.LatestReleaseNumberPref() + " is missing");
                }), (ZonedDateTime)Option$.MODULE$.apply((Object)MODULE$.Prefs().get(MODULE$.LatestReleaseDatePref(), null)).map((Function1 & Serializable)x$1 -> ZonedDateTime.parse(x$1, DateTimeFormatter.ISO_DATE_TIME)).getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalStateException(MODULE$.LatestReleaseDatePref() + " is missing");
                })));
            }
            return new LatestGatlingRelease.FetchResult.Failure(lastCheckTimestamp);
        });
    }

    private Try<BoxedUnit> persist(LatestGatlingRelease.FetchResult lastCheck) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.Prefs().putLong(MODULE$.LastCheckTimestampPref(), lastCheck.lastCheckTimestamp());
            LatestGatlingRelease.FetchResult fetchResult = lastCheck;
            if (fetchResult instanceof LatestGatlingRelease.FetchResult.Success) {
                LatestGatlingRelease.FetchResult.Success success = (LatestGatlingRelease.FetchResult.Success)fetchResult;
                GatlingVersion latestRelease = success.latestRelease();
                MODULE$.Prefs().putBoolean(MODULE$.LastCheckSuccessPref(), true);
                MODULE$.Prefs().put(MODULE$.LatestReleaseNumberPref(), latestRelease.fullVersion());
                MODULE$.Prefs().putLong(MODULE$.LastCheckSuccessPref(), latestRelease.releaseDate().toInstant().toEpochMilli());
            } else {
                MODULE$.Prefs().putBoolean(MODULE$.LastCheckSuccessPref(), false);
                MODULE$.Prefs().remove(MODULE$.LatestReleaseNumberPref());
                MODULE$.Prefs().remove(MODULE$.LastCheckSuccessPref());
            }
            MODULE$.Prefs().flush();
        });
    }

    private Try<GatlingVersion> fetchLatestReleaseFromMavenCentral() {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            GatlingVersion gatlingVersion;
            HttpURLConnection conn = (HttpURLConnection)new URI(MODULE$.MavenCentralQuery()).toURL().openConnection();
            try {
                conn.setReadTimeout(MODULE$.MavenCentralQueryTimeoutMillis());
                conn.setConnectTimeout(MODULE$.MavenCentralQueryTimeoutMillis());
                conn.setDoInput(true);
                conn.setDoOutput(false);
                conn.setUseCaches(true);
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Connection", "close");
                String response = new String(conn.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
                gatlingVersion = MODULE$.parseMavenCentralResponse(response);
            }
            finally {
                conn.disconnect();
            }
            return gatlingVersion;
        });
    }

    public GatlingVersion parseMavenCentralResponse(String response) {
        String latest = ((Regex.MatchData)this.MavenCentralQueryVersionLatestRegex().findFirstMatchIn((CharSequence)response).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Failed to find version field in " + response);
        })).group(1);
        String lastUpdated = ((Regex.MatchData)this.MavenCentralQueryLastUpdatedRegex().findFirstMatchIn((CharSequence)response).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Failed to find timestamp field in " + response);
        })).group(1);
        return new GatlingVersion(latest, ZonedDateTime.parse(lastUpdated + " Z", this.MavenCentralDateTimeFormatter()));
    }

    private final <T> Try<T> OnFailureTry(Try<T> t) {
        return t;
    }

    public Option<GatlingVersion> load() {
        Success success;
        LatestGatlingRelease.FetchResult lastCheck;
        long now = System.currentTimeMillis();
        Try<LatestGatlingRelease.FetchResult> try_ = LatestGatlingRelease$OnFailureTry$.MODULE$.logDebugOnFailure$extension(this.OnFailureTry(this.loadPersisted()), "Failed to load persisted latest release");
        if (try_ instanceof Success && (lastCheck = (LatestGatlingRelease.FetchResult)(success = (Success)try_).value()).valid(now)) {
            LatestGatlingRelease.FetchResult fetchResult = lastCheck;
            if (fetchResult instanceof LatestGatlingRelease.FetchResult.Success) {
                LatestGatlingRelease.FetchResult.Success success2 = (LatestGatlingRelease.FetchResult.Success)fetchResult;
                GatlingVersion latestRelease = success2.latestRelease();
                return new Some((Object)latestRelease);
            }
            return None$.MODULE$;
        }
        Try<GatlingVersion> maybeFetched = LatestGatlingRelease$OnFailureTry$.MODULE$.logDebugOnFailure$extension(this.OnFailureTry(this.fetchLatestReleaseFromMavenCentral()), "Failed to fetch latest release from maven central");
        LatestGatlingRelease.FetchResult fetchResult = (LatestGatlingRelease.FetchResult)maybeFetched.fold((Function1 & Serializable)x$2 -> new LatestGatlingRelease.FetchResult.Failure(now), (Function1 & Serializable)x$3 -> new LatestGatlingRelease.FetchResult.Success(now, (GatlingVersion)x$3));
        LatestGatlingRelease$OnFailureTry$.MODULE$.logDebugOnFailure$extension(this.OnFailureTry(this.persist(fetchResult)), "Failed to persist last version check");
        return maybeFetched.toOption();
    }

    private LatestGatlingRelease$() {
    }
}

