/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.report;

import io.gatling.charts.component.AssertionsTableComponent;
import io.gatling.charts.component.Component;
import io.gatling.charts.component.ComponentLibrary;
import io.gatling.charts.component.ErrorsTableComponent;
import io.gatling.charts.component.StatisticsTableComponent;
import io.gatling.charts.config.ChartsFiles;
import io.gatling.charts.report.ReportGenerator;
import io.gatling.charts.report.ReportGenerator$;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.TemplateWriter;
import io.gatling.charts.stats.CountsVsTimePlot;
import io.gatling.charts.stats.IntVsTimePlot;
import io.gatling.charts.stats.PercentVsTimePlot;
import io.gatling.charts.stats.PieSlice;
import io.gatling.charts.stats.Series;
import io.gatling.charts.stats.Series$;
import io.gatling.charts.template.GlobalPageTemplate;
import io.gatling.charts.util.Color;
import io.gatling.charts.util.Colors$;
import io.gatling.charts.util.Colors$Blue$;
import io.gatling.charts.util.Colors$Cyan$;
import io.gatling.charts.util.Colors$Green$;
import io.gatling.charts.util.Colors$LightBlue$;
import io.gatling.charts.util.Colors$LightLime$;
import io.gatling.charts.util.Colors$LightOrange$;
import io.gatling.charts.util.Colors$LightPink$;
import io.gatling.charts.util.Colors$LightPurple$;
import io.gatling.charts.util.Colors$LightRed$;
import io.gatling.charts.util.Colors$Lime$;
import io.gatling.charts.util.Colors$Pink$;
import io.gatling.charts.util.Colors$Purple$;
import io.gatling.charts.util.Colors$Red$;
import io.gatling.charts.util.Colors$Yellow$;
import io.gatling.commons.shared.unstable.model.stats.Group;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.config.GatlingConfiguration;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00013Qa\u0002\u0005\u0001\u0015AA\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006Ia\u0006\u0005\t5\u0001\u0011\t\u0011)A\u00057!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005)\u0001\t\u0005\t\u0015a\u0003*\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u0015A\u0004\u0001\"\u0001:\u0005U9En\u001c2bYJ+\u0007o\u001c:u\u000f\u0016tWM]1u_JT!!\u0003\u0006\u0002\rI,\u0007o\u001c:u\u0015\tYA\"\u0001\u0004dQ\u0006\u0014Ho\u001d\u0006\u0003\u001b9\tqaZ1uY&twMC\u0001\u0010\u0003\tIwn\u0005\u0002\u0001#A\u0011!cE\u0007\u0002\u0011%\u0011A\u0003\u0003\u0002\u0010%\u0016\u0004xN\u001d;HK:,'/\u0019;pe\u00069\"/\u001a9peR\u001cx)\u001a8fe\u0006$\u0018n\u001c8J]B,Ho]\u0002\u0001!\t\u0011\u0002$\u0003\u0002\u001a\u0011\t9\"+\u001a9peR\u001cx)\u001a8fe\u0006$\u0018n\u001c8J]B,Ho]\u0001\fG\"\f'\u000f^:GS2,7\u000f\u0005\u0002\u001d?5\tQD\u0003\u0002\u001f\u0015\u000511m\u001c8gS\u001eL!\u0001I\u000f\u0003\u0017\rC\u0017M\u001d;t\r&dWm]\u0001\u0011G>l\u0007o\u001c8f]Rd\u0015N\u0019:bef\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\u0006\u0002\u0013\r|W\u000e]8oK:$\u0018BA\u0014%\u0005A\u0019u.\u001c9p]\u0016tG\u000fT5ce\u0006\u0014\u00180A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003U9j\u0011a\u000b\u0006\u0003=1R!!\f\u0007\u0002\t\r|'/Z\u0005\u0003_-\u0012AcR1uY&twmQ8oM&<WO]1uS>t\u0017A\u0002\u001fj]&$h\b\u0006\u00033kY:DCA\u001a5!\t\u0011\u0002\u0001C\u0003)\u000b\u0001\u000f\u0011\u0006C\u0003\u0016\u000b\u0001\u0007q\u0003C\u0003\u001b\u000b\u0001\u00071\u0004C\u0003\"\u000b\u0001\u0007!%\u0001\u0005hK:,'/\u0019;f)\u0005Q\u0004CA\u001e?\u001b\u0005a$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b$\u0001B+oSR\u0004")
public class GlobalReportGenerator
extends ReportGenerator {
    private final ReportsGenerationInputs reportsGenerationInputs;
    private final ChartsFiles chartsFiles;
    private final ComponentLibrary componentLibrary;
    private final GatlingConfiguration configuration;

    @Override
    public void generate() {
        GlobalPageTemplate template = new GlobalPageTemplate((Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{this.componentLibrary.getNumberOfRequestsChartComponent(this.reportsGenerationInputs.logFileReader().requestNames().size()), this.componentLibrary.getRequestDetailsIndicatorChartComponent(), new AssertionsTableComponent(this.reportsGenerationInputs.assertionResults()), new StatisticsTableComponent(this.configuration), new ErrorsTableComponent(this.reportsGenerationInputs.logFileReader().errors((Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$)), this.activeSessionsChartComponent$1(), this.responseTimeDistributionChartComponent$1(), this.responseTimeChartComponent$1(), this.requestsChartComponent$1(), this.responsesChartComponent$1()}));
        new TemplateWriter(this.chartsFiles.globalFile()).writeToFile(template.getOutput(this.configuration.core().charset()), this.configuration);
    }

    private final Component activeSessionsChartComponent$1() {
        List baseColors = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Color[]{Colors$Blue$.MODULE$, Colors$Green$.MODULE$, Colors$Red$.MODULE$, Colors$Yellow$.MODULE$, Colors$Cyan$.MODULE$, Colors$Lime$.MODULE$, Colors$Purple$.MODULE$, Colors$Pink$.MODULE$, Colors$LightBlue$.MODULE$, Colors$LightOrange$.MODULE$, Colors$LightRed$.MODULE$, Colors$LightLime$.MODULE$, Colors$LightPurple$.MODULE$, Colors$LightPink$.MODULE$}));
        List seriesColors = package$.MODULE$.Iterator().continually((Function0 & Serializable)() -> baseColors).flatten(Predef$.MODULE$.$conforms()).take(this.reportsGenerationInputs.logFileReader().scenarioNames().size()).toList();
        List activeSessionsSeries = ((List)this.reportsGenerationInputs.logFileReader().scenarioNames().map((Function1 & Serializable)scenarioName -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(scenarioName), $this.reportsGenerationInputs.logFileReader().numberOfActiveSessionsPerSecond((Option<String>)new Some(scenarioName)))).reverse().zip((IterableOnce)seriesColors)).map((Function1 & Serializable)x0$1 -> {
            Color color;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    color = (Color)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String scenarioName = (String)tuple2._1();
            Seq data = (Seq)tuple2._2();
            Series series = new Series(scenarioName, data, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Colors$.MODULE$.color2String(color)}))));
            return series;
        });
        return this.componentLibrary.getActiveSessionsChartComponent(this.reportsGenerationInputs.logFileReader().runStart(), (Seq<Series<IntVsTimePlot>>)activeSessionsSeries);
    }

    private final Component responseTimeDistributionChartComponent$1() {
        Tuple2<Seq<PercentVsTimePlot>, Seq<PercentVsTimePlot>> tuple2 = this.reportsGenerationInputs.logFileReader().responseTimeDistribution(100, (Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq okDistribution = (Seq)tuple2._1();
        Seq koDistribution = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)okDistribution, (Object)koDistribution);
        Tuple2 tuple23 = tuple22;
        Seq okDistribution2 = (Seq)tuple23._1();
        Seq koDistribution2 = (Seq)tuple23._2();
        Series<PercentVsTimePlot> okDistributionSeries = new Series<PercentVsTimePlot>(Series$.MODULE$.OK(), (Iterable<PercentVsTimePlot>)okDistribution2, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Colors$.MODULE$.color2String(Colors$Blue$.MODULE$)}))));
        Series<PercentVsTimePlot> koDistributionSeries = new Series<PercentVsTimePlot>(Series$.MODULE$.KO(), (Iterable<PercentVsTimePlot>)koDistribution2, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Colors$.MODULE$.color2String(Colors$Red$.MODULE$)}))));
        return this.componentLibrary.getRequestDetailsResponseTimeDistributionChartComponent(okDistributionSeries, koDistributionSeries);
    }

    private final Component responseTimeChartComponent$1() {
        return this.percentilesChartComponent$1((Function3 & Serializable)(status, requestName, group) -> $this.reportsGenerationInputs.logFileReader().responseTimePercentilesOverTime((Status)status, (Option<String>)requestName, (Option<Group>)group), (Function2 & Serializable)(runStart, responseTimesSuccess) -> this.componentLibrary.getRequestDetailsResponseTimeChartComponent(BoxesRunTime.unboxToLong((Object)runStart), responseTimesSuccess), "Response Time Percentiles over Time");
    }

    private final Component percentilesChartComponent$1(Function3 dataSource, Function2 componentFactory, String title) {
        Iterable successData = (Iterable)dataSource.apply((Object)OK$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
        Series successSeries = new Series(new StringBuilder(3).append(title).append(" (").append(Series$.MODULE$.OK()).append(")").toString(), successData, ReportGenerator$.MODULE$.PercentilesColors());
        return (Component)componentFactory.apply((Object)BoxesRunTime.boxToLong((long)this.reportsGenerationInputs.logFileReader().runStart()), successSeries);
    }

    private final Component requestsChartComponent$1() {
        return this.countsChartComponent$1((Function2 & Serializable)(requestName, group) -> $this.reportsGenerationInputs.logFileReader().numberOfRequestsPerSecond((Option<String>)requestName, (Option<Group>)group), (Function3 & Serializable)(runStart, counts, pieSeries) -> this.componentLibrary.getRequestsChartComponent(BoxesRunTime.unboxToLong((Object)runStart), counts, pieSeries));
    }

    private final Component responsesChartComponent$1() {
        return this.countsChartComponent$1((Function2 & Serializable)(requestName, group) -> $this.reportsGenerationInputs.logFileReader().numberOfResponsesPerSecond((Option<String>)requestName, (Option<Group>)group), (Function3 & Serializable)(runStart, counts, pieSeries) -> this.componentLibrary.getResponsesChartComponent(BoxesRunTime.unboxToLong((Object)runStart), counts, pieSeries));
    }

    private final Component countsChartComponent$1(Function2 dataSource, Function3 componentFactory) {
        Seq counts = (Seq)((SeqOps)dataSource.apply((Object)None$.MODULE$, (Object)None$.MODULE$)).sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.time()), (Ordering)Ordering.Int$.MODULE$);
        Series countsSeries = new Series("", counts, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Colors$.MODULE$.color2String(Colors$Blue$.MODULE$), Colors$.MODULE$.color2String(Colors$Red$.MODULE$), Colors$.MODULE$.color2String(Colors$Green$.MODULE$)}))));
        PieSlice okPieSlice = new PieSlice(Series$.MODULE$.OK(), this.count((Seq<CountsVsTimePlot>)counts, (Status)OK$.MODULE$));
        PieSlice koPieSlice = new PieSlice(Series$.MODULE$.KO(), this.count((Seq<CountsVsTimePlot>)counts, (Status)KO$.MODULE$));
        Series pieRequestsSeries = new Series(Series$.MODULE$.Distribution(), (Iterable)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PieSlice[]{okPieSlice, koPieSlice})), (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Colors$.MODULE$.color2String(Colors$Green$.MODULE$), Colors$.MODULE$.color2String(Colors$Red$.MODULE$)}))));
        return (Component)componentFactory.apply((Object)BoxesRunTime.boxToLong((long)this.reportsGenerationInputs.logFileReader().runStart()), countsSeries, pieRequestsSeries);
    }

    public GlobalReportGenerator(ReportsGenerationInputs reportsGenerationInputs, ChartsFiles chartsFiles, ComponentLibrary componentLibrary, GatlingConfiguration configuration) {
        this.reportsGenerationInputs = reportsGenerationInputs;
        this.chartsFiles = chartsFiles;
        this.componentLibrary = componentLibrary;
        this.configuration = configuration;
    }
}

