/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import io.gatling.app.RunResult;
import io.gatling.app.cli.StatusCode;
import io.gatling.app.cli.StatusCode$AssertionsFailed$;
import io.gatling.app.cli.StatusCode$Success$;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.ReportsGenerator;
import io.gatling.charts.stats.LogFileData;
import io.gatling.charts.stats.LogFileReader$;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.shared.model.assertion.AssertionMessage$;
import io.gatling.shared.model.assertion.AssertionResult;
import io.gatling.shared.model.assertion.AssertionStatsRepository;
import io.gatling.shared.model.assertion.AssertionValidator;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005E4A\u0001C\u0005\u0007!!Aq\u0003\u0001B\u0001B\u0003%\u0001\u0004C\u0003!\u0001\u0011\u0005\u0011\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u00033\u0001\u0011%1\u0007C\u0003A\u0001\u0011%\u0011\tC\u0003F\u0001\u0011%a\tC\u0003o\u0001\u0011%qN\u0001\nSk:\u0014Vm];miB\u0013xnY3tg>\u0014(B\u0001\u0006\f\u0003\r\t\u0007\u000f\u001d\u0006\u0003\u00195\tqaZ1uY&twMC\u0001\u000f\u0003\tIwn\u0001\u0001\u0014\u0005\u0001\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g-A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u00033yi\u0011A\u0007\u0006\u00037q\taaY8oM&<'BA\u000f\f\u0003\u0011\u0019wN]3\n\u0005}Q\"\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003E\u0011\u0002\"a\t\u0001\u000e\u0003%AQa\u0006\u0002A\u0002a\t\u0001\u0003\u001d:pG\u0016\u001c8OU;o%\u0016\u001cX\u000f\u001c;\u0015\u0005\u001dj\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\n\u0003\r\u0019G.[\u0005\u0003Y%\u0012!b\u0015;biV\u001c8i\u001c3f\u0011\u0015q3\u00011\u00010\u0003%\u0011XO\u001c*fgVdG\u000f\u0005\u0002$a%\u0011\u0011'\u0003\u0002\n%Vt'+Z:vYR\fq\"\u001b8ji2{wMR5mK\u0012\u000bG/\u0019\u000b\u0003i}\u00022AE\u001b8\u0013\t14C\u0001\u0004PaRLwN\u001c\t\u0003quj\u0011!\u000f\u0006\u0003um\nQa\u001d;biNT!\u0001P\u0006\u0002\r\rD\u0017M\u001d;t\u0013\tq\u0014HA\u0006M_\u001e4\u0015\u000e\\3ECR\f\u0007\"\u0002\u0018\u0005\u0001\u0004y\u0013\u0001\u0007:fa>\u0014Ho]$f]\u0016\u0014\u0018\r^5p]\u0016s\u0017M\u00197fIV\t!\t\u0005\u0002\u0013\u0007&\u0011Ai\u0005\u0002\b\u0005>|G.Z1o\u0003=9WM\\3sCR,'+\u001a9peR\u001cH\u0003B$K/f\u0003\"A\u0005%\n\u0005%\u001b\"\u0001B+oSRDQa\u0013\u0004A\u00021\u000bQA];o\u0013\u0012\u0004\"!\u0014+\u000f\u00059\u0013\u0006CA(\u0014\u001b\u0005\u0001&BA)\u0010\u0003\u0019a$o\\8u}%\u00111kE\u0001\u0007!J,G-\u001a4\n\u0005U3&AB*ue&twM\u0003\u0002T'!)\u0001L\u0002a\u0001o\u0005YAn\\4GS2,G)\u0019;b\u0011\u0015Qf\u00011\u0001\\\u0003A\t7o]3si&|gNU3tk2$8\u000fE\u0002]C\u0012t!!X0\u000f\u0005=s\u0016\"\u0001\u000b\n\u0005\u0001\u001c\u0012a\u00029bG.\fw-Z\u0005\u0003E\u000e\u0014A\u0001T5ti*\u0011\u0001m\u0005\t\u0003K2l\u0011A\u001a\u0006\u0003O\"\f\u0011\"Y:tKJ$\u0018n\u001c8\u000b\u0005%T\u0017!B7pI\u0016d'BA6\f\u0003\u0019\u0019\b.\u0019:fI&\u0011QN\u001a\u0002\u0010\u0003N\u001cXM\u001d;j_:\u0014Vm];mi\u0006I!/\u001e8Ti\u0006$Xo\u001d\u000b\u0003OADQAW\u0004A\u0002m\u0003")
public final class RunResultProcessor {
    private final GatlingConfiguration configuration;

    public StatusCode processRunResult(RunResult runResult) {
        Option<LogFileData> option = this.initLogFileData(runResult);
        if (option instanceof Some) {
            Some some = (Some)option;
            LogFileData logFileData = (LogFileData)some.value();
            List assertionResults = new AssertionValidator((AssertionStatsRepository)logFileData).validateAssertions(logFileData.assertions());
            this.generateReports(runResult.runId(), logFileData, (List<AssertionResult>)assertionResults);
            return this.runStatus((List<AssertionResult>)assertionResults);
        }
        return StatusCode$Success$.MODULE$;
    }

    private Option<LogFileData> initLogFileData(RunResult runResult) {
        if (this.reportsGenerationEnabled() || runResult.hasAssertions()) {
            long start = System.currentTimeMillis();
            Predef$.MODULE$.println((Object)"Parsing log file(s)...");
            LogFileData logFileData = LogFileReader$.MODULE$.apply(runResult.runId(), this.configuration).read();
            Predef$.MODULE$.println((Object)("Parsing log file(s) done in " + (System.currentTimeMillis() - start) / 1000L + "s."));
            return new Some((Object)logFileData);
        }
        return None$.MODULE$;
    }

    private boolean reportsGenerationEnabled() {
        return this.configuration.core().directory().reportsOnly().isDefined() || this.configuration.data().fileDataWriterEnabled() && !this.configuration.reports().noReports();
    }

    private void generateReports(String runId, LogFileData logFileData, List<AssertionResult> assertionResults) {
        if (this.reportsGenerationEnabled()) {
            Predef$.MODULE$.println((Object)"Generating reports...");
            ReportsGenerationInputs reportsGenerationInputs = new ReportsGenerationInputs(runId, logFileData, assertionResults);
            Path indexFile = new ReportsGenerator(this.configuration.data().zoneId(), this.configuration.core().charset(), this.configuration.core().directory(), this.configuration.reports()).generateFor(reportsGenerationInputs);
            Predef$.MODULE$.println((Object)("Reports generated, please open the following file: " + indexFile.toUri()));
            return;
        }
    }

    private StatusCode runStatus(List<AssertionResult> assertionResults) {
        boolean consolidatedAssertionResult = BoxesRunTime.unboxToBoolean((Object)assertionResults.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable)(isValid, assertionResult) -> BoxesRunTime.boxToBoolean((boolean)RunResultProcessor.$anonfun$runStatus$1(BoxesRunTime.unboxToBoolean((Object)isValid), assertionResult))));
        if (consolidatedAssertionResult) {
            return StatusCode$Success$.MODULE$;
        }
        return StatusCode$AssertionsFailed$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$runStatus$1(boolean isValid, AssertionResult assertionResult) {
        String message = AssertionMessage$.MODULE$.message(assertionResult.assertion());
        AssertionResult assertionResult2 = assertionResult;
        if (assertionResult2 instanceof AssertionResult.Resolved) {
            AssertionResult.Resolved resolved = (AssertionResult.Resolved)assertionResult2;
            boolean success = resolved.success();
            double actualValue = resolved.actualValue();
            Predef$.MODULE$.println((Object)(message + " : " + success + " (actual : " + actualValue + ")"));
        } else if (assertionResult2 instanceof AssertionResult.ResolutionError) {
            AssertionResult.ResolutionError resolutionError = (AssertionResult.ResolutionError)assertionResult2;
            String error = resolutionError.error();
            Predef$.MODULE$.println((Object)(message + " : false (" + error + ")"));
        } else {
            throw new MatchError((Object)assertionResult2);
        }
        return isValid && assertionResult.success();
    }

    public RunResultProcessor(GatlingConfiguration configuration) {
        this.configuration = configuration;
    }
}

