/*
 * Decompiled with CFR 0.152.
 */
package lombok.launch;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.launch.Main;

public class LombokApi {
    private final Class<?> configurationApp;
    private final Method runApp;
    private final Method redirectOutput;

    public LombokApi() {
        ClassLoader shadowClassLoader = Main.getShadowClassLoader();
        this.configurationApp = shadowClassLoader.loadClass("lombok.core.configuration.ConfigurationApp");
        this.runApp = this.configurationApp.getMethod("runApp", List.class);
        this.redirectOutput = this.configurationApp.getMethod("redirectOutput", PrintStream.class, PrintStream.class);
    }

    public void config(OutputStream outputStream, File ... paths) {
        List<String> args = Arrays.stream(paths).map(File::getAbsolutePath).collect(Collectors.toList());
        this.config(outputStream, args);
    }

    public void config(OutputStream outputStream, List<String> args) {
        Object configApp = this.configurationApp.getConstructor(new Class[0]).newInstance(new Object[0]);
        this.redirectOutput.invoke(configApp, new PrintStream(outputStream, true), System.err);
        this.runApp.invoke(configApp, args);
    }
}

