/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.performance;

import com.gargoylesoftware.htmlunit.javascript.host.performance.PerformanceTiming;
import io.fluentlenium.core.performance.PerformanceTimingMetrics;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class HtmlUnitPerformanceTimingMetrics
implements PerformanceTimingMetrics<HtmlUnitPerformanceTimingMetrics> {
    private final PerformanceTiming timing;
    private final TimeUnit targetTimeUnit;
    private final long navigationStart;

    public HtmlUnitPerformanceTimingMetrics(PerformanceTiming timing) {
        this(timing, TimeUnit.MILLISECONDS);
    }

    public HtmlUnitPerformanceTimingMetrics(PerformanceTiming timing, TimeUnit timeUnit) {
        this.timing = timing;
        this.targetTimeUnit = timeUnit;
        this.navigationStart = this.targetTimeUnit.convert(timing.getNavigationStart(), TimeUnit.MILLISECONDS);
    }

    @Override
    public HtmlUnitPerformanceTimingMetrics in(TimeUnit targetTimeUnit) {
        return new HtmlUnitPerformanceTimingMetrics(this.timing, targetTimeUnit);
    }

    @Override
    public long getUnloadEventStart() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getUnloadEventStart());
    }

    @Override
    public long getUnloadEventEnd() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getUnloadEventEnd());
    }

    @Override
    public long getRedirectStart() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getRedirectStart());
    }

    @Override
    public long getRedirectEnd() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getRedirectEnd());
    }

    @Override
    public long getNavigationStart() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getNavigationStart());
    }

    @Override
    public long getFetchStart() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getFetchStart());
    }

    @Override
    public long getDomainLookupStart() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getDomainLookupStart());
    }

    @Override
    public long getDomainLookupEnd() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getDomainLookupEnd());
    }

    @Override
    public long getConnectStart() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getConnectStart());
    }

    @Override
    public long getConnectEnd() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getConnectEnd());
    }

    @Override
    public Object getSecureConnectionStart() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getSecureConnectionStart());
    }

    @Override
    public long getRequestStart() {
        throw new UnsupportedOperationException("This performance timing attribute is not implemented in HtmlUnit.");
    }

    @Override
    public long getResponseStart() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getResponseStart());
    }

    @Override
    public long getResponseEnd() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getResponseEnd());
    }

    @Override
    public long getDomLoading() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getDomLoading());
    }

    @Override
    public long getDomInteractive() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getDomInteractive());
    }

    @Override
    public long getDomContentLoadedEventStart() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getDomContentLoadedEventStart());
    }

    @Override
    public long getDomContentLoadedEventEnd() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getDomContentLoadedEventEnd());
    }

    @Override
    public long getDomComplete() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getDomComplete());
    }

    @Override
    public long getLoadEventStart() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getLoadEventStart());
    }

    @Override
    public long getLoadEventEnd() {
        return this.getEventValue(() -> ((PerformanceTiming)this.timing).getLoadEventEnd());
    }

    private long getEventValue(Supplier<Long> eventValueSupplier) {
        return this.targetTimeUnit.convert(eventValueSupplier.get(), TimeUnit.MILLISECONDS) - this.navigationStart;
    }
}

