/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.inject;

import io.appium.java_client.pagefactory.DefaultElementByBuilder;
import io.fluentlenium.configuration.ConfigurationException;
import io.fluentlenium.core.inject.LabelAnnotations;
import io.fluentlenium.core.inject.SupportedAppiumAnnotations;
import io.fluentlenium.core.label.FluentLabelProvider;
import io.fluentlenium.core.page.ClassAnnotations;
import io.fluentlenium.utils.CollectionUtils;
import io.fluentlenium.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.support.ByIdOrName;
import org.openqa.selenium.support.pagefactory.AbstractAnnotations;
import org.openqa.selenium.support.pagefactory.Annotations;

public class InjectionAnnotations
extends AbstractAnnotations
implements FluentLabelProvider {
    private final ClassAnnotations classAnnotations;
    private final Annotations fieldAnnotations;
    private final LabelAnnotations labelFieldAnnotations;
    private final DefaultElementByBuilder defaultElementByBuilder;
    private final boolean mobileElement;

    public InjectionAnnotations(Field field, Capabilities capabilities) {
        this.classAnnotations = new ClassAnnotations(InjectionAnnotations.getEffectiveClass(field));
        this.fieldAnnotations = new Annotations(field);
        this.labelFieldAnnotations = new LabelAnnotations(field);
        String platform = this.getPlatform(capabilities);
        String automation = this.getAutomation(capabilities);
        this.defaultElementByBuilder = new DefaultElementByBuilder(platform, automation);
        if (this.isAnnotatedWithSupportedMobileBy(field)) {
            this.checkCapabilities(platform, automation);
            this.defaultElementByBuilder.setAnnotated((AnnotatedElement)field);
            this.mobileElement = true;
        } else {
            this.mobileElement = false;
        }
    }

    private void checkCapabilities(String platform, String automation) {
        boolean correctConfiguration;
        boolean bl = correctConfiguration = this.isAndroid(platform) || this.isIos(platform, automation) || this.isWindows(platform);
        if (!correctConfiguration) {
            throw new ConfigurationException("You have annotated elements with Appium @FindBys but capabilities are incomplete. Please use one of these configurations:\nplatformName:Windows\nplaformName:Android\nplaformName:iOS, automationName:XCUITest");
        }
    }

    private boolean isWindows(String platform) {
        return "Windows".equalsIgnoreCase(platform);
    }

    private boolean isIos(String platform, String automation) {
        return "iOS".equalsIgnoreCase(platform) && "XCuiTest".equalsIgnoreCase(automation);
    }

    private boolean isAndroid(String platform) {
        return "Android".equalsIgnoreCase(platform);
    }

    private String getAutomation(Capabilities capabilities) {
        return Optional.ofNullable(capabilities).map(capability -> capability.getCapability("automationName")).map(String::valueOf).orElse(null);
    }

    private String getPlatform(Capabilities capabilities) {
        if (capabilities == null) {
            return null;
        }
        Object platformName = Optional.ofNullable(capabilities.getCapability("platformName")).orElseGet(() -> capabilities.getCapability("platform"));
        return Optional.ofNullable(platformName).map(String::valueOf).orElse(null);
    }

    private boolean isAnnotatedWithSupportedMobileBy(Field field) {
        Annotation[] annotations = field.getAnnotations();
        return Arrays.stream(annotations).anyMatch(SupportedAppiumAnnotations::isSupported);
    }

    public By buildBy() {
        if (this.mobileElement) {
            return this.defaultElementByBuilder.buildBy();
        }
        By fieldBy = this.fieldAnnotations.buildBy();
        By classBy = this.classAnnotations.buildBy();
        if (classBy != null && fieldBy instanceof ByIdOrName) {
            return classBy;
        }
        return fieldBy;
    }

    public boolean isLookupCached() {
        return this.classAnnotations.isLookupCached() || this.fieldAnnotations.isLookupCached();
    }

    @Override
    public String getLabel() {
        return this.labelFieldAnnotations.getLabel();
    }

    @Override
    public String[] getLabelHints() {
        return this.labelFieldAnnotations.getLabelHints();
    }

    private static Class<?> getEffectiveClass(Field field) {
        Class<?> effectiveClass;
        if (CollectionUtils.isList(field) && (effectiveClass = ReflectionUtils.getFirstGenericType(field)) != null) {
            return effectiveClass;
        }
        return field.getType();
    }
}

