/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.conditions;

import io.fluentlenium.core.conditions.AbstractObjectConditions;
import io.fluentlenium.core.conditions.ListIntegerConditions;
import io.fluentlenium.core.conditions.Negation;
import io.fluentlenium.core.domain.FluentList;
import io.fluentlenium.core.domain.FluentWebElement;
import java.util.List;
import java.util.function.Supplier;

public class DynamicIntegerConditionsImpl
extends AbstractObjectConditions<List<? extends FluentWebElement>>
implements ListIntegerConditions {
    public DynamicIntegerConditionsImpl(Supplier<List<? extends FluentWebElement>> supplier, boolean negation) {
        super(supplier.get(), negation);
    }

    @Override
    protected AbstractObjectConditions<List<? extends FluentWebElement>> newInstance(boolean negationValue) {
        return new DynamicIntegerConditionsImpl(() -> (List)this.object, negationValue);
    }

    @Override
    @Negation
    public DynamicIntegerConditionsImpl not() {
        return (DynamicIntegerConditionsImpl)super.not();
    }

    @Override
    public boolean equalTo(int value) {
        return this.verify(input -> this.getListSize(input) == value);
    }

    @Override
    public boolean lessThan(int value) {
        return this.verify(input -> this.getListSize(input) < value);
    }

    @Override
    public boolean lessThanOrEqualTo(int value) {
        return this.verify(input -> this.getListSize(input) <= value);
    }

    @Override
    public boolean greaterThan(int value) {
        return this.verify(input -> this.getListSize(input) > value);
    }

    @Override
    public boolean greaterThanOrEqualTo(int value) {
        return this.verify(input -> this.getListSize(input) >= value);
    }

    private <T extends List> int getListSize(T input) {
        if (input instanceof FluentList) {
            return ((FluentList)input).count();
        }
        return input.size();
    }
}

