/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.action;

import io.fluentlenium.core.domain.FluentWebElement;
import io.fluentlenium.core.proxy.LocatorProxies;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class MouseElementActions {
    private final WebDriver driver;
    private final WebElement element;
    private Actions actions;

    public MouseElementActions(WebDriver driver, WebElement element) {
        this.driver = driver;
        this.element = element;
    }

    public MouseElementActions(WebDriver driver, WebElement element, Actions actions) {
        this.driver = driver;
        this.element = element;
        this.actions = actions;
    }

    public MouseElementActions(WebDriver driver, FluentWebElement fluentWebElement) {
        this(driver, fluentWebElement.getElement());
    }

    public MouseElementActions(WebDriver driver, FluentWebElement fluentWebElement, Actions actions) {
        this(driver, fluentWebElement.getElement(), actions);
    }

    protected Actions actions() {
        if (this.actions == null) {
            this.actions = new Actions(this.driver);
        }
        return this.actions;
    }

    public MouseElementActions clickAndHold() {
        this.loadElementAndPerform(this.actions().clickAndHold(this.element));
        return this;
    }

    public MouseElementActions release() {
        this.loadElementAndPerform(this.actions().release(this.element));
        return this;
    }

    public MouseElementActions click() {
        this.loadElementAndPerform(this.actions().click(this.element));
        return this;
    }

    public MouseElementActions doubleClick() {
        this.loadElementAndPerform(this.actions().doubleClick(this.element));
        return this;
    }

    public MouseElementActions moveToElement() {
        this.loadElementAndPerform(this.actions().moveToElement(this.element));
        return this;
    }

    public MouseElementActions moveToElement(WebElement target) {
        this.loadElementAndPerform(this.actions().moveToElement(target));
        return this;
    }

    public MouseElementActions moveToElement(int xOffset, int yOffset) {
        this.loadElementAndPerform(this.actions().moveToElement(this.element, xOffset, yOffset));
        return this;
    }

    public MouseElementActions moveToElement(WebElement target, int xOffset, int yOffset) {
        this.loadElementAndPerform(this.actions().moveToElement(target, xOffset, yOffset));
        return this;
    }

    public MouseElementActions contextClick() {
        this.loadElementAndPerform(this.actions().contextClick(this.element));
        return this;
    }

    public MouseElementActions dragAndDropFrom(WebElement source) {
        this.loadElementAndPerform(this.actions().dragAndDrop(source, this.element));
        return this;
    }

    public MouseElementActions dragAndDropTo(WebElement target) {
        this.loadElementAndPerform(this.actions().dragAndDrop(this.element, target));
        return this;
    }

    public MouseElementActions dragAndDropBy(int xOffset, int yOffset) {
        this.loadElementAndPerform(this.actions().dragAndDropBy(this.element, xOffset, yOffset));
        return this;
    }

    public MouseElementActions dragAndDropByWithTargetOffset(WebElement target, int xOffset, int yOffset) {
        this.loadElementAndPerform(this.actions().clickAndHold(this.element).moveToElement(target, xOffset, yOffset).release());
        return this;
    }

    private void loadElementAndPerform(Actions action) {
        this.loadElement();
        action.perform();
    }

    private void loadElement() {
        LocatorProxies.now(this.element);
    }
}

