/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.configuration;

import io.fluentlenium.configuration.CapabilitiesFactory;
import io.fluentlenium.configuration.ConfigurationException;
import io.fluentlenium.configuration.ConfigurationProperties;
import io.fluentlenium.configuration.FactoryNames;
import io.fluentlenium.configuration.IndexIgnore;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openqa.selenium.Capabilities;

@IndexIgnore
public class MethodInvocationReflectionFactory
implements CapabilitiesFactory,
FactoryNames {
    private final Method method;
    private final Object instance;
    private final Object[] args;

    public MethodInvocationReflectionFactory(Method method, Object instance, Object ... args) {
        this.method = method;
        this.instance = instance;
        this.args = args;
    }

    @Override
    public Capabilities newCapabilities(ConfigurationProperties configuration) {
        try {
            return (Capabilities)this.method.invoke(this.instance, this.args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ConfigurationException("Can't create capabilities instance", e);
        }
    }

    @Override
    public String[] getNames() {
        return new String[]{this.method.getDeclaringClass().getName() + "." + this.method.getName(), this.method.getDeclaringClass().getSimpleName() + "." + this.method.getName(), this.method.getName()};
    }
}

