/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.adapter.sharedwebdriver;

import io.fluentlenium.adapter.sharedwebdriver.FluentLeniumDriver;
import io.fluentlenium.adapter.sharedwebdriver.SharedWebDriver;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MethodDriver
implements FluentLeniumDriver {
    private final Map<ClassAndTestName, SharedWebDriver> methodDrivers = new HashMap<ClassAndTestName, SharedWebDriver>();

    Map<ClassAndTestName, SharedWebDriver> getMethodDrivers() {
        return this.methodDrivers;
    }

    @Override
    public void quitDriver(SharedWebDriver sharedWebDriver) {
        SharedWebDriver testDriver = this.methodDrivers.remove(new ClassAndTestName(sharedWebDriver.getTestClass(), sharedWebDriver.getTestName()));
        this.quitDriver(sharedWebDriver, testDriver);
    }

    @Override
    public void addDriver(SharedWebDriver driver) {
        this.methodDrivers.put(new ClassAndTestName(driver.getTestClass(), driver.getTestName()), driver);
    }

    public <T> SharedWebDriver getDriver(Class<T> testClass, String testName) {
        return this.methodDrivers.get(new ClassAndTestName(testClass, testName));
    }

    private class ClassAndTestName {
        private final Class<?> testClass;
        private final String testName;

        ClassAndTestName(Class<?> testClass, String testName) {
            this.testClass = testClass;
            this.testName = testName;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ClassAndTestName)) {
                return false;
            }
            ClassAndTestName other = (ClassAndTestName)obj;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Objects.equals(this.testClass, other.testClass)) {
                return false;
            }
            return Objects.equals(this.testName, other.testName);
        }

        boolean canEqual(Object other) {
            return other instanceof ClassAndTestName;
        }

        public int hashCode() {
            int prime = 59;
            int result = 1;
            Class<?> testClazz = this.testClass;
            result = result * 59 + (testClazz == null ? 43 : testClazz.hashCode());
            String nameOfTest = this.testName;
            result = result * 59 + (nameOfTest == null ? 43 : nameOfTest.hashCode());
            return result;
        }
    }
}

