/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.adapter;

import io.fluentlenium.adapter.DefaultFluentControlContainer;
import io.fluentlenium.adapter.DefaultSharedMutator;
import io.fluentlenium.adapter.FluentAdapter;
import io.fluentlenium.adapter.FluentControlContainer;
import io.fluentlenium.adapter.SharedMutator;
import io.fluentlenium.adapter.TestRunnerAdapter;
import io.fluentlenium.adapter.TestRunnerCommon;
import io.fluentlenium.adapter.sharedwebdriver.SharedWebDriver;
import io.fluentlenium.adapter.sharedwebdriver.SharedWebDriverContainer;
import io.fluentlenium.configuration.ConfigurationProperties;
import io.fluentlenium.utils.AnnotationUtil;
import io.fluentlenium.utils.ScreenshotUtil;
import io.fluentlenium.utils.ThreadLocalAdapterUtil;
import java.lang.annotation.Annotation;
import java.util.List;

public class FluentTestRunnerAdapter
extends FluentAdapter
implements TestRunnerAdapter {
    private final SharedMutator sharedMutator;
    private static final ThreadLocal<SharedMutator.EffectiveParameters<?>> PARAMETERS_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<String> TEST_METHOD_NAME = new ThreadLocal();
    private static final ThreadLocal<Class<?>> TEST_CLASS = new ThreadLocal();

    public FluentTestRunnerAdapter() {
        this(new DefaultFluentControlContainer());
    }

    public FluentTestRunnerAdapter(FluentControlContainer driverContainer) {
        this(driverContainer, new DefaultSharedMutator());
    }

    public FluentTestRunnerAdapter(SharedMutator sharedMutator) {
        this((FluentControlContainer)new DefaultFluentControlContainer(), sharedMutator);
    }

    public FluentTestRunnerAdapter(FluentControlContainer driverContainer, SharedMutator sharedMutator) {
        super(driverContainer);
        this.sharedMutator = sharedMutator;
    }

    public FluentTestRunnerAdapter(FluentControlContainer driverContainer, Class<?> clazz, SharedMutator sharedMutator) {
        super(driverContainer, clazz);
        this.sharedMutator = sharedMutator;
    }

    @Override
    public Class<?> getTestClass() {
        return ThreadLocalAdapterUtil.getClassFromThread(TEST_CLASS);
    }

    @Override
    public String getTestMethodName() {
        return ThreadLocalAdapterUtil.getMethodNameFromThread(TEST_METHOD_NAME);
    }

    @Override
    public <T extends Annotation> T getClassAnnotation(Class<T> annotation) {
        return AnnotationUtil.getClassAnnotationForClass(annotation, ThreadLocalAdapterUtil.getClassFromThread(TEST_CLASS));
    }

    @Override
    public <T extends Annotation> T getMethodAnnotation(Class<T> annotation) {
        return AnnotationUtil.getMethodAnnotationForMethod(annotation, ThreadLocalAdapterUtil.getClassFromThread(TEST_CLASS), ThreadLocalAdapterUtil.getMethodNameFromThread(TEST_METHOD_NAME));
    }

    protected void starting() {
        this.starting(this.getClass());
    }

    protected void starting(String testName) {
        this.starting(this.getClass(), testName);
    }

    protected void starting(Class<?> testClass) {
        this.starting(testClass, testClass.getName());
    }

    protected void starting(Class<?> testClass, String testName) {
        PARAMETERS_THREAD_LOCAL.set(this.sharedMutator.getEffectiveParameters(testClass, testName, this.getDriverLifecycle()));
        SharedWebDriver sharedWebDriver = TestRunnerCommon.getTestDriver(testClass, testName, this::newWebDriver, this::failed, this.getConfiguration(), PARAMETERS_THREAD_LOCAL.get());
        ThreadLocalAdapterUtil.setTestClassAndMethodValues(PARAMETERS_THREAD_LOCAL, TEST_CLASS, TEST_METHOD_NAME);
        this.initFluent(sharedWebDriver.getDriver());
    }

    protected void finished() {
        this.finished(this.getClass());
    }

    protected void finished(String testName) {
        this.finished(this.getClass(), testName);
    }

    protected void finished(Class<?> testClass) {
        this.finished(testClass, testClass.getName());
    }

    protected void finished(Class<?> testClass, String testName) {
        ConfigurationProperties.DriverLifecycle driverLifecycle = this.getDriverLifecycle();
        SharedWebDriver sharedWebDriver = SharedWebDriverContainer.INSTANCE.getDriver(this.sharedMutator.getEffectiveParameters(testClass, testName, driverLifecycle));
        TestRunnerCommon.quitMethodAndThreadDrivers(driverLifecycle, sharedWebDriver);
        TestRunnerCommon.deleteCookies(sharedWebDriver, this.getConfiguration());
        ThreadLocalAdapterUtil.clearThreadLocals(PARAMETERS_THREAD_LOCAL, TEST_CLASS, TEST_METHOD_NAME);
        this.releaseFluent();
    }

    protected void failed() {
        this.failed(this.getClass());
    }

    protected void failed(String testName) {
        this.failed(this.getClass(), testName);
    }

    protected void failed(Class<?> testClass) {
        this.failed(testClass, testClass.getName());
    }

    protected void failed(Class<?> testClass, String testName) {
        this.failed(null, testClass, testName);
    }

    protected void failed(Throwable e, Class<?> testClass, String testName) {
        if (this.isFluentControlAvailable() && !ScreenshotUtil.isIgnoredException(e)) {
            TestRunnerCommon.doScreenshot(testClass, testName, this, this.getConfiguration());
            TestRunnerCommon.doHtmlDump(testClass, testName, this, this.getConfiguration());
        }
    }

    public static void classDriverCleanup(Class<?> testClass) {
        List<SharedWebDriver> sharedWebDrivers = SharedWebDriverContainer.INSTANCE.getTestClassDrivers(testClass);
        sharedWebDrivers.forEach(SharedWebDriverContainer.INSTANCE::quit);
    }
}

