/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volumesnapshot.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshot;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotFluent;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotFluentImpl;
import java.util.Objects;

public class VolumeSnapshotBuilder
extends VolumeSnapshotFluentImpl<VolumeSnapshotBuilder>
implements VisitableBuilder<VolumeSnapshot, VolumeSnapshotBuilder> {
    VolumeSnapshotFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeSnapshotBuilder() {
        this(false);
    }

    public VolumeSnapshotBuilder(Boolean validationEnabled) {
        this(new VolumeSnapshot(), validationEnabled);
    }

    public VolumeSnapshotBuilder(VolumeSnapshotFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public VolumeSnapshotBuilder(VolumeSnapshotFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new VolumeSnapshot(), validationEnabled);
    }

    public VolumeSnapshotBuilder(VolumeSnapshotFluent<?> fluent, VolumeSnapshot instance) {
        this(fluent, instance, false);
    }

    public VolumeSnapshotBuilder(VolumeSnapshotFluent<?> fluent, VolumeSnapshot instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public VolumeSnapshotBuilder(VolumeSnapshot instance) {
        this(instance, (Boolean)false);
    }

    public VolumeSnapshotBuilder(VolumeSnapshot instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public VolumeSnapshot build() {
        VolumeSnapshot buildable = new VolumeSnapshot(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeSnapshotBuilder that = (VolumeSnapshotBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

