package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

 /**
  * Generated
  */
public interface ServicePlanFluent<A extends ServicePlanFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ServicePlanFluent.MetadataNested<A> withNewMetadata();
  public ServicePlanFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ServicePlanFluent.MetadataNested<A> editMetadata();
  public ServicePlanFluent.MetadataNested<A> editOrNewMetadata();
  public ServicePlanFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServicePlanSpec getSpec();
  public ServicePlanSpec buildSpec();
  public A withSpec(ServicePlanSpec spec);
  public Boolean hasSpec();
  public ServicePlanFluent.SpecNested<A> withNewSpec();
  public ServicePlanFluent.SpecNested<A> withNewSpecLike(ServicePlanSpec item);
  public ServicePlanFluent.SpecNested<A> editSpec();
  public ServicePlanFluent.SpecNested<A> editOrNewSpec();
  public ServicePlanFluent.SpecNested<A> editOrNewSpecLike(ServicePlanSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServicePlanStatus getStatus();
  public ServicePlanStatus buildStatus();
  public A withStatus(ServicePlanStatus status);
  public Boolean hasStatus();
  public A withNewStatus(Boolean removedFromBrokerCatalog);
  public ServicePlanFluent.StatusNested<A> withNewStatus();
  public ServicePlanFluent.StatusNested<A> withNewStatusLike(ServicePlanStatus item);
  public ServicePlanFluent.StatusNested<A> editStatus();
  public ServicePlanFluent.StatusNested<A> editOrNewStatus();
  public ServicePlanFluent.StatusNested<A> editOrNewStatusLike(ServicePlanStatus item);
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ServicePlanFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,ServicePlanSpecFluent<ServicePlanFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,ServicePlanStatusFluent<ServicePlanFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}