package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface ServiceInstanceStatusFluent<A extends ServiceInstanceStatusFluent<A>> extends Fluent<A>{
  public Boolean getAsyncOpInProgress();
  public A withAsyncOpInProgress(Boolean asyncOpInProgress);
  public Boolean hasAsyncOpInProgress();
  public A addToConditions(int index,ServiceInstanceCondition item);
  public A setToConditions(int index,ServiceInstanceCondition item);
  public A addToConditions(io.fabric8.servicecatalog.api.model.ServiceInstanceCondition... items);
  public A addAllToConditions(Collection<ServiceInstanceCondition> items);
  public A removeFromConditions(io.fabric8.servicecatalog.api.model.ServiceInstanceCondition... items);
  public A removeAllFromConditions(Collection<ServiceInstanceCondition> items);
  public A removeMatchingFromConditions(Predicate<ServiceInstanceConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ServiceInstanceCondition> getConditions();
  public List<ServiceInstanceCondition> buildConditions();
  public ServiceInstanceCondition buildCondition(int index);
  public ServiceInstanceCondition buildFirstCondition();
  public ServiceInstanceCondition buildLastCondition();
  public ServiceInstanceCondition buildMatchingCondition(Predicate<ServiceInstanceConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<ServiceInstanceConditionBuilder> predicate);
  public A withConditions(List<ServiceInstanceCondition> conditions);
  public A withConditions(io.fabric8.servicecatalog.api.model.ServiceInstanceCondition... conditions);
  public Boolean hasConditions();
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
  public ServiceInstanceStatusFluent.ConditionsNested<A> addNewCondition();
  public ServiceInstanceStatusFluent.ConditionsNested<A> addNewConditionLike(ServiceInstanceCondition item);
  public ServiceInstanceStatusFluent.ConditionsNested<A> setNewConditionLike(int index,ServiceInstanceCondition item);
  public ServiceInstanceStatusFluent.ConditionsNested<A> editCondition(int index);
  public ServiceInstanceStatusFluent.ConditionsNested<A> editFirstCondition();
  public ServiceInstanceStatusFluent.ConditionsNested<A> editLastCondition();
  public ServiceInstanceStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ServiceInstanceConditionBuilder> predicate);
  public String getCurrentOperation();
  public A withCurrentOperation(String currentOperation);
  public Boolean hasCurrentOperation();
  public String getDashboardURL();
  public A withDashboardURL(String dashboardURL);
  public Boolean hasDashboardURL();
  public A addToDefaultProvisionParameters(String key,Object value);
  public A addToDefaultProvisionParameters(Map<String,Object> map);
  public A removeFromDefaultProvisionParameters(String key);
  public A removeFromDefaultProvisionParameters(Map<String,Object> map);
  public Map<String,Object> getDefaultProvisionParameters();
  public <K,V>A withDefaultProvisionParameters(Map<String,Object> defaultProvisionParameters);
  public Boolean hasDefaultProvisionParameters();
  public String getDeprovisionStatus();
  public A withDeprovisionStatus(String deprovisionStatus);
  public Boolean hasDeprovisionStatus();
  
  /**
   * This method has been deprecated, please use method buildExternalProperties instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceInstancePropertiesState getExternalProperties();
  public ServiceInstancePropertiesState buildExternalProperties();
  public A withExternalProperties(ServiceInstancePropertiesState externalProperties);
  public Boolean hasExternalProperties();
  public ServiceInstanceStatusFluent.ExternalPropertiesNested<A> withNewExternalProperties();
  public ServiceInstanceStatusFluent.ExternalPropertiesNested<A> withNewExternalPropertiesLike(ServiceInstancePropertiesState item);
  public ServiceInstanceStatusFluent.ExternalPropertiesNested<A> editExternalProperties();
  public ServiceInstanceStatusFluent.ExternalPropertiesNested<A> editOrNewExternalProperties();
  public ServiceInstanceStatusFluent.ExternalPropertiesNested<A> editOrNewExternalPropertiesLike(ServiceInstancePropertiesState item);
  
  /**
   * This method has been deprecated, please use method buildInProgressProperties instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceInstancePropertiesState getInProgressProperties();
  public ServiceInstancePropertiesState buildInProgressProperties();
  public A withInProgressProperties(ServiceInstancePropertiesState inProgressProperties);
  public Boolean hasInProgressProperties();
  public ServiceInstanceStatusFluent.InProgressPropertiesNested<A> withNewInProgressProperties();
  public ServiceInstanceStatusFluent.InProgressPropertiesNested<A> withNewInProgressPropertiesLike(ServiceInstancePropertiesState item);
  public ServiceInstanceStatusFluent.InProgressPropertiesNested<A> editInProgressProperties();
  public ServiceInstanceStatusFluent.InProgressPropertiesNested<A> editOrNewInProgressProperties();
  public ServiceInstanceStatusFluent.InProgressPropertiesNested<A> editOrNewInProgressPropertiesLike(ServiceInstancePropertiesState item);
  public String getLastOperation();
  public A withLastOperation(String lastOperation);
  public Boolean hasLastOperation();
  public Long getObservedGeneration();
  public A withObservedGeneration(Long observedGeneration);
  public Boolean hasObservedGeneration();
  public String getOperationStartTime();
  public A withOperationStartTime(String operationStartTime);
  public Boolean hasOperationStartTime();
  public Boolean getOrphanMitigationInProgress();
  public A withOrphanMitigationInProgress(Boolean orphanMitigationInProgress);
  public Boolean hasOrphanMitigationInProgress();
  public String getProvisionStatus();
  public A withProvisionStatus(String provisionStatus);
  public Boolean hasProvisionStatus();
  public Long getReconciledGeneration();
  public A withReconciledGeneration(Long reconciledGeneration);
  public Boolean hasReconciledGeneration();
  public A withAsyncOpInProgress();
  public A withOrphanMitigationInProgress();
  public interface ConditionsNested<N> extends Nested<N>,ServiceInstanceConditionFluent<ServiceInstanceStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  public interface ExternalPropertiesNested<N> extends Nested<N>,ServiceInstancePropertiesStateFluent<ServiceInstanceStatusFluent.ExternalPropertiesNested<N>>{
    public N and();
    public N endExternalProperties();
    
  }
  public interface InProgressPropertiesNested<N> extends Nested<N>,ServiceInstancePropertiesStateFluent<ServiceInstanceStatusFluent.InProgressPropertiesNested<N>>{
    public N and();
    public N endInProgressProperties();
    
  }
  
}