package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceBrokerStatusBuilder extends ServiceBrokerStatusFluentImpl<ServiceBrokerStatusBuilder> implements VisitableBuilder<ServiceBrokerStatus,ServiceBrokerStatusBuilder>{
  public ServiceBrokerStatusBuilder() {
    this(false);
  }
  public ServiceBrokerStatusBuilder(Boolean validationEnabled) {
    this(new ServiceBrokerStatus(), validationEnabled);
  }
  public ServiceBrokerStatusBuilder(ServiceBrokerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceBrokerStatusBuilder(ServiceBrokerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceBrokerStatus(), validationEnabled);
  }
  public ServiceBrokerStatusBuilder(ServiceBrokerStatusFluent<?> fluent,ServiceBrokerStatus instance) {
    this(fluent, instance, false);
  }
  public ServiceBrokerStatusBuilder(ServiceBrokerStatusFluent<?> fluent,ServiceBrokerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withLastCatalogRetrievalTime(instance.getLastCatalogRetrievalTime());
      fluent.withOperationStartTime(instance.getOperationStartTime());
      fluent.withReconciledGeneration(instance.getReconciledGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceBrokerStatusBuilder(ServiceBrokerStatus instance) {
    this(instance,false);
  }
  public ServiceBrokerStatusBuilder(ServiceBrokerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withLastCatalogRetrievalTime(instance.getLastCatalogRetrievalTime());
      this.withOperationStartTime(instance.getOperationStartTime());
      this.withReconciledGeneration(instance.getReconciledGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceBrokerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceBrokerStatus build() {
    ServiceBrokerStatus buildable = new ServiceBrokerStatus(fluent.getConditions(),fluent.getLastCatalogRetrievalTime(),fluent.getOperationStartTime(),fluent.getReconciledGeneration());
    return buildable;
  }
  
}