package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceBrokerBuilder extends ServiceBrokerFluentImpl<ServiceBrokerBuilder> implements VisitableBuilder<ServiceBroker,ServiceBrokerBuilder>{
  public ServiceBrokerBuilder() {
    this(false);
  }
  public ServiceBrokerBuilder(Boolean validationEnabled) {
    this(new ServiceBroker(), validationEnabled);
  }
  public ServiceBrokerBuilder(ServiceBrokerFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceBrokerBuilder(ServiceBrokerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceBroker(), validationEnabled);
  }
  public ServiceBrokerBuilder(ServiceBrokerFluent<?> fluent,ServiceBroker instance) {
    this(fluent, instance, false);
  }
  public ServiceBrokerBuilder(ServiceBrokerFluent<?> fluent,ServiceBroker instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceBrokerBuilder(ServiceBroker instance) {
    this(instance,false);
  }
  public ServiceBrokerBuilder(ServiceBroker instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceBrokerFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceBroker build() {
    ServiceBroker buildable = new ServiceBroker(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}