package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceBindingStatusBuilder extends ServiceBindingStatusFluentImpl<ServiceBindingStatusBuilder> implements VisitableBuilder<ServiceBindingStatus,ServiceBindingStatusBuilder>{
  public ServiceBindingStatusBuilder() {
    this(false);
  }
  public ServiceBindingStatusBuilder(Boolean validationEnabled) {
    this(new ServiceBindingStatus(), validationEnabled);
  }
  public ServiceBindingStatusBuilder(ServiceBindingStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceBindingStatusBuilder(ServiceBindingStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceBindingStatus(), validationEnabled);
  }
  public ServiceBindingStatusBuilder(ServiceBindingStatusFluent<?> fluent,ServiceBindingStatus instance) {
    this(fluent, instance, false);
  }
  public ServiceBindingStatusBuilder(ServiceBindingStatusFluent<?> fluent,ServiceBindingStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAsyncOpInProgress(instance.getAsyncOpInProgress());
      fluent.withConditions(instance.getConditions());
      fluent.withCurrentOperation(instance.getCurrentOperation());
      fluent.withExternalProperties(instance.getExternalProperties());
      fluent.withInProgressProperties(instance.getInProgressProperties());
      fluent.withLastOperation(instance.getLastOperation());
      fluent.withOperationStartTime(instance.getOperationStartTime());
      fluent.withOrphanMitigationInProgress(instance.getOrphanMitigationInProgress());
      fluent.withReconciledGeneration(instance.getReconciledGeneration());
      fluent.withUnbindStatus(instance.getUnbindStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceBindingStatusBuilder(ServiceBindingStatus instance) {
    this(instance,false);
  }
  public ServiceBindingStatusBuilder(ServiceBindingStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAsyncOpInProgress(instance.getAsyncOpInProgress());
      this.withConditions(instance.getConditions());
      this.withCurrentOperation(instance.getCurrentOperation());
      this.withExternalProperties(instance.getExternalProperties());
      this.withInProgressProperties(instance.getInProgressProperties());
      this.withLastOperation(instance.getLastOperation());
      this.withOperationStartTime(instance.getOperationStartTime());
      this.withOrphanMitigationInProgress(instance.getOrphanMitigationInProgress());
      this.withReconciledGeneration(instance.getReconciledGeneration());
      this.withUnbindStatus(instance.getUnbindStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceBindingStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceBindingStatus build() {
    ServiceBindingStatus buildable = new ServiceBindingStatus(fluent.getAsyncOpInProgress(),fluent.getConditions(),fluent.getCurrentOperation(),fluent.getExternalProperties(),fluent.getInProgressProperties(),fluent.getLastOperation(),fluent.getOperationStartTime(),fluent.getOrphanMitigationInProgress(),fluent.getReconciledGeneration(),fluent.getUnbindStatus());
    return buildable;
  }
  
}