package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ParametersFromSourceBuilder extends ParametersFromSourceFluentImpl<ParametersFromSourceBuilder> implements VisitableBuilder<ParametersFromSource,ParametersFromSourceBuilder>{
  public ParametersFromSourceBuilder() {
    this(false);
  }
  public ParametersFromSourceBuilder(Boolean validationEnabled) {
    this(new ParametersFromSource(), validationEnabled);
  }
  public ParametersFromSourceBuilder(ParametersFromSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ParametersFromSourceBuilder(ParametersFromSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ParametersFromSource(), validationEnabled);
  }
  public ParametersFromSourceBuilder(ParametersFromSourceFluent<?> fluent,ParametersFromSource instance) {
    this(fluent, instance, false);
  }
  public ParametersFromSourceBuilder(ParametersFromSourceFluent<?> fluent,ParametersFromSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withSecretKeyRef(instance.getSecretKeyRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ParametersFromSourceBuilder(ParametersFromSource instance) {
    this(instance,false);
  }
  public ParametersFromSourceBuilder(ParametersFromSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withSecretKeyRef(instance.getSecretKeyRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  ParametersFromSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ParametersFromSource build() {
    ParametersFromSource buildable = new ParametersFromSource(fluent.getSecretKeyRef());
    return buildable;
  }
  
}